#include <sys/param.h>
#include <sys/stat.h>

#include <test_stat_file.c>


void
test_stat_ENOENT(char *url)
{
	struct ftpstat fs;
	char path[MAXPATHLEN];

	test_login(url);

	snprintf(path, sizeof(path), "%s/libfget_test/dir1/DOES_NOT_EXIST",
		 ftpurl.fu_path);

	if (test_stat_aux(path, &fs, 0) != -1)
	{
		fprintf(stderr,
			"ftp_stat() succeeded for non-existant path \"%s\"\n",
			path);
		exit(1);
	}

	if (errno != ENOENT)
	{
		fprintf(stderr, "errno=%d, should be ENOENT\n", errno);
		exit(1);
	}
}


