fget 1.1 - 4/22/01
--------

- new fget options:
  - added "-t" option to specify connection timeout value
  - added "-T" option to specify number of connection attempts
  - added "-m" option to specify connection cache size
- fixed symlink handling:
  - don't chase symlinks by default in list mode
  - when not using host dirs, don't chase symlinks outside of the root of
    the tree we're mirroring
- if extendfs_command fails, display the error and don't retry
- fixes in fget/download.c to handle downloading the remote root directory
- do not display download progress or statistics if "-q" is specified
- libfget changes:
  - added timeout support to libfget (including API change to add an
    additional argument to ftp_connect())
  - fixed ftp_send_abort() to react well when transfer finishes normally
    before abort is processed
  - fixed ftp_realpath() to avoid prepending an extra "/" to the result
  - fixed ftp_realpath() to handle absolute symlinks
    (based on patch from Paolo Astolfi <pastolfi@datamat.it>)
  - fixed ftp_mkdir() to use correct response code
    (thanks to Jeff Meininger <jeffm@boxybutgood.com> for the bug report)
  - fixed ftp_open() to not fail when uploading new files
    (thanks to Alan Frye <alan.frye@usa.net> and
     James Myers <james@occinc.com> for reporting this)
- updated documentation
- updated autoconf macros and compat code
- reformatted code for readability
- updated listhash code and API

-----------------------------------------------------------------------------

fget 1.0.4 - 3/5/01
----------

- improved checking of FTP response codes as per RFC 959
- fixed handling of hidden root directory
- added support for Windows NT directory parsing

-----------------------------------------------------------------------------

fget 1.0.3 - 1/15/01
----------

- added "-I" option to read URLs from a file
- fixed NULL pointer dereferencing bug in fget/download.c
- create the local directory for "-C" even when "-H" is not used

-----------------------------------------------------------------------------

fget 1.0.2 - 1/8/01
----------

- updated WSG_ENCAP macro
- added autoconf glue for listhash manpages
- added autoconf check for <inttypes.h>
- added autoconf check for uint64_t

-----------------------------------------------------------------------------

fget 1.0.1 - 1/5/01
----------

- fixed a stupid boolean algebra bug in lib/dircache.c
- fixed autoconf macros to behave properly when a config.cache file
  is present

-----------------------------------------------------------------------------

fget 1.0 - 1/4/01
--------

- minor code cleanups

-----------------------------------------------------------------------------

fget 0.11.4 - 1/2/01
-----------

- make sure downloaded files are writable by the owner, unless the -P
  option is specified
- make sure to call ftp_close() when aborting a download because of a local
  file error

-----------------------------------------------------------------------------

fget 0.11.3 - 12/29/00
-----------

- updated WSG_ENCAP autoconf macro
- fixed ftp_quit() to abort and/or close the data connection, if active
- fixed a bug in fget/download.c which prepended a "/" to local path names
  when neither -C nor -H were specified
- don't delete "lost+found" directory when -r is specified
- eliminated double-slash in pathnames when retrieving remote root directory

-----------------------------------------------------------------------------

fget 0.11.2 - 12/13/00
-----------

- fixed dircache to handle "/some/path unreadable" error messages from ls

-----------------------------------------------------------------------------

fget 0.11.1 - 12/13/00
-----------

- fixed autoconf snprintf() test to make sure it NUL-terminates
- tweaked dircache code to handle FTP servers which display error messages
  from ls command
- fixed path problem using -C without -H

-----------------------------------------------------------------------------

fget 0.11 - 11/30/00
---------

- if an FTP download/list/size-estimate fails, fget will continue on to
  the next one instead of exiting
- fget returns an exit code indicating the number of non-successful
  downloads/lists/size-estimates
- added "-P" option to preserve ownership and permissions
- fixed fget/connect.c to check return value from getpwuid()
- fixed fget/download.c not to replace symlinks which already exist
- better symlink handling:
  - added fget/pathcode.c from epkg
  - replaced "-F" (follow symlinks) with "-D" (dereference symlinks)
  - new "-F" option (fix symlinks) changes absolute links to relative links
  - new "-c" option (chase symlinks) which both downloads a symlink as is
    and downloads what the link points to
- directory cache fixes:
  - better symlink handling
  - more efficient directory handling
  - added support for accessing files under hidden directories
- fixed ftp_list() to try "LIST -A", but to fall back to "LIST"
  if the first command fails or returns no data
- fixed unix_dir_parse() to handle dir listings which don't include
  the group of each file
- fixed ftp_syst() to write an empty string to ftp->ftp_systype if the
  SYST command fails
- fixed ftp_login() to not fail if ftp_syst() fails, since some older FTP
  servers don't grok the SYST command
- added $(DESTDIR) to Makefiles
- Makefile changes to support WSG_PKG and WSG_ENCAP autoconf macros

-----------------------------------------------------------------------------

fget 0.10.1 - 10/29/00
-----------

- fixed symlink-handling bug in ftp_opendir()
- centralized ftp_stat() calls into fget_recursion()
- updated README
- updated aclocal.m4
- minor directory structure changes because of CVS setup
- minor portability fixes

-----------------------------------------------------------------------------

fget 0.10 - 9/28/00
---------

- recursively remove files when the "-r" option is on
- added manpages
- removed "-D" option and global expiretime variable
- changed "int parse_url()" to "void ftp_parse_url()"
- added argument names to ftp_glob() and ftp_globfree() prototypes
- fget now accepts glob patterns in commandline URL arguments

-----------------------------------------------------------------------------

fget 0.9.1 - 8/24/00
----------

- initialized newpath to an empty string in ftp_realpath_internal()
  (thanks to Jeremy Weinberger <jeremy@northwestern.edu>)
- increased MAXUSERNAMELEN from 8 to 16
  (thanks to Jeremy Weinberger <jeremy@northwestern.edu>)
- fixed a bug involving relative paths in ftp_opendir()
- fixed a cosmetic bug involving FTP download rate output

-----------------------------------------------------------------------------

fget 0.9 - 8/18/00
--------

- added '-e' flag to estimate size of remote directory (like "du")
- added '-E command' flag to specify a command to run when there is no
  space left on the local filesystem
- completely redesigned directory caching code
- improved progress display during downloads
- added minor flexibility to unix_dir_parse()
- fixed bugs in cleanpath()
- minor portability fixes related to snprintf()

-----------------------------------------------------------------------------

fget 0.8.3 - 7/2/00
----------

- wrapped libfget.h in a "#ifndef LIBFGET_H" block to prevent multiple
  inclusions
- added libfget_version variable

-----------------------------------------------------------------------------

fget 0.8.2 - 7/2/00
----------

- fixed a bug in ftp_glob() when trying to expand a glob in the current
  directory
- fixed a bug in ftp_chdir() which didn't update the cached directory name

-----------------------------------------------------------------------------

fget 0.8.1 - 7/2/00
----------

- moved fget/url.c to lib/url.c

-----------------------------------------------------------------------------

fget 0.8 - 7/2/00
--------

- implemented ftp_glob()
- changed ftp_login() to send the REIN command if previously logged in
- added fget connection cache
- added "-H" option to use wget-style host directories
- added aclocal.m4 to clean up configure.in

-----------------------------------------------------------------------------

fget 0.7 - 6/20/00
--------

- fget now downloads directories recursively and only updates newer files
  by default (the "-R" and "-N" options are toggles)
- fget now removes local files which don't exist on server by default
  (use new "-r" option to toggle)
- multiple URLs can now be specified on the commandline; the default
  local directory is the last componant of the path of each URL
- fixed API to reference data connection from FTP handle and return EAGAIN
  when a second simultaneous connection is attempted
- if FTP_PASSIVE is set in ftp_connect()'s flags argument, all data
  connections are established in PASV mode
  (replaced old ftp_open() flags argument with mode argument, which must
  be set to either FTP_READ or FTP_WRITE)
- major directory cache changes to accomodate systems which don't list
  "." and ".." in LIST output

-----------------------------------------------------------------------------

fget 0.6 - 6/16/00
--------

- improved directory cache performance by using hashes instead of lists
- added symlink support:
  - implemented ftp_lstat(), ftp_readlink(), and ftp_realpath()
  - changed ftp_opendir() and ftp_stat() to chase symlinks
  - added "-F" option to fget
- added interval-based expiration of dircache entries
  - default is 5 minutes
  - can use ftp_set_cache_expiretime() to override expiration interval
  - added "-D" option to fget
- ftp_pwd() renamed to ftp_getcwd()
- significant rewrite of fget recursion code for efficiency and modularity
- added "-p" option to select PASV mode for file downloads

-----------------------------------------------------------------------------

fget 0.5.2 - 6/14/00
----------

- fixed ftp_init_buf() macro to NULL-terminate the buffer
  (was causing a segfault in long recursive directory listings)
- fixed bug in fget/fget.c which caused recursion problems by using the
  static buffer returned by basename() as an argument to download_tree()
- fget will create local directory tree if needed for mirroring
- changed strtomode() in lib/ftpstat.c to report parse errors

-----------------------------------------------------------------------------

fget 0.5.1 - 6/13/00
----------

- fixed endianness bugs in lib/ftpdata.c
- fixed various Makefile bugs relating to objdirs
- added getsockname() call in lib/ftpdata.c to fix portability for
  platforms where bind() doesn't write the port number to the addr structure
- include <netinet/in.h> in lib/handle.c to get sockaddr_in declaration

-----------------------------------------------------------------------------

fget 0.5 - 6/12/00
--------

- free dir cache memory in ftp_quit()
- implemented ftp_lseek() for FTP_READ connections
- implemented the ABOR command within ftp_lseek() and ftp_quit()
- renamed libftp to libfget
- implemented ftp_telldir(), ftp_seekdir(), and ftp_rewinddir()
- implemented ftp_opts()
- added "-N" option to fget for mirroring files based on modification time

-----------------------------------------------------------------------------

fget 0.4 - 6/11/00
--------

- various code cleanups:
  - eliminated strtok_r()
  - use a caller-supplied buffer in my_realpath() instead of returning
    dynamically-allocated memory
  - use ftp_init_buf() macro everywhere
  - added vftp_send_command() for use in ftp_data_connect()
  - moved ftp_list() call from ftp_dircache() to ftp_opendir() and ftp_stat()
- fixed many bugs in directory caching code
- rewrote my_realpath()
- added "-C dir" and "-R" options to fget
- fget now prompts for password if username is encoded in URL but password
  isn't given

-----------------------------------------------------------------------------

fget 0.3 - 6/5/00
--------

- added directory caching mechanism
- implemented ftp_stat()
- added -l flag to fget for listing files instead of downloading them
- added -d flag to activate debugging
- changed ftp_connect() to grok ':'-delimited port number in host string
- moved login code into ftp_login() function
- copied lib/util.c code from libencap (still needs some cleaning up)
- current directory is now cached locally
- added ftp_feat() call

-----------------------------------------------------------------------------

fget 0.2 - 6/4/00
--------

- improved ftp_readdir() interfaces
- changed several tests in configure.in
- moved RFC-959 and draft-ietf-ftpext-mlst-10.txt to doc subdirectory
- moved file downloading code to fget/download.c
- added URL-parsing code in fget/url.c
- added directory listing code in fget/output.c
- added current list and hash code from epkg in preperation for dir caching
- added UNIX directory parsing code in lib/ftpstat.c
- added strmode() compat code
- moved misc functions from lib/ftpdir.c to lib/ftpops.c
- changed ftp_site() to handle commands which require a data connection
- changed ftp_systype() to cache value in FTP structure
- added ftp_status() function
- fixed ftp_get_response() to handle multi-line responses with no response
  code on intervening lines

-----------------------------------------------------------------------------

fget 0.1 - 6/3/00
--------

- Initial alpha release.

