fget 1.2.9 - 10/20/02
----------

- fixed bug in IIS virtual directory handling that prevented the
  dircache from returning ENOENT
  (thanks to Nerijus Baliunas <nerijus@users.sourceforge.net> and
   Charley LeCrone <lecrone@uiuc.edu> for the bug reports)
- fixed syntax error in fget/recursion.c that caused misleading error
  message when ftp_stat() failed
- call shutdown() before closing control and data connections
  (thanks to Mike Drzal <drzal@uiuc.edu> for the bug report)
- set FTP handle to NULL when ftp_connect() fails
  (thanks to Mike Drzal <drzal@uiuc.edu> for the suggestion)
- updated COPYRIGHT file
- restructured autoconf macros

-----------------------------------------------------------------------------

fget 1.2.8 - 4/26/02
----------

- fixed dircache to handle IIS virtual directories
- add package-specific prefix to shared pathcode functions to avoid
  duplicate symbol errors from some versions of ld
- updated for autoconf-2.53
- fixed a long-standing bug that caused a segfault in list mode
  (thanks to Stoned Elipot <seb@script.jussieu.fr> for the bug report)
- retry connections on ECONNRESET as well as ETIMEDOUT
  (thanks to "oliver d.tali" <odt@hot.ee> for the bug report)
- fix ftp_open() to set ftpfile to NULL when data connection fails

-----------------------------------------------------------------------------

fget 1.2.7 - 2/18/02
----------

- removed unused FTP handle pointer in struct ftp_url
- avoid horkage if a command line URL specifies a non-existant file
- fixed bug in ftp_opendir() which sometimes succeeded on a non-existant
  directory
- minor directory structure changes to accomodate pathcode CVS module
- improved Makefile portability
- fixed ftp_parse_url() to not stomp on trailing '/' of single-character
  path name (i.e., root directory)
- fixed unix_dir_parse() to handle output from "MACOS" FTP server
- fixed dircache bug when examining the root directory
- added fget "-s" option to replace files which are a different size on
  the server (on by default)
  (based on suggestions from Nerijus Baliunas <nerijus@users.sourceforge.net>
  and "Peter A. Castro" <doctor@fruitbat.org>)
- renamed ftp_parse_url() to ftp_url_parse() and cleaned up interface
  (applications can build with -DFTP_URL_COMPAT to use old interface for
  now, but this will eventually go away)

-----------------------------------------------------------------------------

fget 1.2.6 - 10/17/01
----------

- fixed ftp_parse_url() to not modify the URL argument
- fixed local directory location when URL points to a file and "-H" is used
- fixed ftp_systype() to default to "Unknown" if the server returns a
  500 response code
- fixed ftp_list_parse() to choose directory parsing function semanticly
  (thanks to Nerijus Baliunas <nerijus@users.sourceforge.net> for the
  bug report)
- updated to autoconf-2.52
- fixed various timeout problems when server abruptly drops the connection

-----------------------------------------------------------------------------

fget 1.2.5 - 7/26/01
----------

- fixed dircache problem which caused ftp_opendir() to fail when called
  twice on the same directory

-----------------------------------------------------------------------------

fget 1.2.4 - 7/20/01
----------

- fixed ftp_data_connect() to grok FTP response code 125
  (based on patch from Dave Hill <dhill@zeus.com>)
- fixed endianness problems for PASV connections in ftp_data_connect()
  (based on patch from Dave Hill <dhill@zeus.com>)
- improve flexibility in parsing PASV response

-----------------------------------------------------------------------------

fget 1.2.3 - 6/15/01
----------

- fixed ftp_data_connect() to return EACCES instead of ENOENT for a
  550 response code
- fixed dircache bug which caused ftp_lstat("/") to fail
  (thanks to Leo Khramov <leo@solvo.ru> for the bug report)
- fixed dircache symlink handling bugs
  (based on patch from Paolo Astolfi <pastolfi@datamat.it>)

-----------------------------------------------------------------------------

fget 1.2.2 - 5/31/01
----------

- fix unix_dir_parse() to handle output with no space between mode and
  nlink
- improve hash function for directory hash
- don't call fget_list_next() after fget_list_del() in ftp_dc_expire()
  (thanks to Charley LeCrone <lecrone@uiuc.edu> for the bug report)
- changed default cache expiration interval to -1
- minor documentation fixes

-----------------------------------------------------------------------------

fget 1.2.1 - 5/30/01
----------

- fixed a symlink bug in fget_download_root()
- fixed cosmetic problem in fget_download() to avoid double '/' in
  pathnames
- rewrote cleanpath() and relativepath() to use static buffers

-----------------------------------------------------------------------------

fget 1.2.0 - 5/25/01
----------

- find absolute path in ftp_realpath() before calling ftp_dircache_realpath()
- added ftp_data_fd() function to return the file descriptor of the
  FTP data connection
- various man page fixes

-----------------------------------------------------------------------------

fget 1.2.dev4 - 5/21/01
-------------

- try to work around broken FTP servers which don't grok spaces in
  directory names for LIST, but do for CWD
  (based on patch from Stephen Veit <sveit@earthlink.net>)
- fixed a bug in ftp_get_response() which only returned the last line
  of a multi-line response
- started working on MLSD support (not currently enabled)
- renamed fs_date field to fs_mtime in struct ftpstat
- added fs_rdev field to struct ftpstat
- fixed dircache to avoid refreshing directories whose parent is hidden

-----------------------------------------------------------------------------

fget 1.2.dev3 - 5/18/01
-------------

- fixed dircache to handle ftp_stat() for a top-level directory name
- fixed ftp_list() to read a response code before aborting
- fixed lib/Makefile.in to not install <fget_listhash.h>, since it's no
  longer part of the public API

-----------------------------------------------------------------------------

fget 1.2.dev2 - 5/17/01
-------------

- fixed ftp_list() and ftp_opendir() to handle empty directories differently
  from hidden directories
- fixed ftp_opendir() and ftp_closedir() to copy filenames from dir
  cache instead of using references to the internal copy
- fixed fget_download() to print error message when remote path does not exist
- fixed fget_download() to call fget_delete_local() for the local root path
- fixed dircache code to handle ftp_stat() for a directory name

-----------------------------------------------------------------------------

fget 1.2.dev1 - 5/17/01
-------------

- changed ftp_opendir() and ftp_readdir() to copy data from cache
  to avoid problems with cache expiration while dir is open
- fixed some NULL pointer references in ftp_dc_refresh_directory()
  when reading a hidden directory
- moved definitions of ftp, ftpdir, and ftpfile structures out of
  <libfget.h> so that they are not part of the public API
- implemented get and set method functions to access data from
  the FTP handle
- fixed cache expiration parameters to accept -1 as documented
- removed listhash code from public API

-----------------------------------------------------------------------------

fget 1.2.dev0 - 5/11/01
-------------

- various data type cleanups
  (based on patch from Jim Knoble <jmknoble@jmknoble.cx>)
- removed argument names from header file prototypes
- fixed bug in determining local directory for single-file download when
  "-H" is not specified
- rewrote directory cache to improve speed and memory consumption
- implemented dir cache expiration (note API change to add 2 additional
  arguments to ftp_connect())
- added "-M" option to specify max dir cache size
- added "-i" option to specify max dir cache refresh interval
- change ftp_open() to use O_RDONLY and R_WRONLY instead of FTP_READ
  and FTP_WRITE
- changed listhash code to keep track of number of elements
- added FGET_COMPAT preprocessor conditional in <libfget.h> for
  backward-compatability macros

