/*
**  Copyright 2000-2004 University of Illinois Board of Trustees
**  Copyright 2000-2005 Mark D. Roth
**  All rights reserved.
**
**  fget.h - main header file for fget
**
**  Mark D. Roth <roth@feep.net>
*/

#include <config.h>
#include <compat.h>
#include <libfget.h>
#include <fget_listhash.h>
#include <fget_pathcode.h>


#define FTPBUFSIZE	10240


/***** connect.c *************************************************************/

int fget_disconnect_handle(FTP *);

int fget_disconnect_all(void);

FTP *fget_connect(struct ftp_url *);


/***** delete.c **************************************************************/

/* recursively remove the specified directory */
int recursive_remove(char *);

/* delete local files which don't exist on the server */
int fget_delete_local(FTP *, char *, char *);

/* remove a file or directory */
int fget_unlink(char *, struct stat *);


/***** download.c ************************************************************/

int fget_download(FTP *, char *, char *);


/***** du.c ******************************************************************/

int fget_du(FTP *, char *);


/***** fget.c ****************************************************************/

extern unsigned short verbose;
extern unsigned long options;
extern unsigned short debug;
extern unsigned short max_sessions;
extern long max_cache_size;
extern time_t cache_expire_time;
extern time_t timeout;
extern unsigned short tries;
extern char *extendfs_command;

/* values for options bitmask */
#define OPT_RECURSIVE		(1<<0)	/* recursive listing */
#define OPT_NEWER		(1<<1)	/* only download newer files */
#define OPT_FIXLINKS		(1<<2)	/* make absolute symlinks relative */
#define OPT_DEREFLINKS		(1<<3)	/* dereference symlinks */
#define OPT_CHASELINKS		(1<<4)	/* do links and what they point to */
#define OPT_PASSIVE		(1<<5)	/* use PASV mode */
#define OPT_DELETELOCAL		(1<<6)	/* delete local files which
					   don't exist on server */
#define OPT_HOSTDIRS		(1<<7)	/* encode hostname in dir tree */
#define OPT_SAVEPERMS		(1<<8)	/* attempt to save the user, group,
					   and mode of downloaded files */
#define OPT_DIFFSIZE		(1<<9)	/* download if file size on server
					   is different from local file */
#define OPT_STRIPDIR		(1<<10)	/* strip off last path component
					   if downloading a directory */

#define DEFAULT_OPTIONS		(OPT_RECURSIVE|\
				 OPT_NEWER|\
				 OPT_DELETELOCAL|\
				 OPT_FIXLINKS|\
				 OPT_CHASELINKS|\
				 OPT_PASSIVE|\
				 OPT_DIFFSIZE)


/***** list.c ****************************************************************/

int fget_list(FTP *, char *);


/***** local.c ***************************************************************/

void fget_set_perms(char *, struct ftpstat *);

int fget_download_dir(FTP *, char *, struct ftpstat *,
		      char *, struct stat *);

int fget_download_symlink(FTP *, char *, struct ftpstat *,
			  char *, struct stat *,
			  char *, size_t);

int fget_download_regfile(FTP *, char *, struct ftpstat *,
			  char *, struct stat *);


/***** output.c **************************************************************/

void ftp_long_ls(FTP *, char *, struct ftpstat *);

void send_debug(char *, FTP *, void *);

void recv_debug(char *, FTP *, void *);


/***** recursion.c ***********************************************************/

/*
** stat an FTP file.
*/
int fget_stat(FTP *, char *, struct ftpstat *);


typedef int (*fget_plugin)(FTP *, char *, struct ftpstat *, void *);

/*
** core directory recursion.
*/
int fget_recursion(FTP *, char *, fget_plugin, void *);

/* recursion actions returned by plugins */
#define R_RETURN	-2	/* return to top level immediately */
#define R_ERR		-1	/* non-fatal error */
#define R_FILEOK	0	/* continue normally */
#define R_SKIP		1	/* skip to next file */

/* R_ERR or R_RETURN */
#define IS_ERROR(x)	((x) < 0)


/***** visit.c ***************************************************************/

/* initialize visit lists */
int init_visit_lists(void);

/* free visit lists */
void free_visit_lists(void);

/* returns 1 if we've already visited the specified path, 0 otherwise */
int already_visited(char *);

/* record the fact that we've visited a path */
int record_visit(char *);

/* record the fact that we need to visit a path */
int record_need_to_visit(char *);

/* finds the next path to visit.  returns 1 on success, 0 when no more */
int next_path_to_visit(char *buf, size_t buflen);

#ifdef DEBUG
void print_need_to_visit_list(void);
#endif


