/*
**  Copyright 2000-2004 University of Illinois Board of Trustees
**  Copyright 2000-2004 Mark D. Roth
**  All rights reserved.
**
**  internal.h - internal header file for libfget
**
**  Mark D. Roth <roth@feep.net>
*/

#include <config.h>
#include <compat.h>
#include <libfget.h>

#ifdef STDC_HEADERS
# include <stdarg.h>
#endif

#include <fget_netio.h>
#include <fget_listhash.h>
#include <fget_pathcode.h>


#define FTPBUFSIZE		10240	/* arbitrary useful length */
#define FTPSYSTYPELEN		40	/* taken from RFC-1340 */

#ifndef MAXSYMLINKS
# define MAXSYMLINKS		16	/* max number of symlinks for ELOOP */
#endif


/***** dircache.c ************************************************************/

/* dircache entry types */
enum dcent_types
{
	DCENT_DIR,			/* directory contents */
	DCENT_FILE			/* individual file listing */
};

struct file_info
{
	char fi_filename[MAXPATHLEN];
	char fi_linkto[MAXPATHLEN];
	struct ftpstat fi_stat;
};
typedef struct file_info file_info_t;

/* values for ftp_dircache_find_file() flags bitmask */
#define DC_NOFOLLOWLINKS	1	/* don't follow symlinks */

/* initialize dir cache */
void _ftp_dircache_init(FTP *);

/* free dir cache */
void _ftp_dircache_free(FTP *);

/* get file info from dir cache */
int _ftp_dircache_find_file(FTP *, char *, unsigned short, file_info_t **);

/* get dir info from dir cache */
int _ftp_dircache_find_dir(FTP *, char *, fget_hash_t **);


/***** ftplist.c *************************************************************/

/* typedef for LIST response parsing functions */
typedef int (*ftp_list_parse_func_t)(FTP *, char *, file_info_t *);

/* return values for LIST response parsing functions */
#define FLP_VALID			0	/* valid entry */
#define FLP_IGNORE			1	/* ignore line */
#define FLP_ERROR			-1	/* error - sets errno */

/* values for _ftp_list() flags argument */
#define FL_TRY_NO_LS_OPTS	1	/* try again without ls(1) opts */

/* returns number of entries in directory */
int _ftp_list(FTP *, char *, fget_hash_t *, enum dcent_types, unsigned long);


/***** handle.c **************************************************************/

/* structure for FTP handle */
struct ftp
{
	/*
	** network I/O handles
	*/
	NETIO *ftp_control;		/* FTP control connection */
	NETIO *ftp_data;		/* FTP data connection */
	NETIO *ftp_data_listen;		/* listener for PORT mode */

	/*
	** options set by the calling application
	*/
	unsigned long ftp_flags;	/* flags bitmask (see below) */
	time_t ftp_io_timeout;		/* timeout for I/O operations */
	long ftp_cache_maxsize;		/* dir cache max size */
	time_t ftp_cache_expire;	/* interval before cache expiration */
	ftp_hookfunc_t ftp_send_hook;	/* debug hook for sending */
	ftp_hookfunc_t ftp_recv_hook;	/* debug hook for receiving */
	void *ftp_hook_data;		/* arg for send/recv hooks */
	ftp_list_parse_func_t ftp_list_parse_function;
					/* function to parse LIST responses */

	/*
	** state information kept by libfget - may not be modified by caller
	*/
	char ftp_dir[MAXPATHLEN];		/* current directory */
	char ftp_login[MAXUSERNAMELEN];		/* remote username */
	char ftp_systype[FTPSYSTYPELEN];	/* remote system type */
	char ftp_type[5];			/* current "TYPE" setting */
	unsigned long ftp_features;	/* server features (see below) */
	fget_hash_t *ftp_dc_h;		/* directory cache */
	fget_list_t *ftp_dc_age_l;	/* dir cache expiration queue */
	unsigned long ftp_dc_size;	/* directory cache size */
};


/* values for ftp_flags bitmask */
#define FTP_FLAG_USE_PASV		1	/* use PASV mode */
#define FTP_FLAG_USE_MLST		2	/* use MLST/MLSD */
#define FTP_FLAG_USE_ABOR		4	/* use ABOR */

/* values for ftp_features bitmask */
#define FTP_FEAT_FEAT		   1	/* supports FEAT and OPTS */
#define FTP_FEAT_SIZE		   2	/* supports SIZE command */
#define FTP_FEAT_MDTM		   4	/* supports MDTM command */
#define FTP_FEAT_REST_STREAM	   8	/* supports REST for STREAM xfers */
#define FTP_FEAT_TVFS		  16	/* supports TVFS presentation */
#define FTP_FEAT_MLST		  32	/* supports MLST and MLSD */
#define FTP_FEAT_NO_LIST_LS_OPTS  64	/* server doesn't grok ls options
					   in "LIST" command */

/* option negotiation */
int _ftp_opts(FTP *, char *, char *);


/***** options.c *************************************************************/

void _ftp_init_options(FTP *);

void _vftp_set_options(FTP *, va_list);


/***** ftpfile.c *************************************************************/

int _vftp_open_aux(FTPFILE **, FTP *, int, char *, va_list);

int _ftp_open_aux(FTPFILE **, FTP *, int, char *, ...);


/***** ftpdata.c *************************************************************/

/* initialize an ftp-data connection */
int _ftp_data_init(FTP *);

/* establish an ftp-data connection */
int _vftp_data_start(FTP *, char *, va_list);
int _ftp_data_start(FTP *, char *, ...);

/* establish an ftp-data connection */
int _vftp_data_connect(FTP *, char *, va_list);
int _ftp_data_connect(FTP *, char *, ...);

/* close data connection */
void _ftp_data_close_fd(FTP *);
int _ftp_data_close(FTP *);

/* read from ftp-data connection */
ssize_t _ftp_data_read(FTP *, char *, size_t);

/* write to ftp-data connection */
ssize_t _ftp_data_write(FTP *, char *, size_t);


/***** list_parse_dummy.c ****************************************************/

int _ftp_list_parse_dummy(FTP *, char *, file_info_t *);


/***** list_parse_eplf.c *****************************************************/

int _ftp_list_parse_eplf(FTP *, char *, file_info_t *);


/***** list_parse_mlsd.c *****************************************************/

int _ftp_opts_mlsd(FTP *);

int _ftp_list_parse_mlsd(FTP *, char *, file_info_t *);


/***** list_parse_nt.c *******************************************************/

int _ftp_list_parse_nt(FTP *, char *, file_info_t *);


/***** list_parse_unix.c *****************************************************/

int _ftp_list_parse_unix(FTP *, char *, file_info_t *);


/***** ftpstat.c *************************************************************/

/* determine the absolute pathname of the file or dir specified by path */
int _ftp_abspath(FTP *, char *, char *, size_t);


/***** protocol.c ************************************************************/

struct ftp_response
{
	int code;
	char buf[FTPBUFSIZE];
};
typedef struct ftp_response FTPREPLY;

/* ftp_get_response() - read and parse a response from the server. */
int _ftp_get_response(FTP *, int *, char *, size_t);

/* variable-argument version of ftp_send_command() */
int _vftp_send_command(FTP *, char *, va_list);

/* ftp_send_command() - send a command to the server */
int _ftp_send_command(FTP *, char *, ...);


