/*
**  Copyright 2000-2004 University of Illinois Board of Trustees
**  Copyright 2000-2004 Mark D. Roth
**  All rights reserved.
**
**  list_parse_dummy.c - bare-bones FTP directory parsing code
**
**  Mark D. Roth <roth@feep.net>
*/

#include <internal.h>

#include <stdio.h>
#include <time.h>
#include <sys/stat.h>

#ifdef STDC_HEADERS
# include <string.h>
#endif


/* handle entries that list only the filename */
int
_ftp_list_parse_dummy(FTP *ftp, char *buf, file_info_t *fip)
{
#ifdef DEBUG
	printf("==> _ftp_list_parse_dummy(buf=\"%s\", fip=0x%lx)\n", buf, fip);
#endif

	strlcpy(fip->fi_filename, buf, sizeof(fip->fi_filename));

	/*
	** use bogus info for missing fields
	** everything else was set to 0 by calloc()
	** note: don't assume S_IFREG for fs_mode, since it might
	**       be a directory
	*/
	fip->fi_stat.fs_mode = S_IRWXU | S_IRWXG | S_IRWXO;
	fip->fi_stat.fs_nlink = 1;
	strlcpy(fip->fi_stat.fs_username, "-1",
		sizeof(fip->fi_stat.fs_username));
	strlcpy(fip->fi_stat.fs_groupname, "-1",
		sizeof(fip->fi_stat.fs_groupname));

#ifdef DEBUG
	printf("<== _ftp_list_parse_dummy(): returning entry for \"%s\"\n",
	       fip->fi_filename);
#endif
	return FLP_VALID;
}


