#include <sys/param.h>
#include <sys/stat.h>

#include <test_login.c>

int
test_lstat_aux(char *path, struct ftpstat *fsp, int exit_on_fail)
{
	int i;

	i = ftp_lstat(ftp, path, fsp);

	if (i == -1)
	{
		fprintf(stderr, "ftp_lstat(\"%s\"): %s\n",
			path, strerror(errno));
		if (exit_on_fail)
			exit(1);
	}

	return i;
}


void
test_lstat(char *url)
{
	struct ftpstat fs;
	char path[MAXPATHLEN];

	test_login(url);

	snprintf(path, sizeof(path), "%s/libfget_test/link1",
		 ftpurl.fu_path);

	test_lstat_aux(path, &fs, 1);

	if (!S_ISLNK(fs.fs_mode))
	{
		fprintf(stderr, "S_ISLNK() is false for \"%s\"\n", path);
		exit(1);
	}
}


