#include <sys/param.h>
#include <sys/stat.h>

#include <test_login.c>

int
test_open_aux(char *path, int mode, FTPFILE **ftpfile, int exit_on_fail)
{
	int i;

	i = ftp_open(ftpfile, ftp, path, mode);

	if (i == -1)
	{
		fprintf(stderr, "ftp_open(\"%s\", %d): %s\n",
			path, mode, strerror(errno));
		if (exit_on_fail)
			exit(1);
	}

	return i;
}


void
test_open(char *url)
{
	char path[MAXPATHLEN];
	FTPFILE *ftpfile;

	test_login(url);

	snprintf(path, sizeof(path), "%s/libfget_test/long.txt",
		 ftpurl.fu_path);

	test_open_aux(path, O_RDONLY, &ftpfile, 1);
}


