#include <string.h>
#include <sys/param.h>

#include <test_login.c>

int
test_opendir_aux(char *subdir, int exit_on_fail)
{
	char buf[MAXPATHLEN];
	FTPDIR *ftpdir = NULL;
	struct ftpdirent fde;
	char *entries[] = {
		".",
		"..",
		"foo",
		NULL
	};
	int i;

	snprintf(buf, sizeof(buf), "%s/libfget_test/%s",
		 ftpurl.fu_path, subdir);

	if (ftp_opendir(&ftpdir, ftp, buf) == -1)
	{
		fprintf(stderr, "ftp_opendir(\"%s\"): %s\n",
			buf, strerror(errno));
		if (exit_on_fail)
			exit(1);
		return -1;
	}

	for (i = 0; entries[i] != NULL; i++)
	{
		if (ftp_readdir(ftpdir, &fde) == 0)
		{
			fprintf(stderr,
				"ftp_readdir() returned 0 on entry %d\n",
				i);
			if (exit_on_fail)
				exit(2);
			return -2;
		}

		if (strcmp(fde.fd_name, "foo") == 1)
		{
			fprintf(stderr,
				"entry %d: got \"%s\", expecting \"%s\"\n",
				i, fde.fd_name, entries[i]);
			if (exit_on_fail)
				exit(2);
			return -2;
		}
	}

	if (ftp_readdir(ftpdir, &fde) == 1)
	{
		fprintf(stderr,
			"ftp_readdir() returned 1, but no more entries expected"
			" - fde.fd_name=\"%s\"\n",
			fde.fd_name);
		if (exit_on_fail)
			exit(2);
		return -2;
	}

	ftp_closedir(ftpdir);
}


void
test_opendir(char *url)
{
	test_login(url);
	test_opendir_aux("dir1", 1);
}


