#include <sys/param.h>
#include <sys/stat.h>

#include <test_login.c>

int
test_stat_aux(char *path, struct ftpstat *fsp, int exit_on_fail)
{
	int i;

	i = ftp_stat(ftp, path, fsp);

	if (i == -1)
	{
		fprintf(stderr, "ftp_stat(\"%s\"): %s\n",
			path, strerror(errno));
		if (exit_on_fail)
			exit(1);
	}

	return i;
}


void
test_stat_file(char *url)
{
	struct ftpstat fs;
	char path[MAXPATHLEN];

	test_login(url);

	snprintf(path, sizeof(path), "%s/libfget_test/dir1/foo",
		 ftpurl.fu_path);

	test_stat_aux(path, &fs, 1);

	if (!S_ISREG(fs.fs_mode))
	{
		fprintf(stderr, "S_ISREG() is false for \"%s\"\n", path);
		exit(1);
	}
}


