/******************************************************************** 
   Copyright (C) 2001 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <errno.h>

#include <gtk/gtk.h>
#include <gnome.h>

#include "connection.h"
#include "protocol.h"
#include "messages.h"
#include "transaction.h"
#include "guiprefs.h"
#include "agreement.h"
#include "userlist.h"
#include "login.h"
#include "main.h"
#include "users.h"
#include "hldat.h"

#define AGREEMENT "Agreement"

typedef struct {
  char *text;
  Connection *c;
  gboolean shown;
  GtkWidget *window;
} Agreement;

static void agreement_destroy(Connection *c,gpointer p){
  Agreement *a=(Agreement *)p;
  connection_set_data(c,AGREEMENT,NULL);
  if(a==NULL)
    return;
  if(a->text!=NULL)
    free(a->text);
  if(a->window!=NULL)
    gtk_widget_destroy(a->window);
  gtk_signal_disconnect_by_data(GTK_OBJECT(c),a);
  free(a);
}

static gboolean close_agreement(GtkWidget *b,gpointer p){
  Agreement *a=(Agreement *)p;

  if(a->window!=NULL)
    gtk_widget_destroy(a->window);
  a->window=NULL;
  return FALSE;
}

static gint close_agreement_window(GtkWidget *widget,gpointer p){
  Agreement *a=(Agreement *)p;
  a->window=NULL;
  return FALSE;
}

static void show_agreement_dialog(Agreement *a,int all_buttons){
  GtkWidget *w,*text,*scrol,*parent=NULL;

  if(a->c->gui!=NULL)
    parent=a->c->gui->main_window;
  if(all_buttons==TRUE){
    w=gnome_dialog_new(_("Agreement"),_("Decline"),_("Accept"),NULL);
    gnome_dialog_button_connect(GNOME_DIALOG(w),1,
				GTK_SIGNAL_FUNC(close_agreement),
				(gpointer)a);
  } else {
    w=gnome_dialog_new(_("Agreement"),GNOME_STOCK_BUTTON_CLOSE,NULL);
  }
  a->window=w;
  gnome_dialog_button_connect(GNOME_DIALOG(w),0,
			      GTK_SIGNAL_FUNC(close_agreement),
			      (gpointer)a);
  if(parent!=NULL)
    gnome_dialog_set_parent(GNOME_DIALOG(w),GTK_WINDOW(parent));
  scrol=gtk_scrolled_window_new(NULL,NULL);
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(w)->vbox),scrol,TRUE,TRUE,0);

  text=gtk_text_new(NULL,NULL);
  gtk_container_add(GTK_CONTAINER(scrol),text);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrol),
				 GTK_POLICY_NEVER,
				 GTK_POLICY_ALWAYS);
  gtk_text_set_editable(GTK_TEXT(text),FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(text),TRUE);
  gtk_text_insert(GTK_TEXT(text),NULL,NULL,NULL,a->text,-1);
  guiprefs_widget_set_font(text,&agreement_font);
  
  gtk_widget_set_usize(w,350,450);
  gnome_dialog_close_hides(GNOME_DIALOG(w),FALSE);
  gtk_signal_connect(GTK_OBJECT(w),"destroy",
		     GTK_SIGNAL_FUNC(close_agreement_window),(gpointer)a);
  guiprefs_add_window(GTK_WINDOW(w),"Main/Agreement/Size");
  gtk_widget_show_all(w);  
}

void show_agreement(Connection *c){
  Agreement *a=(Agreement *)connection_get_data(c,AGREEMENT);
  if(a==NULL || a->window!=NULL)
    return;
  if(a->c->gui!=NULL && a->text!=NULL)
    gtk_widget_set_sensitive(a->c->gui->toolbar_info[0].widget,TRUE);
  if(!(a->shown==FALSE && dont_show_agreements==TRUE) &&
     a->text!=NULL)
    show_agreement_dialog(a,a->shown?FALSE:TRUE);
  a->shown=TRUE;
}

static gboolean attach_agreement(gpointer data){
  Connection *c=(Connection *)data;
  Agreement *a=(Agreement *)connection_get_data(c,AGREEMENT);

  if(dont_show_agreements==FALSE && a->text!=NULL)
    show_agreement_dialog(a,TRUE);
  return FALSE;
}

void handle_server_agreement(Connection *c,Message *m,gpointer data){
  Agreement *a=(Agreement *)malloc(sizeof(Agreement));

  a->c=c;
  a->window=NULL;
  a->shown=FALSE;
  a->text=NULL;
  if(!message_find_object(m, HLO_OMITAGREEMENT))
  {
    HLObject *o;
  
    o=message_find_object(m,HLO_MESSAGE);
    if(o!=NULL){
      string_net_to_unix(o);
      a->text=strdup(o->data.string);
    }
  }
  message_unref(m);
  connection_set_data(c,AGREEMENT,a);
  gtk_signal_connect(GTK_OBJECT(c),"destroy",GTK_SIGNAL_FUNC(agreement_destroy),a);
  if(c->version==0)
    attach_agreement(c);
  else
    login_done_after_agreement(c);
}
