#ifndef BOOKMARKS_H
#define BOOKMARKS_H

typedef struct Bookmark_ Bookmark;
typedef struct Tracker_ Tracker;

#ifndef TASKS_H
#include "tasks.h"
#endif

struct Bookmark_ {
  char *name,*host,*login,*passwd;
  int port;
};

struct Tracker_ {
  char *name,*host;
  int port;
  gboolean selected;
  gboolean running;
};

extern GList *Trackers;

void init_bookmarks(void);
void show_bookmarks(void);
void write_bookmarks(void);
void new_trackers(void);
void show_trackers(void);
void add_bookmark(Bookmark *);
Bookmark *dup_bookmark(Bookmark *bm);
void free_bookmark(Bookmark *bm);


Bookmark *bookmark_dialog(Bookmark *bookmark,const char *name,
			  GtkWidget *parent_window);

#endif
