/******************************************************************** 
   Copyright (C) 2001 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gnome.h>

#include "connection.h"
#include "protocol.h"
#include "messages.h"
#include "transaction.h"
#include "guiprefs.h"
#include "guiutils.h"
#include "connection.h"
#include "userwidget.h"
#include "hldat.h"
#include "users.h"
#include "privchat.h"
#include "chat.h"

void chat_pane_send_chat(Connection *c,ChatWindowWidgets *cww, HLObject *chatwindow, int emote){
  char *text;
  Message *m;
  
  text=gtk_editable_get_chars(GTK_EDITABLE(cww->message),0,-1);
  if(text!=NULL){
    if(strlen(text)!=0){
      m=message_new(c,HLCI_SENDCHAT);
      gtk_entry_set_text(GTK_ENTRY(cww->message),"");
      message_add_object(m,create_string(HLO_MESSAGE,text));
      if(chatwindow!=NULL)
	message_add_object(m,chatwindow);
      if(emote)
        message_add_object(m,create_number(HLO_PARAMETER,1));
      message_fire_and_forget(m);
    }
    free(text);
  }
}

static void cp_say(ChatWindowWidgets *cww, int as_emote){
  if(cww->sendmsg!=NULL)
    cww->sendmsg(cww,cww->user_data,as_emote);
}
static void cp_speak(GtkWidget *e, ChatWindowWidgets *cww){
  cp_say(cww,FALSE);
}
static void cp_emote(GtkWidget *e, ChatWindowWidgets *cww){
  cp_say(cww,TRUE);
}
static void cp_check_emote(GtkWidget *e, GdkEventKey *ev, ChatWindowWidgets *cww){
  if(ev->keyval==GDK_Return && (ev->state&GDK_CONTROL_MASK))
    cp_say(cww,TRUE);
}

void chat_pane_create(NotebookPage *nb,ChatWindowWidgets *cww,gboolean with_title){
  GtkWidget *vbox,*hbox,*sl;
 
  vbox=gtk_vbox_new(FALSE,1);
  if(with_title){
    hbox=gtk_hbox_new(FALSE,1);
    gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new(_("Subject:")),FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox),cww->subject=gtk_entry_new(),TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
  } else {
    cww->subject=NULL;
  }
  sl=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sl),
				 GTK_POLICY_NEVER,
				 GTK_POLICY_ALWAYS);
  cww->textarea=gtk_text_new(NULL,NULL);
  guitils_text_add_popup_clear(GTK_TEXT(cww->textarea));
  gtk_text_set_editable(GTK_TEXT(cww->textarea),FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(cww->textarea),TRUE);
  guiprefs_widget_set_font(cww->textarea,&chat_font);
  gtk_container_add(GTK_CONTAINER(sl),cww->textarea);
  gtk_box_pack_start(GTK_BOX(vbox),sl,TRUE,TRUE,0);
  
  hbox=gtk_hbox_new(FALSE,1);
  gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(hbox),cww->message=gtk_entry_new(),TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(cww->message),"activate",
		     GTK_SIGNAL_FUNC(cp_speak),(gpointer)cww);
  gtk_signal_connect(GTK_OBJECT(cww->message),"key-press-event",
		     GTK_SIGNAL_FUNC(cp_check_emote),(gpointer)cww);
  cww->send=gtk_button_new_with_label(_("Send"));
  gtk_signal_connect(GTK_OBJECT(cww->send),"clicked",
		     GTK_SIGNAL_FUNC(cp_speak),(gpointer)cww);
  gtk_box_pack_start(GTK_BOX(hbox),cww->send,FALSE,FALSE,1);
  cww->emote=gtk_button_new_with_label(_("Emote"));
  gtk_signal_connect(GTK_OBJECT(cww->emote),"clicked",
		     GTK_SIGNAL_FUNC(cp_emote),(gpointer)cww);
  gtk_box_pack_start(GTK_BOX(hbox),cww->emote,FALSE,FALSE,1);
  gutils_nbpage_set_main_with_userlist(nb,vbox,&cww->userwidget);
  cww->nb=nb;
}

void chat_pane_handle_chat(ChatWindowWidgets *cww,Message *m){
  HLObject *message=message_find_object(m,HLO_MESSAGE);

  if(message!=NULL && cww->userwidget!=NULL && cww->userwidget->c!=NULL){
    chat_pane_add_text(cww,message->data.string);
  }
  message_unref(m);
}

void chat_pane_add_text(ChatWindowWidgets *cww,char *text){
  char **arr;
  int i;
  if(text[0]=='\r')
    text++;
  arr=g_strsplit(text,"\r",0);
  if(arr!=NULL){
    for(i=0;arr[i]!=NULL;i++){
      if(userlist_get_ignored_by_string(cww->userwidget->c,arr[i])==FALSE){
	gtk_text_insert(GTK_TEXT(cww->textarea),NULL,NULL,NULL,arr[i],-1);
	gtk_text_insert(GTK_TEXT(cww->textarea),NULL,NULL,NULL,"\n",-1);
	guiutils_nbpage_highlight(cww->nb);
      }
    }
    g_strfreev(arr);
  }
}

/* ===================================== */

void chat_receive_mesasage(Connection *c,Message *m,gpointer data){
  HLObject *w=message_find_object(m,HLO_CHATWINDOW);

  if(w!=NULL){
    privchat_handle_chat(m->c,m,NULL);
  } else {
    pubchat_handle_received_message(m);
  }
}
