#ifndef CONNECTION_H
#define CONNECTION_H

typedef struct Connection_ Connection;

#ifndef GNOME_H
#include <gnome.h>
#endif
#ifndef TASKS_H
#include "tasks.h"
#endif
#ifndef BOOKMARKS_H
#include "bookmarks.h"
#endif
#ifndef MESSAGES_H
#include "messages.h"
#endif
#ifndef TRANSACTION_H
#include "transaction.h"
#endif

typedef struct {
  GnomeUIInfo *toolbar_info;
  GtkWidget *main_window;
  GtkWidget *notebook;
  GtkWidget *hbox;
} ConnectionGui;

typedef struct {
  GtkObjectClass parent_klass;
  void (*connected)(Connection *);
} ConnectionClass;


struct Connection_ {
  GtkObject parent_object;
  Bookmark *bookmark;
  int connection_fd;
  GIOChannel *channel;
  int rwatch,wwatch,errwatch;
  Task *task;
  int version;
  int server_socket_no;
  GList *requests_pending;
  GList *replies_pending;
  GList *hooks;
  ConnectionGui *gui;

  char *rcvbuffer;
  int rcvbuf_size,rcvbuf_cur;
  Message *rcvmsg;
};

GtkType connection_get_type(void);
#define CONNECTION_TYPE	     (connection_get_type())
#define CONNECTION(obj)	     (GTK_CHECK_CAST((obj), CONNECTION_TYPE, Connection))
#define CONNECTION_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), CONNECTION_TYPE, ConnectionClass))
#define IS_CONNECTION(obj)	     (GTK_CHECK_TYPE((obj), CONNECTION_TYPE))
#define IS_CONNECTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), CONNECTION_TYPE))


#define connection_ref(m) gtk_object_ref(GTK_OBJECT(m))
#define connection_unref(m) gtk_object_unref(GTK_OBJECT(m))

#define connection_set_data(c,d,v) gtk_object_set_data(GTK_OBJECT(c),d,v)
#define connection_get_data(c,d)   gtk_object_get_data(GTK_OBJECT(c),d)


typedef void (*ConnectionFunc)(Connection *, gpointer); 
typedef void (*ConnectionMsgFunc)(Connection *,Message *,gpointer);

#define C_NAME(c) (strlen(c->bookmark->name) ? c->bookmark->name:c->bookmark->host)
Task *task_new_cname(const Connection *c);

void connection_new_to(Bookmark *b);

void connection_cancel(Connection *c);
void connection_expect_reply(Connection *c,
			     int tasknum,
			     ConnectionMsgFunc callback,
			     gpointer data);
void connection_enq_send_buffer(Connection *c,char *buf,int size,Message *m);

void forall_connections(ConnectionFunc,gpointer);

guint count_connections();

#endif
