#ifndef GUIPREFS_H
#define GUIPREFS_H

#ifndef GNOME_H
#include <gnome.h>
#endif

#define APPLICATION_NAME "fidelio"

void guiprefs_add_clist(GtkCList *,const char *path,const char *def_widths );
void guiprefs_add_window(GtkWindow *,const char *path);
void guiprefs_add_paned(GtkPaned *,const char *path);

gboolean load_prefs(void);
void open_prefs(void);

extern gboolean prefs_dblclick_connect_query_bookmarks;
extern gboolean prefs_dblclick_connect_query_trackers;

extern gboolean tracker_sort_only_by_ip;

extern char *nickname;
extern int user_icon_number;
extern int client_version;
extern gboolean nickname_append_max_speed;
extern int nickname_append_speed_seconds;
extern char *user_status_list,*user_status_format;

extern int notebook_tab_side;
extern gboolean notebook_has_icons;

extern gboolean dont_show_agreements;
extern gboolean passwords_are_hidden;

extern gboolean auto_open_news;
extern gboolean news_big_messagewindow;

extern gboolean auto_popup_pubchat;

extern gboolean auto_open_userlist;
extern gboolean userlist_aa_canvas;
extern gboolean userlist_sort_name;
extern gboolean userlist_group_by_status;
extern gboolean userlist_use_icons;
extern gboolean userlist_no_connect;
extern gboolean userlist_use_status_icons;
extern gboolean userlist_dock_right;
extern gushort userlist_highlight_color_alpha;

extern GList *hotline_data_files;
extern gboolean use_hotline_icons;

extern int prefs_task_refresh_msec;

extern gboolean prefs_messages_show_with_reply;
extern gboolean prefs_messages_reply_quoted;

extern gboolean privchat_auto_join;

extern gboolean auto_open_files;
extern gboolean mix_files_and_folders;
extern gboolean hide_local_dotfiles;
extern gboolean cache_remote_directories;
extern char *default_local_dir;
extern gboolean enable_recursive_downloads;
extern gboolean strip_spaces_on_local_files;
extern gboolean sanitize_local_filenames;
extern gboolean download_convert_text;
extern gboolean upload_convert_text;
extern gboolean download_remove_null_files;
extern gboolean download_queue;
extern gboolean upload_queue;
extern gboolean files_small_sizes;
extern int retry_count,retry_delay;
extern int uploads_max_speed, downloads_max_speed;

enum {
  NORMAL_COLOR=0,
  GHOST_COLOR=1,
  ADMIN_COLOR=2,
  ADMIN_GHOST_COLOR=3
};
extern GdkColor userlist_colors[4],userlist_highlight_color;
extern GdkColor notebook_tab_highlight_color;

typedef struct {
  gboolean use_custom_font;
  char *font_name;
  GdkFont *font;
  GtkWidget *picker;
  GtkWidget *label;
} PrefsFont;

extern PrefsFont userlist_font;
extern PrefsFont news_font;
extern PrefsFont agreement_font;
extern PrefsFont chat_font;
extern PrefsFont privchat_font;

#define DEF_PREF_FONT {FALSE,NULL,NULL,NULL,NULL}
#define DEF_FONT_CONFIG(x,y) {FONT_TYPE,x,&y}

void guiprefs_widget_set_font(GtkWidget *list,PrefsFont *pf);

gboolean guiprefs_check_play_sound(int id);

GtkWidget *gutils_ibutton_new(int *iconvar,GtkSignalFunc modified,gpointer data);
void gutils_ibutton_set_icon(GtkWidget *w, int icon);

#endif
