/******************************************************************** 
   Copyright (C) 2001 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <gnome.h>

#include "connection.h"
#include "guiutils.h"
#include "guiprefs.h"
#include "pixmap.h"
#include "main.h"
#include "protocol.h"
#include "userlist.h"
#include "userwidget.h"
/* ============================== */

GnomeUIInfo *gutils_dup_gnomeuiinfo_with_data(GnomeUIInfo *orig,gpointer data){
  GnomeUIInfo *i;
  int size;

  for(size=0;orig[size].type!=GNOME_APP_UI_ENDOFINFO;size++);
  size++;
  i=(GnomeUIInfo *)malloc(sizeof(GnomeUIInfo)*size);
  memcpy(i,orig,sizeof(GnomeUIInfo)*size);
  for(size=0;orig[size].type!=GNOME_APP_UI_ENDOFINFO;size++)
    i[size].user_data=data;
  return i;
}

void guiutils_raise_window(GtkWindow *w){
  gdk_window_raise(GTK_WIDGET(w)->window);
}

/* ============================== */

typedef struct {
  guint32 last_time;
  void (*cb)(GtkWidget *,gint row,gpointer data);
  int last_row;
  gpointer data;
} DblClickData;

static void list_select_row(GtkWidget *widget,
			    gint row,
			    gint column,
			    GdkEventButton *event,
			    gpointer data){
  DblClickData *db=(DblClickData *)data;
  if(event==NULL)
    return;
  if(event->type==GDK_2BUTTON_PRESS &&
     row==db->last_row){
    db->cb(widget,row,db->data);
  }
  db->last_time=event->time;
  db->last_row=row;
}

static void list_destroy(GtkWidget *widget,gpointer data){
  if(data!=NULL)
    free(data);
}

void gutils_clist_on_dblclick(GtkWidget *w,
			      void (*cb)(GtkWidget *,gint row,gpointer data),
			      gpointer data){
  DblClickData *db=(DblClickData *)malloc(sizeof(DblClickData));
  db->last_time=0;
  db->data=data;
  db->cb=cb;
  db->last_row=-1;
  gtk_signal_connect(GTK_OBJECT(w),
		     "destroy",
		     GTK_SIGNAL_FUNC(list_destroy),
		     (gpointer)db);
  gtk_signal_connect(GTK_OBJECT(w),
		     "select_row",
		     GTK_SIGNAL_FUNC(list_select_row),
		     (gpointer)db);
  gtk_signal_connect(GTK_OBJECT(w),
		     "unselect_row",
		     GTK_SIGNAL_FUNC(list_select_row),
		     (gpointer)db);
}

/* ============================== */

typedef struct {
  gpointer data;
  GnomeUIInfo *info;
  GtkWidget *menu;
  GtkWidget *list;
  int row;
} PopupData;

static void list_menu_popup(GtkWidget *widget,
			    GdkEventButton *event,
			    gpointer user_data){
  PopupData *pd=(PopupData *)user_data;

  int r,c;
  if(event->button!=3) return;
  if(gtk_clist_get_selection_info(GTK_CLIST(widget),event->x,event->y,&r,&c)==0)
    return;
  pd->row=r;
  gtk_clist_unselect_all(GTK_CLIST(widget));
  gtk_clist_select_row(GTK_CLIST(widget),r,c);
  gtk_menu_popup(GTK_MENU(pd->menu),
		 NULL,NULL,NULL,NULL,
		 event->button,event->time);
}

static void list_menu_destroy(GtkWidget *widget,gpointer data){
  PopupData *pd=(PopupData *)data;
  if(pd->info!=NULL)
    free(pd->info);
  if(pd->menu!=NULL)
    gtk_widget_destroy(pd->menu);
  free(pd);
}

void clist_popup_set_sensitive(GtkWidget *w,int pos,gboolean state){
  PopupData *pd=(PopupData *)
    gtk_object_get_data(GTK_OBJECT(w),"PopupMenu");
  if(pd==NULL){
    printf(_("Whops! no menu ???\n"));
    return;
  }
  if(pd->info[pos].widget!=NULL)
    gtk_widget_set_sensitive(pd->info[pos].widget,state);
}

void gutils_clist_add_popup_menu(GtkWidget *w,GnomeUIInfo *info,gpointer data){
  PopupData *pd=(PopupData *)malloc(sizeof(PopupData));
  GtkWidget *menu=gtk_menu_new();
  pd->info=gutils_dup_gnomeuiinfo_with_data(info,data);
  pd->row=-1;
  pd->data=data;
  pd->menu=menu;
  gtk_object_set_data(GTK_OBJECT(w),"PopupMenu",(gpointer)pd);
  gnome_app_fill_menu(GTK_MENU_SHELL(menu),pd->info,NULL,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(w),
		     "button-press-event",
		     GTK_SIGNAL_FUNC(list_menu_popup),
		     (gpointer)pd);
  gtk_signal_connect(GTK_OBJECT(w),
		     "destroy",
		     GTK_SIGNAL_FUNC(list_menu_destroy),
		     (gpointer)pd);
}

/* ============================== */

static void guitils_text_clear(GtkWidget *widger,gpointer t){
  gtk_editable_delete_text(GTK_EDITABLE(t),0,-1);
}

void guitils_text_add_popup_clear(GtkText *t){
  static GnomeUIInfo info[]={
    GNOMEUIINFO_ITEM_STOCK(N_("Clear"),N_("Clear this area of all text"),
			   guitils_text_clear,
			   HL_MENU HL_STOCK_PIXMAP_CLOSE),
    GNOMEUIINFO_END
  };
  static GtkWidget *menu=NULL;

  if(menu==NULL){
    menu=gnome_popup_menu_new(info);
    gtk_widget_ref(menu);
  }
  gnome_popup_menu_attach(menu,GTK_WIDGET(t),t);
}

/* ============================== */

void gutils_nbpage_destroy(NotebookPage *p){
  if(p->config_path!=NULL)
    free(p->config_path);
  if(p->toolbar!=NULL)
    free(p->toolbar);
  if(p->dock!=NULL){
    GtkWidget *dock=p->dock;
    p->dock=NULL;
    gtk_widget_destroy(dock);
  }
  free(p);
}

void gutils_nbpage_set_main(NotebookPage *p,GtkWidget *w){
  p->main=w;
  gnome_dock_set_client_area(GNOME_DOCK(p->dock),w);
  gtk_widget_show_all(w);
}

void gutils_nbpage_set_main_with_userlist(NotebookPage *p,
					  GtkWidget *w,
					  UserWidget **uw){
  GtkWidget *sl;
  GtkWidget *pa=gtk_hpaned_new();

  *uw=userwidget_new(p->c);
  sl=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sl),
				 GTK_POLICY_NEVER,
  				 GTK_POLICY_AUTOMATIC);
  gtk_container_add(GTK_CONTAINER(sl),(*uw)->widget);
  
  if(userlist_dock_right==TRUE){
    gtk_paned_pack2(GTK_PANED(pa),sl,FALSE,TRUE);
    gtk_paned_pack1(GTK_PANED(pa),w,TRUE,TRUE);
  } else {
    gtk_paned_pack1(GTK_PANED(pa),sl,FALSE,TRUE);
    gtk_paned_pack2(GTK_PANED(pa),w,TRUE,TRUE);
  }
  guiprefs_add_paned(GTK_PANED(pa),"Main/Users/PanePos");
  gutils_nbpage_set_main(p,pa);
}

void gutils_nbpage_toolbar_set_sensitive(NotebookPage *p,int b,gboolean s){
  if(p==NULL || p->toolbar==NULL || p->toolbar[b].widget==NULL)
    return;
  gtk_widget_set_sensitive(p->toolbar[b].widget,s);
}

void gutils_nbpage_to_front(NotebookPage *p){
  if(p==NULL || p->c==NULL || p->dock==NULL)
    return;
  gtk_notebook_set_page(GTK_NOTEBOOK(p->c->gui->notebook),
			gtk_notebook_page_num(GTK_NOTEBOOK(p->c->gui->notebook),
					      p->dock));
}

static void dock_save_state(GnomeDock *dock,gpointer data){
  NotebookPage *p=(NotebookPage *)data;
  GnomeDockLayout *layout=gnome_dock_get_layout(dock);
  char *s;

  s=gnome_dock_layout_create_string(layout);
  if(s!=NULL){
    gnome_config_set_string(p->config_path,s);
    gnome_config_sync();
    free(s);
  }
  gtk_object_destroy(GTK_OBJECT(layout));
}

static void gutils_nbpage_init_toolbar(NotebookPage *p){
  GtkWidget *dockitem,*tb;
  GnomeDockLayout *layout=gnome_dock_layout_new();
  char *s;
  
  s=gnome_config_get_string(p->config_path);
  dockitem=gnome_dock_item_new("Toolbar",
			       GNOME_DOCK_ITEM_BEH_EXCLUSIVE|
			       (gnome_preferences_get_toolbar_detachable()==FALSE
				?GNOME_DOCK_ITEM_BEH_LOCKED:0));
  tb=gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_BOTH);
  gnome_app_fill_toolbar(GTK_TOOLBAR(tb),p->toolbar,NULL);
  gtk_widget_show(tb);
  gtk_container_add(GTK_CONTAINER(dockitem),tb);
  gnome_dock_layout_add_item(GNOME_DOCK_LAYOUT(layout),
			     GNOME_DOCK_ITEM(dockitem),
			     GNOME_DOCK_TOP,1,0,0);
  gtk_container_set_border_width(GTK_CONTAINER(tb),2);
  if(s!=NULL){
    gnome_dock_layout_parse_string(GNOME_DOCK_LAYOUT(layout),s);
    free(s);
  }
  gnome_dock_layout_add_to_dock(GNOME_DOCK_LAYOUT(layout),
				GNOME_DOCK(p->dock));
  gtk_object_destroy(GTK_OBJECT(layout));
}

void guiutils_nbpage_change_hook(GtkNotebook *notebook,
				 GtkNotebookPage *page,
				 gint page_num,
				 gpointer user_data){
  GtkWidget *label=gtk_object_get_data(GTK_OBJECT(page->child),"LabelWidget");
  GtkStyle *style=main_app->style;
  gtk_widget_set_style(label,style);
}

void guiutils_nbpage_highlight(NotebookPage *p){
  GtkStyle *style;
  int i=gtk_notebook_get_current_page(GTK_NOTEBOOK(p->c->gui->notebook));
  GtkWidget *dock=gtk_notebook_get_nth_page(GTK_NOTEBOOK(p->c->gui->notebook),i);
  
  if(dock==p->dock) return;
  style=gtk_style_copy(main_app->style);
  style->fg[0]=notebook_tab_highlight_color;
  gtk_widget_set_style(p->label,style);
}

NotebookPage *gutils_nbpage_new(char *config_path,
				GnomeUIInfo *toolbar,
				Connection *c,
				char *name,
				char *icon,
				gpointer toolbar_data){
  NotebookPage *p=(NotebookPage *)malloc(sizeof(NotebookPage));
  GtkWidget *label;

  p->c=c;
  p->config_path=g_strconcat("/",APPLICATION_NAME,"/",config_path,
			     "/Placement/",name,"=3,0,0,0",NULL);
  p->toolbar=gutils_dup_gnomeuiinfo_with_data(toolbar,toolbar_data);
  p->dock=gnome_dock_new();
  gnome_dock_allow_floating_items(GNOME_DOCK(p->dock),TRUE);
  gutils_nbpage_init_toolbar(p);
  p->main=NULL;
  gtk_signal_connect(GTK_OBJECT(p->dock),"layout-changed",
		     GTK_SIGNAL_FUNC(dock_save_state),(gpointer)p);
  gtk_widget_show(p->dock);

  label=p->label=gtk_label_new(name);
  gtk_label_set_justify(GTK_LABEL(p->label),GTK_JUSTIFY_LEFT);
  if(notebook_has_icons){
    GdkPixmap *pixm;
    GdkBitmap *bitm;
    pixmap_get(icon,&pixm,&bitm);
    if(pixm!=NULL){
      label=gtk_hbox_new(FALSE,1);
      gtk_box_pack_start(GTK_BOX(label),
			 gtk_pixmap_new(pixm,bitm),FALSE,FALSE,0);
      gtk_box_pack_start(GTK_BOX(label),p->label,FALSE,TRUE,0);
      gtk_widget_show_all(label);
    }
  }
  gtk_object_set_data(GTK_OBJECT(p->dock),"LabelWidget",p->label);
  gtk_notebook_append_page(GTK_NOTEBOOK(c->gui->notebook),p->dock,
			   label);
  return p;
}
