/******************************************************************** 
   Copyright (C) 1999 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/socketvar.h>
#include <arpa/inet.h>
#include <signal.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>

#include <glib.h>
#include <gtk/gtk.h>

#include "protocol.h"
#include "connection.h"
#include "network.h"

typedef struct {
  Connection *read,*write;
  char *r,*w;
} RC;

static int getListenSocket( int sockport){
  struct sockaddr_in saddr;
  struct protoent *pe=getprotobyname("tcp");
  int sock;

  if((sock=socket(AF_INET,SOCK_STREAM,pe->p_proto))<0)
    return -1;
  saddr.sin_family        = AF_INET;
  saddr.sin_addr.s_addr   = htonl(INADDR_ANY );
  saddr.sin_port          = htons(sockport);
  if(bind(sock,(struct sockaddr *)&saddr,sizeof(saddr))) {
     close(sock);
     return -1;
  }
  if(listen(sock,5)==-1){
    close(sock);
    return -1;
  }
  return sock;
}

static void thread_run(gpointer d){
  RC *rc=d;
  HLTransaction *t;
  while((t=transaction_read_header(rc->read))!=NULL){
    transaction_read_objects(rc->read,t);
    printf("%s (t=%d t=%d i=%d)\n",rc->r,t->w.type,t->w.task,t->w.info);
    transaction_send(t,rc->write);
    printf("%s (t=%d t=%d i=%d)\n",rc->w,t->w.type,t->w.task,t->w.info);
    transaction_destroy(t);
  }
  free(rc);
}

static void createRC(Connection *rd,Connection *wr,char *r,char *w){
  RC *rc=(RC *)malloc(sizeof(RC));
  Thread t;
  rc->read=rd;
  rc->write=wr;
  rc->r=r;
  rc->w=w;
  newThread(&t,thread_run,NULL,rc);
}

GtkWidget *main_app;
GdkColormap *main_colormap;
void set_cancel_task_widget_state(gboolean enabled);
void set_cancel_task_widget_state(gboolean enabled){}
void forall_servers(STransFunc func,gpointer data){}

int main(int argc,char **argv){
  int port=atoi(argv[2]);
  NetAddr na;
  int lsock,csock;
  Connection clocal,cremote;
  char buf[1024];

  if(isIP(&na,argv[1])==FALSE){
    if(resolveHost(&na,argv[1])==FALSE){
      printf("Could not resolve %s: %s\n",argv[1],strerror(errno));
      exit(1);
    }
  }
  lsock=getListenSocket(atoi(argv[3]));
  if(lsock==-1){
    perror(_("Could not bind socket"));
    exit(1);
  }
  csock=accept(lsock,NULL,NULL);
  close(lsock);
  clocal.infd=fdopen(csock,"rb");
  clocal.outfd=fdopen(csock,"wb");
  cremote.infd=getSocketTo(&na,port);
  if(cremote.infd==NULL){
    perror(_("Could not create remote pipe"));
    exit(1);
  }
  cremote.outfd=fdopen(fileno(cremote.infd),"wb");
  fwrite("TRTP\0\0\0\0",8,1,clocal.outfd);
  fflush(clocal.outfd);
  fwrite("TRTPHOTL\0\1\0\2",12,1,cremote.outfd);
  fflush(cremote.outfd);
  fread(buf,12,1,clocal.infd);
  fread(buf,8,1,cremote.infd);
  createRC(&clocal,&cremote,"C->L","L->S");
  createRC(&cremote,&clocal,"S->L","L->C");
  //  createRC(&clocal,&cremote,"C->L"," ");
  //  createRC(&cremote,&clocal," "," ");
  while(1){
    sleep(9999999);
  }
  return 0;
}
