#ifndef MESSAGES_H
#define MESSAGES_H

typedef struct Message_ Message;

#ifndef GTK_CHECK_CAST
#include <gtk/gtk.h>
#endif

#ifndef PROTOCOL_H
#include "protocol.h"
#endif

#ifndef CONNECTION_H
#include "connection.h"
#endif

#ifndef TASKS_H
#include "tasks.h"
#endif

/**\
 * The on-the-wire representation of messages.
 * As usual, all fields are in big-endian format.
\**/
typedef struct {
  guint16 info;
  guint16 type;
  guint32 task;
  guint32 error;
  guint32 data_length;
  guint32 data_length_copy;
  guint16 object_count;
} WireMessage;

/**\
 * The message class
 * The change_perc signal is triggered when an amount of data has been
 * transferred. The float argument is the completion percentage.
\**/
typedef struct {
  GtkObjectClass parent_klass;
  void (*perc_changed)(Message *,gfloat);
  void (*sent)(Message *);
} MessageClass;

/**\
 * The message instance.
 * This contains a protocol message sent to/received from the server.
 * Note that this class will manage all objects passed to/from it,
 * except objects extracted with message_extract_objects, which will
 * belong to the caller.
\**/
struct Message_ {
  GtkObject parent_object;
  WireMessage w;
  GList *objects;
  Connection *c;
  Task *task;
  gfloat start_percent,end_percent,curpos;
  gboolean is_finished;
};


GtkType message_get_type(void);
#define MESSAGE_TYPE	     (message_get_type())
#define MESSAGE(obj)	     (GTK_CHECK_CAST((obj), MESSAGE_TYPE, Message))
#define MESSAGE_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), MESSAGE_TYPE, MessageClass))
#define IS_MESSAGE(obj)	     (GTK_CHECK_TYPE((obj), MESSAGE_TYPE))
#define IS_MESSAGE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), MESSAGE_TYPE))


#define message_ref(m) gtk_object_ref(GTK_OBJECT(m))
#define message_unref(m) gtk_object_unref(GTK_OBJECT(m))


Message *message_new(Connection *c,int message_type);
Message *message_new_from_connection(Connection *c);
int message_get_tasknum(Message *m);

void message_add_object(Message *m, HLObject *o);
HLObject *message_find_object(Message *m, int object_type);
HLObject **message_extract_objects(Message *m, int object_type, int *count);

gboolean message_is_error(Message *m);
gboolean message_is_reply(Message *m);
gboolean message_is_complete(Message *m);

void message_set_task(Message *m,Task *t,gfloat start_pos,gfloat end_pos);
void message_set_pos(Message *m,gfloat pos);

void message_fire_and_forget(Message *m);

/*
 * These functions should be called only from the respective 
 * Connection threads.
 */
void message_send(Message *m);
gboolean message_recv_objects(Message *m);

#endif
