/******************************************************************** 
   Copyright (C) 1999 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/socketvar.h>
#include <arpa/inet.h>
#include <signal.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>

#include <glib.h>

#include "network.h"
#include "hotline.h"

gboolean isIP(NetAddr *na,const char *host){
  if(inet_aton(host,na)==0) {
    return FALSE;
  }
  return TRUE;
}

gboolean resolveHost(NetAddr *na, const char *host){
  struct hostent *hdb;

  if(isIP(na,host)!=TRUE){
    hdb=gethostbyname(host);
    if(hdb==NULL) {
      return FALSE;
    }
    na->s_addr=*((unsigned int *)(hdb->h_addr));
  }
  return TRUE;
}

FILE *getSocketTo(NetAddr *na,int port){
  int sock;
  struct sockaddr_in saddr;
  struct protoent *pe=getprotobyname("tcp");

  if((sock=socket(AF_INET,SOCK_STREAM,pe->p_proto))<0)
    return NULL;
  
  saddr.sin_family        = AF_INET;
  saddr.sin_addr.s_addr   = htonl(INADDR_ANY );
  saddr.sin_port          = htons(0);
  if(bind(sock,(struct sockaddr *)&saddr,sizeof(saddr))) {
     close(sock);
     return NULL;
  }

  saddr.sin_family        = AF_INET;
  saddr.sin_addr.s_addr   = na->s_addr;
  saddr.sin_port          = htons(port & 0xffff);
  
  if(connect(sock,(struct sockaddr *)&saddr,sizeof(saddr))!=0) {
    close(sock);
    return NULL;
  }
  return fdopen(sock,"rb+");
}

int getAsyncSocketTo(NetAddr *na,int port){
  int sock;
  struct sockaddr_in saddr;
  struct protoent *pe=getprotobyname("tcp");
  int retval;

  if((sock=socket(AF_INET,SOCK_STREAM,pe->p_proto))<0)
    return -1;
  
  saddr.sin_family        = AF_INET;
  saddr.sin_addr.s_addr   = htonl(INADDR_ANY );
  saddr.sin_port          = htons(0);
  if(bind(sock,(struct sockaddr *)&saddr,sizeof(saddr))) {
     close(sock);
     return -1;
  }

  saddr.sin_family        = AF_INET;
  saddr.sin_addr.s_addr   = na->s_addr;
  saddr.sin_port          = htons(port & 0xffff);
  
  fcntl(sock,F_SETFL,fcntl(sock,F_GETFL)|O_NONBLOCK);

  retval=connect(sock,(struct sockaddr *)&saddr,sizeof(saddr));
  if(retval!=0 && errno!=EINPROGRESS) {
    close(sock);
    return -1;
  }
  return sock;
}


