/******************************************************************** 
   Copyright (C) 2000 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include "connection.h"
#include "protocol.h"
#include "privs.h"

#define PRIVS "PRIVS"

static void privs_destroy(Connection *c,gpointer data){
  gpointer a=connection_get_data(c,PRIVS);
  if(a!=NULL)
    free(a);
}

gboolean privs_check(Connection *c,int p){
  Privileges *a=connection_get_data(c,PRIVS);
  if(a==NULL)
    return TRUE;
  if(PRIV_IS(a,p))
    return TRUE;
  return FALSE;
}

void handle_privs_sent(Connection *c,Message *m,gpointer data){
  Privileges *a=NULL;
  HLObject *o;

  o=message_find_object(m,HLO_PRIVS);
  if(o!=NULL){
    a=calloc(1,sizeof(Privileges));
    *a=*o->data.privileges;
    connection_set_data(c,PRIVS,a);
    gtk_signal_connect(GTK_OBJECT(c),"destroy",GTK_SIGNAL_FUNC(privs_destroy),a);
  }
  message_unref(m);
}
