#ifndef PROTOCOL_H
#define PROTOCOL_H

#include <glib.h>

typedef struct HLObject_ HLObject;

#ifndef TASKS_H
#include "tasks.h"
#endif

#ifndef CONNECTION_H
#include "connection.h"
#endif

typedef struct {
  char type[4];
  char creator[4];
  guint32 size;
  guint32 pad;
  guint32 filename_size;
} WireFilelistEntry;
typedef struct {
  WireFilelistEntry f;
  char *name;
} FilelistEntry;

typedef struct {
  gint16 socket;
  gint16 icon;
  gint16 status;
  guint16 nickname_length;
} WireUserlistEntry;
typedef struct {
  WireUserlistEntry u;
  char *name;
  int pos;
} UserlistEntry;

#define ULE_STATUS_GHOST      1
#define ULE_STATUS_ADMIN      2
#define ULE_STATUS_NOPRIVCHAT 4
#define ULE_STATUS_NOMSG      8
#define ULE_FIDELIO_IGNORED   0x1000

typedef struct {
  guint16 dir_levels;
  char **directories;
} Path;

typedef struct {
  guint16 base_year;
  guint16 pad;
  guint32 seconds;
} DateTime;

#define RESUME_DATA_OFFSET 42
#define RESUME_DATA_SIZE 32
#define RESUME_INFO_SIZE (RESUME_DATA_OFFSET+RESUME_DATA_SIZE)
typedef struct {
  char RFLT[4];
  guint16 one;
  guint8 pad1[34];
  guint16 two;
} ResumeHdr;
typedef struct {
  char DATA[4];
  guint32 data_resume_offset;
  guint32 pad2[2];
  char MACR[4];
  guint32 resource_resume_offset;
  guint32 pad3[2];
} ResumeData;
/* Damn those alignment issues! */
typedef struct {
  int data_resume_offset;
  int resource_resume_offset;
} ResumeInfo;

typedef struct {
  guint8 privs[8];
} Privileges;

typedef struct {
  int type;
  char *name;
} NewsFolderItem;

typedef struct {
  guint16 type;
  guint16 post_count;
} WireCatItem;
typedef struct {
  WireCatItem w;
  char *name;
} CatalogItem;

typedef struct {
  int postid,parentid;
  DateTime date;
  char *sender;
  char *subject;
  int partcount;
  int size;
  struct {
    int size;
    char *mime_type;
  } *parts;
} NewsItem;
typedef struct {
  int post_count;
  NewsItem *posts;
} NewsGroup;

struct HLObject_ {
  guint16 type;
  union {
    gint32        number;
    char          *string;
    FilelistEntry *filelistentry;
    DateTime      *datetime;
    ResumeInfo    *resumeinfo;
    UserlistEntry *userlistentry;
    Privileges    *privileges;
    Path          *path;
    NewsFolderItem *newsfolderitem;
    CatalogItem   *catalogitem;
    NewsGroup     *newsgroup;
  } data;
};

typedef struct {
  guint16 info;
  guint16 type;
  guint32 task;
  guint32 error;
  guint32 data_length;
  guint32 data_length_copy;
  guint16 object_count;
} WireTransaction;

#define SIZE_OF_WIRETRANSACTION 20


#define HLO_ERRORMSG   100
#define HLO_MESSAGE    101
#define HLO_NICK       102
#define HLO_SOCKET     103
#define HLO_ICON       104
#define HLO_LOGIN      105
#define HLO_PASSWD     106
#define HLO_XFERID     107
#define HLO_XFERSIZE   108
#define HLO_PARAMETER  109
#define HLO_PRIVS      110
#define HLO_STATUS     112
#define HLO_BAN        113
#define HLO_CHATWINDOW 114
#define HLO_SUBJECT    115
#define HLO_QUEUED     116

#define HLO_BANNERTYPE 152
#define HLO_BANNERURL  153
#define HLO_OMITAGREEMENT 154
#define HLO_VERSION    160
#define HLO_SERVERQUEUE 161
#define HLO_SERVERNAME 162

#define HLO_FILEENTRY  200
#define HLO_FILENAME   201
#define HLO_PATH       202
#define HLO_RESUMEINFO 203
#define HLO_RESUMEFLAG 204
#define HLO_INFOLONGTYPE 205
#define HLO_INFOCREATOR  206
#define HLO_INFOSIZE     207
#define HLO_INFOCREATED  208
#define HLO_INFOMODIFIED 209
#define HLO_COMMENT    210
#define HLO_NEWFILENAME 211
#define HLO_TARGETPATH 212
#define HLO_INFOTYPE   213
#define HLO_QUOTE      214

#define HLO_USERLISTENTRY 300

#define HLO_NEWSFOLDERITEM 320
#define HLO_CATLIST        321
#define HLO_CATEGORY       322
#define HLO_CATEGORYITEM   323 /* Huh ? */
#define HLO_NEWSPATH       325
#define HLO_THREADID       326
#define HLO_NEWSTYPE       327
#define HLO_NEWSSUBJECT    328
#define HLO_NEWSAUTHOR     329
#define HLO_NEWSDATE       330
#define HLO_PREVTHREAD     331
#define HLO_NEXTTHREAD     332
#define HLO_NEWSDATA       333
#define HLO_PARENTTHREAD   334
#define HLO_PARENT_POST    335
#define HLO_CHILD_POST     336

#define HLCT_GETNEWS       101
#define HLCT_POSTNEWS      103
#define HLCI_SENDCHAT      105
#define HLCT_LOGIN         107
#define HLCT_SENDPRIVM     108
#define HLCT_KICK          110
#define HLCT_CREATEPCHAT   112
#define HLCT_ADDTOPCHAT    113
#define HLCT_REJECTPCHAT   114
#define HLCT_REQJOINPCHAT  115
#define HLCT_LEAVEPCHAT    116
#define HLCT_CHANGESUBJECT 120
#define HLCT_AGREEAGREEMENT 121
#define HLCT_FOLDERLIST    200
#define HLCT_DOWNLOAD      202
#define HLCT_UPLOAD        203
#define HLCT_MOVETOTRASH   204
#define HLCT_CREATEFOLDER  205
#define HLCT_GETFILEINFO   206
#define HLCT_SETFILEINFO   207
#define HLCT_MOVEFILE      208
#define HLCT_MAKEALIAS     209
#define HLCT_GETBANNER     212
#define HLCT_GETUSERLIST   300
#define HLCT_GETUSERINFO   303
#define HLCI_CHANGENICKICON 304
#define HLCT_CREATEUSER    350
#define HLCT_DELETEUSER    351
#define HLCT_OPENUSER      352
#define HLCT_MODIFYUSER    353

#define HLCT_NEWSDIRLIST   370
#define HLCT_NEWSCATLIST   371
#define HLCT_DELNEWSDIRCAT 380
#define HLCT_MAKENEWSDIR   381
#define HLCT_MAKECATEGORY  382
#define HLCT_GETTHREAD     400
#define HLCT_POSTTHREAD    410
#define HLCT_DELETETHREAD  411


#define HLSI_NEWPOST       102
#define HLSI_BROADCAST     104
#define HLSI_RELAYCHAT     106
#define HLSI_AGREEMENT     109
#define HLSI_DISCONNECTED  111
#define HLSI_INVITEDTOPCHAT 113
#define HLSI_JOINEDPCHAT   117
#define HLSI_LEFTPCHAT     118
#define HLSI_CHANGESUBJECT 119
#define HLSI_BANNERURL     122
#define HLSI_SERVERQUPDATE 211
#define HLSI_USERCHANGE    301
#define HLSI_USERLEAVE     302
#define HLSI_SELFUSER      354
#define HLSI_BROADCAST18   355

typedef struct {
  int type;
  HLObject *(*read)(HLObject *o,unsigned char *buf,int len,gpointer data);
  int (*write)(HLObject *o,unsigned char **buf,gpointer data);
  void (*destroy)(HLObject *,gpointer data);
  gpointer data;
} ObjectDef;

#define TRANS_NO_REPLY 1
#define TRANS_NEEDS_TASK 2


void object_destroy(HLObject *o);
void object_set_type(HLObject *o,int type);

void resinfo_get_offsets(HLObject *o,int *data,int *res);
HLObject *resinfo_new(int data,int res);
HLObject *userlistentry_new(int socket,int icon,int status,char *nickname);
HLObject *path_parent(HLObject *o);
HLObject *path_add(HLObject *o,char *path_append);
HLObject *path_new(char **paths,int num_paths);
HLObject *path_dup(HLObject *o);
void path_destroy(Path *p);
HLObject *create_number(int type,int what);
HLObject *create_string(int type,char *what);
void string_net_to_unix(HLObject *o);
void string_unix_to_net(HLObject *o);
time_t date_to_unix(DateTime *dt);
void date_to_hotline(DateTime *dt,time_t time);

HLObject *read_object(int type,int size,unsigned char *buf);
ObjectDef *find_object_type(int type);

void objects_destroy(HLObject **ob);

#endif
