/******************************************************************** 
   Copyright (C) 2001 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <gnome.h>
#include <gtk/gtkprogressbar.h>
#include <glib.h>

#include "tasks.h"
#include "taskgroup.h"
#include "threads.h"
#include "guiprefs.h"
#include "main.h"
#include "connection.h"

enum {
  TASK_ADD,
  TASK_REMOVE,
  LAST_SIGNAL
};

static guint task_group_signals[LAST_SIGNAL]={0,0};
static GtkFrameClass *parent_class=NULL;


static void task_group_finalize(GtkObject *object){
  TaskGroup *tg;

  g_return_if_fail(object!=NULL);
  g_return_if_fail(IS_TASK_GROUP(object));

  tg=TASK_GROUP(object);
  g_free(tg->name);
  g_list_free(tg->tasks);
  GTK_OBJECT_CLASS(parent_class)->finalize(object);
}

static void task_group_class_init(TaskGroupClass *klass){
  GtkObjectClass *object_class=(GtkObjectClass*)klass;

  parent_class=gtk_type_class(GTK_TYPE_FRAME);
  object_class->finalize=task_group_finalize;
  
  task_group_signals[TASK_ADD]=
    gtk_signal_new("task-add",
		   GTK_RUN_LAST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(TaskGroupClass,task_add),
		   gtk_marshal_NONE__OBJECT,
		   GTK_TYPE_NONE,1,
		   TASK_TYPE);
  task_group_signals[TASK_REMOVE]=
    gtk_signal_new("task-remove",
		   GTK_RUN_LAST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(TaskGroupClass,task_remove),
		   gtk_marshal_NONE__OBJECT,
		   GTK_TYPE_NONE,1,
		   TASK_TYPE);
  gtk_object_class_add_signals(object_class,task_group_signals,LAST_SIGNAL);

  klass->task_add=NULL;
  klass->task_remove=NULL;
}

static void task_group_init(TaskGroup *tg){
  tg->name=NULL;
  tg->tasks=NULL;
  tg->box=(GtkVBox *)gtk_vbox_new(TRUE,2);
  gtk_widget_show(GTK_WIDGET(tg->box));
  gtk_container_add(GTK_CONTAINER(tg),GTK_WIDGET(tg->box));
}

GtkType task_group_get_type(void){
  static GtkType task_group_type=0;
  
  if(task_group_type==0){
    static const GtkTypeInfo type_info={
      "TaskGroup",
      sizeof(TaskGroup),
      sizeof(TaskGroupClass),
      (GtkClassInitFunc) task_group_class_init,
      (GtkObjectInitFunc) task_group_init,
      /* reserved_1 */ NULL,
      /* reserved_2 */ NULL,
      (GtkClassInitFunc) NULL,
    };
    task_group_type=gtk_type_unique(GTK_TYPE_FRAME,&type_info);
    gtk_type_set_chunk_alloc(task_group_type,4);
  }
  return task_group_type;
}

TaskGroup *task_group_new(char *name){
  TaskGroup *tg=(TaskGroup *)gtk_type_new(TASK_GROUP_TYPE);

  if(name!=NULL){
    tg->name=strdup(name);
    gtk_frame_set_label(GTK_FRAME(tg),tg->name);
  }
  return tg;
}

static void task_group_remove_task_real(TaskGroup *group,Task *task){
  group->tasks=g_list_remove(group->tasks,task);
  gtk_signal_emit(GTK_OBJECT(group),task_group_signals[TASK_REMOVE],task);
  gtk_widget_queue_resize(GTK_WIDGET(group));
}

void task_group_add_task(TaskGroup *group, Task *task){
  g_return_if_fail(group!=NULL);
  g_return_if_fail(task!=NULL);
  g_return_if_fail(IS_TASK_GROUP(group));
  g_return_if_fail(IS_TASK(task));

  group->tasks=g_list_prepend(group->tasks,task);
  gtk_signal_connect_object_while_alive(GTK_OBJECT(task),
					"destroy",
					GTK_SIGNAL_FUNC(task_group_remove_task_real),
					GTK_OBJECT(group));
  gtk_box_pack_start(GTK_BOX(group->box),GTK_WIDGET(task),FALSE,FALSE,0);
  gtk_signal_emit(GTK_OBJECT(group),task_group_signals[TASK_ADD],task);
  gtk_widget_show(GTK_WIDGET(task));
}

void task_group_remove_task(TaskGroup *group,Task *task){
  g_return_if_fail(group!=NULL);
  g_return_if_fail(task!=NULL);
  g_return_if_fail(IS_TASK_GROUP(group));
  g_return_if_fail(IS_TASK(task));

  gtk_signal_disconnect_by_func(GTK_OBJECT(task),
				GTK_SIGNAL_FUNC(task_group_remove_task_real),
				group);
  task_group_remove_task_real(group,task);
  gtk_container_remove(GTK_CONTAINER(group->box),GTK_WIDGET(task));
}

int task_group_count_tasks(TaskGroup *group){
  g_return_val_if_fail(group!=NULL,0);
  g_return_val_if_fail(IS_TASK_GROUP(group),0);
  return g_list_length(group->tasks);
}
