#ifndef TASK_GROUP_H
#define TASK_GROUP_H

typedef struct TaskGroup_ TaskGroup;
typedef struct TaskGroupClass_ TaskGroupClass;

struct TaskGroupClass_{
  GtkFrameClass parent_class;
  void (*task_add)(TaskGroup *,Task *);
  void (*task_remove)(TaskGroup *,Task *);
};

struct TaskGroup_{
  GtkFrame parent_frame;
  GList *tasks;
  char *name;
  GtkVBox *box;
};

GtkType task_group_get_type(void);

TaskGroup *task_group_new(char *name);
void task_group_add_task(TaskGroup *group, Task *task);
void task_group_remove_task(TaskGroup *group,Task *task);
int task_group_count_tasks(TaskGroup *group);


#define TASK_GROUP_TYPE		  (task_group_get_type())
#define TASK_GROUP(obj)		  (GTK_CHECK_CAST((obj),TASK_GROUP_TYPE, TaskGroup))
#define TASK_GROUP_CLASS(klass)	  (GTK_CHECK_CLASS_CAST((klass), TASK_GROUP_TYPE, TaskGroupClass))
#define IS_TASK_GROUP(obj)	  (GTK_CHECK_TYPE((obj),TASK_GROUP_TYPE))
#define IS_TASK_GROUP_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), TASK_GROUP_TYPE))


#endif
