#ifndef TASKS_H
#define TASKS_H

#include <gtk/gtk.h>

typedef struct Task_ Task;

#ifndef TASK_GROUP_H
#include "taskgroup.h"
#endif
#ifndef CONNECTION_H
#include "connection.h"
#endif

/* ================================ */

typedef struct {
  GtkHBoxClass parent_klass;
  void (*updated)(Task *);
  void (*cancelled)(Task *);
  void (*check_update)(Task *);
} TaskClass;

#define TASK_TEXT_SIZE 472

struct Task_ {
  GtkHBox parent_object;

  gfloat percdone;

  char *icon_name;
  GtkWidget *icon_widget;
  GtkWidget *button_widget;
  GtkWidget *progressbar_widget;
  unsigned int is_running:1;
  unsigned int async_update_requested:1;
  unsigned int is_changed:2;
  char text[TASK_TEXT_SIZE];
  
  Connection *c;
};

#define TASK_CHANGED_POS 1
#define TASK_CHANGED_TEXT 2

GtkType task_get_type(void);
#define TASK_TYPE	     (task_get_type())
#define TASK(obj)	     (GTK_CHECK_CAST((obj), TASK_TYPE, Task))
#define TASK_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), TASK_TYPE, TaskClass))
#define IS_TASK(obj)	     (GTK_CHECK_TYPE((obj), TASK_TYPE))
#define IS_TASK_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), TASK_TYPE))


Task *task_create_new(char *icon);
void task_set_icon(Task *task,char *icon_name);
void task_on_cancel_destroy(Task *task);
void task_cancel(Task *task);
void task_set_postext(Task *task, gfloat pos, const char *text);
void task_set_printf(Task *task, gfloat pos, const char *fmt, ...);
void task_set_pos(Task *task, gfloat pos);
void task_update(Task *task);
gboolean task_needs_update(Task *task);
GtkWidget *task_add_button(Task *task,char *name);
void task_persist_after_connection(Task *t);


void task_async_request_update(Task *task);
void task_async_set_printf(Task *task, gfloat pos, const char *fmt, ...);
void task_async_destroy(Task *task);

#endif
