#ifndef TRANSACTION_H
#define TRANSACTION_H

#include <glib.h>

typedef struct Transaction_ Transaction;

#ifndef CONNECTION_H
#include "connection.h"
#endif

#ifndef MESSAGES_H
#include "messages.h"
#endif

#ifndef TASKS_H
#include "tasks.h"
#endif

typedef struct {
  GtkObjectClass parent_klass;
  void (*initialize)(Transaction *,Message *);
  void (*request_sent)(Transaction *);
  void (*response_received)(Transaction *,Message *);
} TransactionClass;

struct Transaction_ {
  GtkObject parentObject;
  Connection *c;
  int request_type;
  Message *request,*response;
  Task *task;
  gfloat taskpos;
};

GtkType transaction_get_type(void);
#define TRANSACTION_TYPE	     (transaction_get_type())
#define TRANSACTION(obj)	     (GTK_CHECK_CAST((obj), TRANSACTION_TYPE, Transaction))
#define TRANSACTION_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), TRANSACTION_TYPE, TransactionClass))
#define IS_TRANSACTION(obj)	     (GTK_CHECK_TYPE((obj), TRANSACTION_TYPE))
#define IS_TRANSACTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), MESSAGE_TYPE))

#define transaction_ref(m) gtk_object_ref(GTK_OBJECT(m));
#define transaction_unref(m) gtk_object_unref(GTK_OBJECT(m));


Transaction *transaction_new(Connection *c,int transaction_type);
void transaction_start(Transaction *t);
void transaction_set_task(Transaction *t,Task *task,gfloat mid);
void transaction_add_task(Transaction *t,char *text,char *icon,gfloat mid);
void transaction_set_error_check(Transaction *t,char *msg);


#endif
