#ifndef USERLIST_H
#define USERLIST_H

#ifndef CONNECTION_H
#include "connection.h"
#endif
#ifndef PROTOCOL_H
#include "protocol.h"
#endif
#ifndef MESSAGES_H
#include "messages.h"
#endif
#ifndef TRANSACTION_H
#include "transaction.h"
#endif

void check_userlist(Connection *c);
void userlist_refresh(Connection *c);
UserlistEntry *get_user_by_socket(Connection *c,int sock);

void handle_user_change(Connection *c,Message *m,gpointer data);
void handle_user_leave(Connection *c,Message *m,gpointer data);

typedef struct UserlistOps_ {
  Connection *c;
  gpointer data;
  void (*destroy)(Connection *,struct UserlistOps_ *,gpointer);
  void (*refresh)(Connection *,int numusers, int *sock,gpointer);
  void (*add_user)(Connection *,int sock,gpointer);
  void (*update_user)(Connection *,int sock,gpointer);
  void (*rm_user)(Connection *,int sock,gpointer);
} UserlistOps;

void userlist_add_ops(Connection *,UserlistOps *,gpointer);
void userlist_rm_ops(Connection *,UserlistOps *);

void userlist_set_ignored(Connection *c,int socket, gboolean ignored);
gboolean userlist_get_ignored(Connection *c,int socket);
gboolean userlist_get_ignored_by_string(Connection *c,char *string);


#endif
