/* compound.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* for compound objects  */  
/*
 * $Log: compound.c,v $
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:30  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:29  moz
 * CVS Import
 *
 * Revision 1.13  2000/03/06 01:36:30  moz
 * Compile fixes.
 *
 * Revision 1.12  1999/11/15 02:07:45  moz
 * Name change.
 *
 * Revision 1.11  1999/05/19 17:06:12  moz
 * 1.0 Checkin.
 *
 * Revision 1.10  1999/05/04 19:49:03  moz
 * Removed test code accidentally left in.
 *
 * Revision 1.9  1999/05/04 19:04:42  moz
 * Removed cruft.
 *
 * Revision 1.8  1999/05/02 22:48:58  moz
 * Changes to allow UNDO_UNCOMPOUND.
 *
 * Revision 1.7  1999/04/29 22:00:54  moz
 * Only register a UNDO_COMPOUND once.
 *
 * Revision 1.6  1999/04/28 20:56:45  moz
 * Removed unwanted SET_CLIP_WINDOWS.
 *
 * Revision 1.5  1999/04/24 22:22:27  moz
 * gc_col needs view parameter.
 *
 * Revision 1.4  1999/04/22 22:15:31  moz
 * break_compound for undoing of make compound.
 *
 * Revision 1.3  1999/04/08 02:07:13  moz
 * Depth-related fixes when constructing compound object list.
 *
 * Revision 1.2  1999/04/04 01:48:35  moz
 * Knock on effect of correct derrying in compounds.
 *
 * Revision 1.1  1999/03/30 00:04:21  moz
 * Initial revision
 *
 */    

#include "include/figurine.h"
#include "include/extern.h"

static Object *mob=NULL;

/* this moves a compound object and its contents  */  
void 
compound_move(View *v, Object *ob, long ox, long oy, long nx, long ny)
{
	List l;
	long x,y; 
	
	l = ob->ob.compound.obs;

	x = nx-ox;
	y = ny-oy;

	while (l!=NULL)
		{
		if (OB(l)->type==COMPOUND)
			compound_move(v,OB(l),OB(l)->bbox.x1,OB(l)->bbox.y1,OB(l)->bbox.x1+x,OB(l)->bbox.y1+y);
		OB(l)->bbox.x1 += x;
		OB(l)->bbox.y1 += y;
		OB(l)->bbox.x2 += x;
		OB(l)->bbox.y2 += y;
		if (OB(l)->type==TEXT)
			{
			OB(l)->ob.text.bbox.x1 += x;
			OB(l)->ob.text.bbox.y1 += y;
			OB(l)->ob.text.bbox.x2 += x;
			OB(l)->ob.text.bbox.y2 += y;
			};
		 
	   if (OB(l)->derries!=NULL)
		   derry_move(v,OB(l),ox,oy);             
		l = l->next; 
		};
}

/* unselect the currently edited compound  */ 
void 
unselect_compound(View *view)
{
	if (mob!=NULL)
		{ 
		send_redraw_object(view,mob);
		mob=NULL;
		state.compound_selected = FALSE; 
		}; 
}
 
/* create (empty) compound  */   
Object *
create_compound(View *view)
{
	Object *ob;

	ob = (Object *)malloc(sizeof(Object));

	if (ob==NULL)
		return NULL;
	
	ob->ob.compound.obs = NULL;
	ob->type = COMPOUND;
	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	ob->farrow = NULL;
	ob->barrow = NULL;
	ob->depth = ULONG_MAX; /* with nothing in it, it's very far away  */ 
	ob->bbox.x1 = 0;
	ob->bbox.y1 = 0;
	ob->bbox.x2 = 4;
	ob->bbox.y2 = 4;
	/* we do these just to satisfy this:  */ 
	
	view->doc->o = add_object(view->doc->o, &view->doc->lo, ob);
	state.compound_selected = TRUE; 
	
	return ob;
}

/* break a compound  */  
void
break_compound(View *view, Object *ob)
{
	List l;

	if (mob!=NULL) 
		{
		state.compound_selected = FALSE; 
		send_redraw_object(view,mob);
		mob = NULL;
		};

	register_undo(UNDO_UNCOMPOUND,ob,view->doc); 
	l = ob->ob.compound.obs;

	while (l!=NULL)
		{
		view->doc->o = add_object(view->doc->o,&view->doc->lo,OB(l));
		l = l->next; 
		};
	
	/* we don't delete the compound, this is needed for undo/redo
		the object is finally deleted when it falls off the bottom of
		the undo stack */  
		 
	view->doc->o = trash_object(view->doc->o,&view->doc->lo,ob); 
}

/* add an object to a compound  */  
void 
add_to_compound(View *view, Object *ob)
{
	if (mob==NULL)
		{ 
		mob = create_compound(view); 
		mob->bbox.x1 = ob->bbox.x1;
		mob->bbox.y1 = ob->bbox.y1;
		mob->bbox.x2 = ob->bbox.x2;
		mob->bbox.y2 = ob->bbox.y2;
		register_undo(UNDO_COMPOUND,mob,view->doc); 
		};
	
	mob->ob.compound.obs = add_to_list(mob->ob.compound.obs,ULONG_MAX-ob->depth,0,(void *)ob);
	mob->depth = min(ob->depth,mob->depth); 
	view->doc->o = trash_object(view->doc->o,&view->doc->lo, ob);
	 
	mob->bbox = merge_boxes(mob->bbox,ob->bbox); 
	view->doc->o = change_bbox(view->doc->o,mob); 
	 
	send_redraw_object(view,mob); 
}

void 
compound_button(BEvent *bev, View *view)
{

	if (bev->type == BUTTON_RELEASED || bev->type == BUTTON_CLICKED)
		{
		if (bev->button==Button1)
			{
			Node *n;

			/* get the object at the current mouse position  */  
			n = object_at_point_p(view,view->doc->o, bev->x, bev->y);
			
			if (n!=NULL && n->ob!=NULL)
				{ 
				if (mob==NULL && n->ob->type==COMPOUND)
					{ 
					/* clicked on existing compound  */  
					mob=n->ob;
					state.compound_selected = TRUE;
					send_redraw_object(view,mob); 
					}
				else if (n->ob!=mob)
					add_to_compound(view,n->ob);						
				} 
			else if (mob!=NULL)
				{ 
				send_redraw_object(view,mob); 
				mob=NULL;
				state.compound_selected = FALSE;
				};
			}
		else if (bev->button==Button2  && mob!=NULL)
			{ 
			send_redraw_object(view,mob); 
			break_compound(view,mob); 
			mob = NULL;
			state.compound_selected = FALSE; 
			}; 
		};
}

void 
draw_compound(Object *ob, View *view, GC gc, long x, long y, double rx, double ry, long rcx, long rcy, long rcw, long rch)
{
	Boolean clipped = FALSE;
	List list; 
	long cx,cy,cw,ch; 
	VLine l; VLine *pl;
	
	list = ob->ob.compound.obs;
	 
	while (gc!=blackxorgc && list!=NULL)
		{
		/* we calculate where we have to draw, and draw only
			intersecting objects in the compound */  
		if (rcw==0 && rch==0)
			{
			cx = XD2P(OB(list)->bbox.x1,view);
			cy = YD2P(OB(list)->bbox.y1,view);
			cw = 1 + XD2P(OB(list)->bbox.x2,view) - XD2P(OB(list)->bbox.x1,view);
			ch = 1 + YD2P(OB(list)->bbox.y2,view) - YD2P(OB(list)->bbox.y1,view);
			}
		else
			{
			cx = rcx;
			cy = rcy;
			cw = rcw;
			ch = rch;
			};

		if (intersects(cx,cy,cx+cw,cy+ch,XD2P(OB(list)->bbox.x1,view),YD2P(OB(list)->bbox.y1,view),
			 XD2P(OB(list)->bbox.x2,view), YD2P(OB(list)->bbox.y2,view)))
			{  
			set_clip(ugc, cx, cy, cw, ch);
			set_clip(handlegc, cx, cy, cw, ch);
			set_clip(fillgc, cx, cy, cw, ch);
			set_clip(dashgc, cx, cy, cw, ch);
 			set_clip(blackxorgc, cx, cy, cw+2, ch+1);
		 
			if (mob!=NULL && mob==ob)
				{
				/* while editing, draw dashes round each object  */  
				l.x1 = XD2P(OB(list)->bbox.x1,view);
				l.y1 = YD2P(OB(list)->bbox.y1,view);
				l.x2 = XD2P(OB(list)->bbox.x2,view);
				l.y2 = YD2P(OB(list)->bbox.y1,view);
				pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h,&l,&clipped,0);
				if (pl!=NULL)
					XDrawLine(display,view->draw_window->win, dashgc, pl->x1, pl->y1, pl->x2, pl->y2);
				l.x1 = XD2P(OB(list)->bbox.x2,view);
				l.y1 = YD2P(OB(list)->bbox.y1,view);
				l.x2 = XD2P(OB(list)->bbox.x2,view);
				l.y2 = YD2P(OB(list)->bbox.y2,view);
				pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h,&l,&clipped,0);
				if (pl!=NULL)
					XDrawLine(display,view->draw_window->win, dashgc, pl->x1, pl->y1, pl->x2, pl->y2);
				l.x1 = XD2P(OB(list)->bbox.x2,view);
				l.y1 = YD2P(OB(list)->bbox.y2,view);
				l.x2 = XD2P(OB(list)->bbox.x1,view);
				l.y2 = YD2P(OB(list)->bbox.y2,view);
				pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h,&l,&clipped,0);
				if (pl!=NULL)
					XDrawLine(display,view->draw_window->win, dashgc, pl->x1, pl->y1, pl->x2, pl->y2);
				l.x1 = XD2P(OB(list)->bbox.x1,view);
				l.y1 = YD2P(OB(list)->bbox.y2,view);
				l.x2 = XD2P(OB(list)->bbox.x1,view);
				l.y2 = YD2P(OB(list)->bbox.y1,view);
				pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h,&l,&clipped,0);
				if (pl!=NULL)
					XDrawLine(display,view->draw_window->win, dashgc, pl->x1, pl->y1, pl->x2, pl->y2);
				};

	 
			 
			 /* set gc parameters as need be  */  
			if (OB(list)->type!=COMPOUND)
				{
				gc_lw(view, ugc, OB(list)); 
				gc_line(ugc, OB(list));
				gc_fill(fillgc, OB(list));
				gc_colour(view,ugc, OB(list));
				gc_fillcolour(view,fillgc, OB(list));
				};     
					 
			draw_object(OB(list),view,ugc,OB(list)->bbox.x1, OB(list)->bbox.y1, 1.0, 1.0, 0.0,rcx,rcy,rcw,rch);  

			};

		list = list->next; 
		};
			 
	if ((mob!=NULL && ob==mob) || view->show_compounds || gc==blackxorgc)
		{
		long x1,y1,x2,y2; 
		GC agc;
		
		/* draw compound outline  */  
		 
		cx = XD2P(x,view);
		cy = YD2P(y,view);
		cw = 1 + R((XD2P(ob->bbox.x2,view) - XD2P(ob->bbox.x1,view)),rx);
		ch = 1 + R((YD2P(ob->bbox.y2,view) - YD2P(ob->bbox.y1,view)),ry);

		set_clip(ugc, cx, cy, cw, ch);
		set_clip(handlegc, cx, cy, cw, ch);
		set_clip(fillgc, cx, cy, cw, ch);
		set_clip(dashgc, cx, cy, cw, ch);
		 
		if (view->show_compounds && (ob!=mob))
			agc = dashgc;
		else
			agc = handlegc;

		if (gc==blackxorgc)
			agc = blackxorgc;

		if (state.tied_corner!=NOTSCALING)
	      corner_magic(ob, &x, &y, rx, ry);

		rx = abs(rx);
		ry = abs(ry);         
		 
		x1 = XD2P(x,view);
		y1 = YD2P(y,view);
		x2 = XD2P(x + R((ob->bbox.x2-ob->bbox.x1),rx),view);
		y2 = YD2P(y + R((ob->bbox.y2-ob->bbox.y1),ry),view);
		 
		l.x1 = x1;
		l.y1 = y1;
		l.x2 = x2;
		l.y2 = y1;
		pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h,&l,&clipped,0);
		if (pl!=NULL)
			XDrawLine(display,view->draw_window->win, agc, pl->x1, pl->y1, pl->x2, pl->y2);
		l.x1 = x2;
		l.y1 = y1;
		l.x2 = x2;
		l.y2 = y2;
		pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h,&l,&clipped,0);
		if (pl!=NULL)
			XDrawLine(display,view->draw_window->win, agc, pl->x1, pl->y1, pl->x2, pl->y2);
		l.x1 = x2;
		l.y1 = y2;
		l.x2 = x1;
		l.y2 = y2;
		pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h,&l,&clipped,0);
		if (pl!=NULL)
			XDrawLine(display,view->draw_window->win, agc, pl->x1, pl->y1, pl->x2, pl->y2);
		l.x1 = x1;
		l.y1 = y2;
		l.x2 = x1;
		l.y2 = y1;
		pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h,&l,&clipped,0);
		if (pl!=NULL)
			XDrawLine(display,view->draw_window->win, agc, pl->x1, pl->y1, pl->x2, pl->y2);
		};
}
