/* decorate.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: decorate.c,v $
 * Revision 1.3  2000/12/17 00:57:41  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:30  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.9  2000/03/08 01:07:21  moz
 * Compile fixes.
 *
 * Revision 1.8  2000/02/18 21:18:14  moz
 * polyline.pic usage changed.
 *
 * Revision 1.7  1999/11/15 02:07:53  moz
 * Name change.
 *
 * Revision 1.6  1999/08/06 23:34:44  moz
 * Don't show rotate or scale handles for picture objects.
 *
 * Revision 1.5  1999/07/29 20:45:00  moz
 * Draw resize handle for text.
 *
 * Revision 1.4  1999/05/19 17:06:17  moz
 * 1.0 Checkin.
 *
 * Revision 1.3  1999/04/25 19:39:49  moz
 * Fixes for text handles.
 *
 * Revision 1.2  1999/04/25 00:18:33  moz
 * Place rotate handle differently for TEXT objects.
 *
 * Revision 1.1  1999/04/04 03:12:04  moz
 * Initial revision
 *
 */    

/* drawing of various things */ 
 
#include "include/figurine.h"
#include "include/extern.h"

void 
toggle_guidelines(View *v)
{
	XDrawLine(display,v->draw_window->win, blackxorgc, mouse_x, 0, mouse_x, mouse_y - GUIDE_LINE_GAP); 
	XDrawLine(display,v->draw_window->win, blackxorgc, 0, mouse_y, mouse_x - GUIDE_LINE_GAP, mouse_y); 
	XDrawLine(display,v->draw_window->win, blackxorgc, mouse_x + GUIDE_LINE_GAP, mouse_y, 
		(int)v->draw_window->w-1, (int)mouse_y); 
	XDrawLine(display,v->draw_window->win, blackxorgc, mouse_x, mouse_y + GUIDE_LINE_GAP, 
		mouse_x, (int)v->draw_window->h-1);
	v->guide_x = mouse_x;
	v->guide_y = mouse_y;
}

/* for when moving objects etc.  */  
void 
toggle(View *v, int x, int y)
{
	switch (state.current_icon)
	{
	case ARCICON:
		toggle_arc(v,x,y);
		break;

	case SPLINEICON:
		toggle_spline_line(v,x,y);
		break;

	case POLYLINEICON:
		toggle_polyline(v,x,y); 
		break;
		
	case ELLIPSEICON:	
	case BOXELLIPSEICON: 
		toggle_ellipse(v,x,y);
		break;
	
	case ARCELLIPSEICON:
		toggle_arcellipse(v,x,y);
		break;

	case RECTANGLEICON:
		toggle_rectangle(v,x,y);
		break;
	
	case POLYGONICON:
		toggle_polygon(v,x,y);
		break; 
	
	default:
		v_error(state.current_icon); 
		break;
	};
} 

void 
draw_handle(View *v, long x, long y)
{
	XFillRectangle(display,v->draw_window->win, handlegc, x, y, HANDLE_PIXEL_SIZE,HANDLE_PIXEL_SIZE);
}

/* draw handles on an object  */ 
void 
draw_bbox_handles(View *v)
{
	long x1, x2, y1,y2;

	if (v->highlighted_object==NULL || (v->selected_object==NULL && !v->highlight_objects))
		return;
		 
	x1 = XD2P(v->highlighted_object->ob->bbox.x1,v);
	y1 = YD2P(v->highlighted_object->ob->bbox.y1,v);
	x2 = XD2P(v->highlighted_object->ob->bbox.x2,v);
	y2 = YD2P(v->highlighted_object->ob->bbox.y2,v);
	set_clip(handlegc,x1,y1,(x2-x1)+1,(y2-y1)+1); 
	 
	XDrawRectangle(display,v->draw_window->win, handlegc, x1, y1, (uint)(x2-x1), (uint)(y2-y1));       
	 
	if (v->highlighted_object->ob->type==POLYGON && v->highlighted_object->ob->ob.polyline.pic)
		return;  
		  
	if ((x2-x1)>=16 && (y2-y1)>=16 && 
		 (v->highlighted_object->ob->type!=TEXT || !v->highlighted_object->ob->ob.text.node))
		{ 
		draw_handle(v,x2-HANDLE_PIXEL_SIZE, y2-HANDLE_PIXEL_SIZE);
		if (v->highlighted_object->ob->type!=COMPOUND
			 && v->highlighted_object->ob->type!=TEXT) 
			{
			draw_handle(v,x1+1,y1+1);
			draw_handle(v,x2-HANDLE_PIXEL_SIZE, y1+1);
			draw_handle(v,x1+1, y2-HANDLE_PIXEL_SIZE);
			}; 
		}; 
		
	if (v->highlighted_object->ob->type==TEXT && !v->highlighted_object->ob->ob.text.node)
		 XFillArc(display,v->draw_window->win, handlegc, x2-(2*HANDLE_PIXEL_SIZE), y2-(HANDLE_PIXEL_SIZE),
		 HANDLE_PIXEL_SIZE, HANDLE_PIXEL_SIZE, 0, 270*64);
	else if (((x2-x1)>=32 && (y2-y1)>=32 && v->highlighted_object->ob->type!=ELLIPSE && 
	 	 v->highlighted_object->ob->type!=ARCELLIPSE  && v->highlighted_object->ob->type!=COMPOUND && 
		 v->highlighted_object->ob->type!=TEXT && v->highlighted_object->ob->type!=ROUNDBOX))
		 XFillArc(display,v->draw_window->win, handlegc, x2-(2*HANDLE_PIXEL_SIZE), y2-(2*HANDLE_PIXEL_SIZE),
		 HANDLE_PIXEL_SIZE, HANDLE_PIXEL_SIZE, 0, 270*64);


} 
