/* edit_ob.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* for interactive object editing  */ 
/*
 * $Log: edit_ob.c,v $
 * Revision 1.5  2000/12/17 00:57:42  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.4  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.3  2000/08/21 01:32:56  moz
 * Re-add changelog.
 *
 * Revision 1.2  2000/08/21 01:31:02  moz
 * Stop infinitely thin objects from disappearing on resize.
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.29  2000/03/15 00:15:32  moz
 * Unset disable_motion for non-editing..
 *
 * Revision 1.28  2000/03/14 22:41:21  moz
 * Very ugly hack to zoom-motion xor problem. Very tricky to solve,
 * so it's a simple approach: ignore the first few edit_motion()s
 * after a resize.
 *
 * Revision 1.27  2000/03/14 02:48:40  moz
 * Slight xor improvement.
 *
 * Revision 1.26  2000/03/14 01:09:55  moz
 * Make vars static.
 *
 * Revision 1.25  2000/03/06 02:28:10  moz
 * Compile fix.
 *
 * Revision 1.24  2000/02/18 21:18:06  moz
 * Compile fixes.
 *
 * Revision 1.23  2000/02/15 01:47:48  moz
 * Hack to change editing_object.
 *
 * Revision 1.22  2000/02/04 01:52:53  moz
 * switch_icons() needs view.
 *
 * Revision 1.21  2000/01/31 20:39:13  moz
 * Removed unnecessary (and possibly broken) selected = highlighted.
 *
 * Revision 1.20  2000/01/31 01:17:09  moz
 * Less flicker on highlighted object
 *
 * Revision 1.19  1999/11/15 02:11:27  moz
 * Round angles to 90 degrees if nearby.
 * Fixed logic when switching highlighted_object.
 *
 * Revision 1.18  1999/08/06 23:34:59  moz
 * Don't allow rotation or scaling of a picture object.
 *
 * Revision 1.17  1999/07/29 20:45:21  moz
 * Allow text to be resized.
 *
 * Revision 1.16  1999/06/16 00:55:25  moz
 * Change to rotation to allow fine-tune (vertical).
 *
 * Revision 1.15  1999/05/31 23:05:43  moz
 * Fix previous fix.
 *
 * Revision 1.14  1999/05/28 19:59:02  moz
 * Need to xor off outline again when releasing outside window.
 *
 * Revision 1.13  1999/05/22 02:55:33  moz
 * Code clear-up (partly).
 *
 * Revision 1.12  1999/05/19 17:10:58  moz
 * 1.0 Checkin.
 *
 * Revision 1.11  1999/04/27 19:50:35  moz
 * Fixed rubberbanding problems.
 *
 * Revision 1.10  1999/04/27 04:10:35  moz
 * -Wall appeased.
 *
 * Revision 1.9  1999/04/26 19:59:34  moz
 * Use move_object.
 *
 * Revision 1.8  1999/04/26 19:06:44  moz
 * When cancelling with Button3, reset state Booleans.
 *
 * Revision 1.7  1999/04/25 19:44:45  moz
 * Fixes for rotating text.
 *
 * Revision 1.6  1999/04/25 00:21:23  moz
 * Rotation of text interface started.
 *
 * Revision 1.5  1999/04/23 00:38:59  moz
 * redraw_view_window change.
 *
 * Revision 1.4  1999/04/22 22:15:50  moz
 * Don't register undos for members of compound object in resize.
 *
 * Revision 1.3  1999/04/22 16:16:54  moz
 * Fix for arc circles.
 *
 * Revision 1.2  1999/04/04 01:48:58  moz
 * Now needs View as well.
 *
 * Revision 1.1  1999/03/30 00:04:48  moz
 * Initial revision
 *
 */    

#include "include/figurine.h"
#include "include/extern.h"

 
int disable_motion=0;

static Object *mob=NULL; /* moving object */  
static long mx, my; 
static long gox, goy; 
static long ox, oy; 
static long ngox, ngoy; 
static double rx, ry; 
static double angle=0.0; /* rotation angle  */ 

static Boolean rotating_object=FALSE; 
static Boolean resizing_object=FALSE;

extern Boolean just_resized; 
 
void 
toggle_object_outline(View *v)
{
	draw_object(mob,v,blackxorgc,ox,oy, rx, ry,angle,0,0,0,0);  
}

/* we change object when we decide to  */
Boolean 
new_object(View *v,long x, long y)
{
	if (v->selected_object!=NULL)
		{
		if (!is_in_bbox(x,y,
			 XD2P(v->selected_object->ob->bbox.x1,v),
			 YD2P(v->selected_object->ob->bbox.y1,v),
			 XD2P(v->selected_object->ob->bbox.x2,v),
			 YD2P(v->selected_object->ob->bbox.y2,v)))
			return TRUE;
		else
			return FALSE; /* if we click in the selected object, stay with it */ 
		}
	else
		return TRUE;
}

/* has user clicked on a rotate handle of an object ?  */  
Boolean 
edit_on_rotate_handle(View *view, Object *ob, long x, long y)
{
	return (((ob->type!=ARCELLIPSE && ob->type!=ELLIPSE && ob->type!=COMPOUND && ob->type!=TEXT &&
			  is_in_box(x,y,XD2P(ob->bbox.x2,view)-(2*HANDLE_PIXEL_SIZE),
			  			   YD2P(ob->bbox.y2,view)-(2*HANDLE_PIXEL_SIZE),
			  			   HANDLE_PIXEL_SIZE, HANDLE_PIXEL_SIZE)) ||
				(ob->type==TEXT && !ob->ob.text.node &&
			   is_in_box(x,y,XD2P(ob->bbox.x2,view)-(2*HANDLE_PIXEL_SIZE),
			  			   YD2P(ob->bbox.y2,view)-(HANDLE_PIXEL_SIZE),
			  			   HANDLE_PIXEL_SIZE, HANDLE_PIXEL_SIZE))) 
				&& !(ob->type==POLYGON && ob->ob.polyline.pic));	
}

/* has user clicked on a scaling handle of an object ?  */  
/* if so record which corner should stay in place  */  
Boolean 
edit_on_handle(View *view, Object *ob, long x, long y)
{
	if (ob->type==POLYGON && ob->ob.polyline.pic)	
		return FALSE;

	/* remember we can assume inside of box  */  
	if (x >= (XD2P(ob->bbox.x2,view) - HANDLE_PIXEL_SIZE) && y >= (YD2P(ob->bbox.y2,view) - HANDLE_PIXEL_SIZE)
	    && (ob->type!=TEXT || !ob->ob.text.node))
		{
		state.tied_corner = TOPLEFT;
		return TRUE;
		};
		
	if (ob->type==COMPOUND || ob->type==TEXT)
		return FALSE;

	if (x <= (HANDLE_PIXEL_SIZE + XD2P(ob->bbox.x1,view)) && y >= (YD2P(ob->bbox.y2,view) - HANDLE_PIXEL_SIZE))
		{
		state.tied_corner = TOPRIGHT;
		return TRUE;
		};
		
	if (x >= (XD2P(ob->bbox.x2,view) - HANDLE_PIXEL_SIZE) && y <= (HANDLE_PIXEL_SIZE + YD2P(ob->bbox.y1,view)))
		{
		state.tied_corner = BOTTOMLEFT;
		return TRUE;
		};
		
	if (x <= (HANDLE_PIXEL_SIZE + XD2P(ob->bbox.x1,view)) && y <= (HANDLE_PIXEL_SIZE + YD2P(ob->bbox.y1,view)))
		{
		state.tied_corner = BOTTOMRIGHT;
		return TRUE;
		};
		
	
	return FALSE;
}

void 
edit_button(BEvent *bev, View *v)
{
	Node *n;
	 
	if (v->edited_object!=NULL)
		{
		/* hook into point editing  */ 
		switch (v->edited_object->ob->type)
			{
			case SPLINE:
			case ARC: 
				spline_point_button(bev,v);
				break;

			case POLYLINE:
			case POLYGON: 
				polyline_point_button(bev,v);
				break;
			
			default:
				break;
			}; 
		}
	else if (bev->button == Button1)
		{
		n = v->highlighted_object;

		switch (bev->type)
			{
			case BUTTON_HELD:
				if (new_object(v,bev->x,bev->y))
					{
					/* get new object  */  
					v->highlighted_object = object_at_point_p(v,v->doc->o,bev->x,bev->y);

					v->selected_object = v->highlighted_object; 
					switch_icons(v); 

					if (n && (!v->highlight_objects || (n != v->highlighted_object)))
 						send_redraw_object(v,n->ob);
					};

				if (v->highlighted_object!=NULL)
					{
					v->selected_object = v->highlighted_object; 
					switch_icons(v); 
					state.editing_object = TRUE;
					 
					/* set start parameters for moving objects  */  
					gox = XP2D(bev->x,v) - v->highlighted_object->ob->bbox.x1;
					goy = YP2D(bev->y,v) - v->highlighted_object->ob->bbox.y1;
					 
					mx = XP2D(bev->x,v);
					my = YP2D(bev->y,v);
					
					mob = v->selected_object->ob;

					if (edit_on_handle(v, mob, bev->x, bev->y))
						resizing_object = TRUE;
					else if (edit_on_rotate_handle(v,mob,bev->x,bev->y))
						{ 
						rotating_object = TRUE;
						};
						 
					if (v->gridon)
						{
						ox = snap(v->grid_x,v->highlighted_object->ob->bbox.x1);
						oy = snap(v->grid_y,v->highlighted_object->ob->bbox.y1);
						}
					else
						{
						ox = v->highlighted_object->ob->bbox.x1;
						oy = v->highlighted_object->ob->bbox.y1;
						}; 

					ngox = v->highlighted_object->ob->bbox.x1;
					ngoy =  v->highlighted_object->ob->bbox.y1;

					angle=0.0;
					rx = 1; ry = 1; 
					 
					state.rubberon = FALSE;
					
					send_redraw_object(v, v->selected_object->ob);
					}; 
				break;

			case BUTTON_CLICKED:
			case BUTTON_RELEASED: 

				/* another unmaintainable hack */  
				if (state.editing_object && !v->selected_object)
					{
					v->highlighted_object=NULL;
					state.editing_object=FALSE;
					};

				if (state.editing_object)
					{
					if (resizing_object == TRUE)
						{
						if (v->guide_lines && v->guide_lines_displayed) 
							{
							toggle_guidelines(v);
							v->guide_lines_displayed = FALSE;
							};
						/* scale the object as requested  */  
						apply_scale_to_object(v,mob, rx, ry,TRUE);
						state.tied_corner = NOTSCALING; 
						resizing_object = FALSE;
						}
					else if (rotating_object==TRUE)
						{
						if (v->guide_lines && v->guide_lines_displayed) 
							{
							toggle_guidelines(v);
							v->guide_lines_displayed = FALSE;
							};
						/* rotate the object as requested */  
						apply_rotate_to_object(v,mob,angle);
						angle = 0.0; 
						rotating_object = FALSE; 
						}
					else
						{
						/* see if moved */   
						if ((ngox != v->selected_object->ob->bbox.x1) ||
							 (ngoy != v->selected_object->ob->bbox.y1)) 
							{  
							toggle_object_outline(v); 
							/* if in document, move object */
							if (P_IN_DOC(bev->x, bev->y,v))
								{
								Object *ob = v->selected_object->ob; 
								register_undo(UNDO_OB_PROP,ob,v->doc);
								store_redraw_object(ob);
								move_object(v,ob, mx-ob->bbox.x1, my-ob->bbox.y1);  
								send_stored_redraw_object(v,ob);
								}; 
							};
						}; 
						 
					state.editing_object = FALSE; 
					
					switch_icons(v); 
					}
				else
					{ 
					v->selected_object = v->highlighted_object; 
					switch_icons(v); 
					}; 
				break;
			};
		}
	else if (bev->button == Button3)
		{
		if (state.editing_object)
			{ 
			draw_object(mob,v,blackxorgc,ox,oy, rx, ry,angle,0,0,0,0);
						 
			/* cancel it all  */ 
			state.editing_object = FALSE; 
			rotating_object = FALSE; 
			angle = 0; 
			resizing_object = FALSE; 
			}
		else if (v->selected_object!=NULL)
			{
			n = v->selected_object;

			v->selected_object = NULL;
			switch_icons(v); 
			/* this is to provide visual feedback of selection cancellation when
				pointer is still on object */  
			v->highlighted_object = NULL; 
			
			send_redraw_object(v,n->ob);
			};
		};
} 

void 
edit_motion(View *v, long x, long y)
{
	if (v->edited_object!=NULL)
		{
		/* hook into point editing  */ 
		switch (v->edited_object->ob->type)
			{
			case SPLINE:
			case ARC: 
				spline_point_motion(v,x,y);
				break;

			case POLYLINE:
			case POLYGON: 
				polyline_point_motion(v,x,y);
				break;
			
			default:
				break;
			}; 
		}
	else if (state.editing_object)
		{
		int test=-1,test2=-1;
		
		if (disable_motion)
			{
			disable_motion--;
			return;
			}; 

		if (just_resized)
			just_resized=FALSE;
		else	 
			toggle_object_outline(v); 
		 
		/* if not rotating, mouse may be at document window border  */  
		/* if so, scroll the view window along  */  
		if (!rotating_object)
			{
			if (x < MOVE_BOUNDARY) /* move left */  
				test = nudge_ruler_x(v->ruler_x_window, v, LEFT);
			else if (x >= ((signed long)(v->draw_window->w)) - MOVE_BOUNDARY) /* move right */ 
				test = nudge_ruler_x(v->ruler_x_window, v, RIGHT);
					
			if (y < MOVE_BOUNDARY) /* move up */  
				test2 = nudge_ruler_y(v->ruler_y_window, v, UP); 
			else if (y >= ((signed long)(v->draw_window->h)) - MOVE_BOUNDARY) /* move down */ 
				test2 = nudge_ruler_y(v->ruler_y_window, v, DOWN); 
				 
			if (test!=-1 || test2!=-1) 
				{ 
				state.rubberon=FALSE; 
				redraw_view_window(v);
				};
			};

		if (resizing_object)
			{
			unsigned int xdel,ydel;
			xdel = (mob->bbox.x2 - mob->bbox.x1);
			ydel = (mob->bbox.y2 - mob->bbox.y1);
			if (!xdel)
				xdel=XP2D(1,v);
			if (!ydel)
				ydel=YP2D(1,v);

			/* calculate scaling factors  */  
			 switch (state.tied_corner)
				{
				case TOPLEFT:
					if (v->gridon)
						{
						rx = ((double)GXP2D(x,v)-mob->bbox.x1) / xdel;
						ry = ((double)GYP2D(y,v)-mob->bbox.y1) / ydel;
						}
					else
						{
						rx = ((double)XP2D(x,v)-mob->bbox.x1) / xdel;
						ry = ((double)YP2D(y,v)-mob->bbox.y1) / ydel;
						};
					break;

				case TOPRIGHT:
					if (v->gridon)
						{
						rx = ((double)GXP2D(x,v)-mob->bbox.x2) / xdel;
						ry = ((double)GYP2D(y,v)-mob->bbox.y1) / ydel;
						}
					else
						{
						rx = ((double)XP2D(x,v)-mob->bbox.x2) / xdel;
						ry = ((double)YP2D(y,v)-mob->bbox.y1) / ydel;
						};
					break;
				
				case BOTTOMLEFT:
					if (v->gridon)
						{
						rx = ((double)GXP2D(x,v)-mob->bbox.x1) / xdel;
						ry = ((double)GYP2D(y,v)-mob->bbox.y2) / ydel;
						}
					else
						{
						rx = ((double)XP2D(x,v)-mob->bbox.x1) / xdel;
						ry = ((double)YP2D(y,v)-mob->bbox.y2) / ydel;
						};
					break;

				case BOTTOMRIGHT:
					if (v->gridon)
						{
						rx = ((double)GXP2D(x,v)-mob->bbox.x2) / xdel;
						ry = ((double)GYP2D(y,v)-mob->bbox.y2) / ydel;
						}
					else
						{
						rx = ((double)XP2D(x,v)-mob->bbox.x2) / xdel;
						ry = ((double)YP2D(y,v)-mob->bbox.y2) / ydel;
						};
					break;
				
				default:
					v_error(NOTSCALING);
					break;
				};

			/* must only allow arcellipse to be of circular proportions */  
			/* text can reasonably be approximated by a proportional box  */  
			/* other objects are resized proportionally with Control  */  
			if (state.control_down || mob->type==ARCELLIPSE || mob->type==TEXT)
				constrain_resize(&rx, &ry);
			}
		else if (rotating_object)
			{
			static Boolean last_shift=FALSE;
			static double tangle; 

			if (state.shift_down)
				{
				double delta; 
				
				if (last_shift!=TRUE)
					tangle=angle;
				 
				if (mob->type==TEXT)
					delta = min(P2D(ROTATE_PIXEL_SIZE,v),max(P2D(-ROTATE_PIXEL_SIZE,v),YP2D(y, v)-(mob->bbox.y2-(P2D(HANDLE_PIXEL_SIZE,v)))));
				else 
					delta = min(P2D(ROTATE_PIXEL_SIZE,v),max(P2D(-ROTATE_PIXEL_SIZE,v),YP2D(y, v)-(mob->bbox.y2-(2*P2D(HANDLE_PIXEL_SIZE,v)))));
				
				delta /= 17*P2D(ROTATE_PIXEL_SIZE,v);
				angle = tangle + delta; 
				}
			else
				{
				/* calculate the rotation angle based
					on mouse position from start */  

				if (mob->type==TEXT)
					angle = min(P2D(ROTATE_PIXEL_SIZE,v),max(P2D(-ROTATE_PIXEL_SIZE,v),XP2D(x, v)-(mob->bbox.x2-(P2D(HANDLE_PIXEL_SIZE,v)))));
				else 
					angle = min(P2D(ROTATE_PIXEL_SIZE,v),max(P2D(-ROTATE_PIXEL_SIZE,v),XP2D(x, v)-(mob->bbox.x2-(2*P2D(HANDLE_PIXEL_SIZE,v)))));
				
				angle /= P2D(ROTATE_PIXEL_SIZE,v);
				angle *= PI;
				 
				/* if near 90 degrees rotation, set to exactly 90 degrees */ 	
				if (abs(angle / (PI/2.0)) - ((long)(angle / (PI/2.0))) < ROTATE_RECTI_THRESHOLD) 
					angle = ((long)(angle / (PI/2.0))) * (PI/2.0); 
					 
				}; 
				 
			last_shift = state.shift_down;
			}
		else
			{
			/* we're moving the object  */  
			if (v->gridon)
				{
				ox = snap(v->grid_x,XP2D(x,v)-gox);
				oy = snap(v->grid_y,YP2D(y,v)-goy);
				}
			else
				{
				ox = XP2D(x,v)-gox;
				oy = YP2D(y,v)-goy;
				};
			 
			ngox = XP2D(x,v)-gox;
			ngoy = YP2D(y,v)-goy;
			mx = ox;
			my = oy;
			};

		toggle_object_outline(v);
			 
		state.rubberon = TRUE; 
		}
	else if (v->selected_object==NULL)
		{
		if (disable_motion)
			disable_motion=0;

		/* we need to prevent hole in highlight  */ 
		if (v->highlighted_object!=NULL)
			{
			Object *ob = v->highlighted_object->ob; 
			 
			if (!still_same_object_p(v,v->highlighted_object,x,y)) 
				{ 
				if ((v->highlighted_object = object_at_point_p(v,v->doc->o, x, y))==NULL) {
					if (v->highlight_objects)
						send_redraw_object(v,ob); 
				} else if (v->highlighted_object->ob != ob) {
					if (v->highlight_objects) { 
						send_redraw_object(v,ob); 
						send_redraw_object(v,v->highlighted_object->ob); 
					};
				};
					 
			};
		} else
			{
			if ((v->highlighted_object = object_at_point_p(v,v->doc->o, x, y))!=NULL)
				if (v->highlight_objects) { 
					send_redraw_object(v,v->highlighted_object->ob); 
				}; 
			};
		};
}
