/* Run X Event loop */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: event_loop.c,v $
 * Revision 1.3  2000/12/17 00:57:42  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:30  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.37  2000/03/13 17:35:46  moz
 * Removed dead code.
 *
 * Revision 1.36  2000/03/07 21:38:16  moz
 * Compile fixes.
 *
 * Revision 1.35  2000/02/21 03:17:01  moz
 * Don't ungrab pointer on FocusOut.
 *
 * Revision 1.34  2000/02/17 22:22:33  moz
 * Use kill_undo().
 *
 * Revision 1.33  2000/02/01 16:02:34  moz
 * We don't seem to need nasty hack anymore.
 *
 * Revision 1.32  2000/01/30 17:19:31  moz
 * Deal with destruction of a check-out message.
 *
 * Revision 1.31  2000/01/28 15:59:07  moz
 * Removed debugging printfs.
 *
 * Revision 1.30  2000/01/26 18:11:51  moz
 * Free objects.
 *
 * Revision 1.29  2000/01/24 22:19:14  moz
 * Fixed memleak with kill_object() being called with a dead pointer.
 *
 * Revision 1.28  2000/01/21 11:47:28  moz
 * Use rulergc instead of blackgc for icon window line.
 *
 * Revision 1.27  2000/01/21 11:21:52  moz
 * last_mouse_movement isn't used.
 *
 * Revision 1.26  1999/11/16 01:50:04  moz
 * Reduce indentation.
 *
 * Revision 1.25  1999/11/15 02:11:03  moz
 * Name change.
 *
 * Revision 1.24  1999/08/08 23:35:01  moz
 * Farmed STK_ICON_CHOSEN off to handle_icon.c
 *
 * Revision 1.23  1999/08/08 20:54:32  moz
 * Clean up structs.
 *
 * Revision 1.22  1999/07/04 19:20:31  moz
 * Fix for naughty wm's that don't report x,y properly.
 *
 * Revision 1.21  1999/07/04 02:04:14  moz
 * Really unpleasant mess to fix some of the object band droppings.
 *
 * Revision 1.20  1999/07/03 21:35:29  moz
 * zoom_in() and zoom_out() from a button==TRUE.
 *
 * Revision 1.19  1999/06/16 00:55:42  moz
 * Close tooltip if a button event, and not STK window, or leaving
 * top-level window.
 *
 * Revision 1.18  1999/05/24 17:28:50  moz
 * Removed un-needed stk_open_dialog()s that were core-dumping.
 *
 * Revision 1.17  1999/05/22 23:38:38  moz
 * Pedantic ANSI.
 *
 * Revision 1.16  1999/05/22 02:55:21  moz
 * new_doc now takes an argument.
 *
 * Revision 1.15  1999/05/19 17:10:50  moz
 * 1.0 Checkin.
 *
 * Revision 1.14  1999/05/05 12:28:33  moz
 * Print.
 *
 * Revision 1.13  1999/05/04 22:23:29  moz
 * Nullify state.menu_view on STK_MENU_CANCELLED.
 *
 * Revision 1.12  1999/05/03 06:20:50  moz
 * fill_in_files takes .fig filter option.
 *
 * Revision 1.11  1999/04/29 22:01:23  moz
 * do_redo()
 *
 * Revision 1.10  1999/04/28 20:57:29  moz
 * Don't need SET_CLIP_WINDOW.
 *
 * Revision 1.9  1999/04/28 00:25:31  moz
 * Menu should appear in correct place with broken wm;s.
 *
 * Revision 1.8  1999/04/27 21:10:30  moz
 * Hide/show tooltips added.
 *
 * Revision 1.7  1999/04/27 16:55:14  moz
 * Flip object.
 *
 * Revision 1.6  1999/04/27 04:24:59  moz
 * draw_view change.
 *
 * Revision 1.5  1999/04/23 01:05:08  moz
 * Respond to show_fig_files_only request.
 *
 * Revision 1.4  1999/04/23 00:39:26  moz
 * Moved view drawing into draw.c
 *
 * Revision 1.3  1999/04/04 01:49:12  moz
 * Handling of export dialog implemented.
 *
 * Revision 1.2  1999/04/03 21:13:30  moz
 * Moved help to start_help() in handle_menu.c
 *
 * Revision 1.1  1999/03/30 00:04:49  moz
 * Initial revision
 *
 */    

#include <stdio.h>
#include <string.h> 

#include "include/figurine.h"
#include "include/extern.h" 

extern Object *buffer;

void handle_event(XEvent);

void
handle_event(XEvent report)
{
	List l; 
	List l2;
	char a[FIGURINE_PATH_MAX]; 
	View *v; 
	 
/* indentation central */ 
switch (report.type)
	{
	case DestroyNotify:
	case EnterNotify: 
	case FocusIn:
	case FocusOut:
	case KeyRelease:
		break;

	case ButtonPress:
		l = where_in_list(wins,report.xmotion.window);
		if (l==NULL)
			break;
		 
	 	/* go to mouse_button.c  */  
		handle_button_press(&report); 
		break;

	case ButtonRelease: 
		l = where_in_list(wins,report.xmotion.window);
		if (l==NULL)
			break;
	 
	 	/* go to mouse_button.c  */  
		handle_button_release(&report); 
		break; 
		
	case KeyPress: 
		/* go to keyboard.c  */  
		handle_keypress((XKeyPressedEvent *)&report);
		break;
		
	case MotionNotify:
		l = where_in_list(wins,report.xmotion.window);
		if (l==NULL)
			break;
	 
	 	/* go to mouse_motion.c  */  
		handle_motion(&report);	
		break;

	case LeaveNotify:
		l = where_in_list(wins,report.xcrossing.window);

		if (l!=NULL && l->type==DRAW_WIN)
			{
			l2 = where_in_list(wins,WS(l)->parent);
			if (l2==NULL)
				break;

			/* if leaving document window, remove guidelines  */ 
			if (VIEW(l2)->guide_lines_displayed)
				toggle_guidelines(VIEW(l2));
					
			VIEW(l2)->guide_lines_displayed = FALSE;
			};
		break;


	case ConfigureNotify:
		l = where_in_list(wins,report.xconfigure.window);
					 
		if(l!=NULL && l->type==MAIN_VIEW_WIN)
			{
			/* configuring a view window  */ 
			/* need to resize the subwindows  */  
						
			if (VIEW(l)->window.w != (uint)report.xconfigure.width ||
				 VIEW(l)->window.h != (uint)report.xconfigure.height) 
				{
				if (INCHES_TO_PIXELS(VIEW(l)->doc->width_in_inches)< report.xconfigure.width)
					VIEW(l)->x_inches_offset = 0;

				if (INCHES_TO_PIXELS(VIEW(l)->doc->height_in_inches)< report.xconfigure.height)
					VIEW(l)->y_inches_offset = 0;

				VIEW(l)->window.w = report.xconfigure.width;
				VIEW(l)->draw_window->w = VIEW(l)->window.w - RULER_PIXEL_SIZE;
				VIEW(l)->ruler_x_window->w = VIEW(l)->window.w - RULER_PIXEL_SIZE;
				VIEW(l)->window.h = report.xconfigure.height;
				VIEW(l)->draw_window->h = VIEW(l)->window.h - RULER_PIXEL_SIZE - VIEW_ICON_SIZE;
				VIEW(l)->ruler_y_window->h = VIEW(l)->window.h - RULER_PIXEL_SIZE - VIEW_ICON_SIZE;
				VIEW(l)->view_icon_window->y = VIEW(l)->window.h - VIEW_ICON_SIZE;
				VIEW(l)->view_icon_window->w = VIEW(l)->window.w;
				XResizeWindow(display, VIEW(l)->ruler_x_window->win, 
							VIEW(l)->ruler_x_window->w,
							VIEW(l)->ruler_x_window->h);
				XResizeWindow(display, VIEW(l)->ruler_y_window->win, 
							VIEW(l)->ruler_y_window->w,
							VIEW(l)->ruler_y_window->h);
				XResizeWindow(display, VIEW(l)->draw_window->win, 
							VIEW(l)->draw_window->w,
							VIEW(l)->draw_window->h);
				XMoveResizeWindow(display, VIEW(l)->view_icon_window->win,
							VIEW(l)->view_icon_window->x, 
							VIEW(l)->view_icon_window->y, 
							VIEW(l)->view_icon_window->w,
							VIEW(l)->view_icon_window->h);	
 				SET_CLIP_WINDOW(blackxorgc,VIEW(l)->draw_window);  
				}
			else
				{
				VIEW(l)->window.x = report.xconfigure.x;
				VIEW(l)->window.y = report.xconfigure.y;
				}; 
			};
		break;

	case Expose:
		l = where_in_list(wins,report.xexpose.window);
		if (l==NULL)
			break;

		switch (l->type)
			{
			case MAIN_VIEW_WIN:
				break;

			case DRAW_WIN:
				l2 = where_in_list(wins, WS(l)->parent);
				if (l2==NULL)
					break;

				/* redraw the document window  */  
				draw_view(VIEW(l2),report.xexpose.x,report.xexpose.y,report.xexpose.width,report.xexpose.height);
				break;

			case RULER_X_WIN:
				l2 = where_in_list(wins,WS(l)->parent);
				if (l2==NULL)
					break;

				if (VIEW(l2)->in_mm) 
					draw_ruler_x_mm(WS(l),VIEW(l2)->zoom_factor, INCHES_TO_MM(VIEW(l2)->x_inches_offset));     
				else 
					draw_ruler_x(WS(l),VIEW(l2)->zoom_factor, VIEW(l2)->x_inches_offset);
				break;

			case RULER_Y_WIN:
				l2 = where_in_list(wins,((WindowStruct *)l->data)->parent); 
				if (l2==NULL)
					break;

				if (VIEW(l2)->in_mm) 
					draw_ruler_y_mm(WS(l),VIEW(l2)->zoom_factor, INCHES_TO_MM(VIEW(l2)->y_inches_offset));     
				else 
					draw_ruler_y(WS(l),VIEW(l2)->zoom_factor, VIEW(l2)->y_inches_offset);
				break;
						
			case VIEW_ICON_WIN:
				XDrawLine(display, WS(l)->win, rulergc, 0,0,(int)WS(l)->w,0);
				break; 
			};
		break;
				
	case ClientMessage:
		/* handle delete window request */  
		if (((Atom)report.xclient.message_type)==winproto) 
			{
			if ((Atom)report.xclient.data.l[0]==windelete)
				{
				if (report.xclient.window==toolWindow.win)
					close_down();
				else
					{
					l = where_in_list(wins,report.xclient.window);

					if (l!=NULL) 
						close_view(VIEW(l)); 
					else
						{
						l=docs;
						while (l!=NULL)
							{
							if (DOC(l)->check_dial==report.xclient.window)
								{ 
								DOC(l)->check_dial=0;
								break;
								};
							l=l->next; 
							};
						}; 
					};
				};
			break;
			};

		/* STK message  */
		switch (report.xclient.message_type)
			{
			case STK_MENU_CHOSEN:
				switch (report.xclient.data.l[0])
					{
					case FILE_NEW:
						new_view(new_doc(TRUE));
						break;

					case FILE_OPEN:
						fill_in_file(lfile_text,rfile_text,state.show_fig_files_only);
						if (state.show_fig_files_only) 
							stk_choice_on(file_figfiles,0);
						else
							stk_choice_off(file_figfiles,0);
						stk_set_text_entry(file_entry,state.cwd);
						stk_open_dialog(file_dialog,NULL);
						break;

					case FILE_INSERT:
						fill_in_file(insertlfile_text,insertrfile_text,state.show_fig_files_only);
						if (state.show_fig_files_only) 
							stk_choice_on(insertfile_figfiles,0);
						else
							stk_choice_off(insertfile_figfiles,0);
						stk_set_text_entry(insertfile_entry,state.cwd);
						stk_open_dialog(insertfile_dialog,((void *)report.xclient.data.l[1]));
						break;

					case FILE_SAVE:
						save(((View *)report.xclient.data.l[1])->doc);
						break;

					case FILE_SAVE_AS:
						fill_in_file(savelfile_text, saverfile_text, state.show_fig_files_only);
						if (state.show_fig_files_only) 
							stk_choice_on(savefile_figfiles,0);
						else
							stk_choice_off(savefile_figfiles,0);
						stk_set_text_entry(savefile_entry,state.cwd);
						stk_open_dialog(savefile_dialog,((void *)report.xclient.data.l[1]));
						break;

					case FILE_EXPORT:
						v = (View *)report.xclient.data.l[1]; 
						fill_in_file(exportlfile_text, exportrfile_text,FALSE);
						strcpy(a,v->doc->pathname);
						strcat(a,v->doc->filename);
						stk_set_text_entry(exportfile_entry,a);
						add_export_extension(EXPORT_EPS); 
						stk_select_textlist_member(exportformat_text,".eps: Encapsulated PostScript");
						stk_open_dialog(exportfile_dialog,(void *)v);
						break;

					case FILE_PRINT:
					   v = (View *)report.xclient.data.l[1];
						strcpy(a,state.print);
						stk_set_text_entry(printfile_entry,a);
						if (v->doc->centred)
							{
							stk_choice_on(printfile_choice,1);
							stk_choice_off(printfile_choice,2);
							}
						else
							{
							stk_choice_on(printfile_choice,2);
							stk_choice_off(printfile_choice,1);
							};
						stk_open_dialog(printfile_dialog,(void *)v);
						break;

					case FILE_CLOSE:
						close_view((View *)report.xclient.data.l[1]);
						break;

					case FILE_QUIT:
						close_down();
						break;

					case HELP_CONTENTS:
						start_help(); 
						break;

					case HELP_TOOLTIPS:
						tooltips = !tooltips;
						stk_tooltips(tooltips);
						if (tooltips)
							stk_change_menu_label(hpw,"Show tooltips","Hide tooltips");
						else
							stk_change_menu_label(hpw,"Hide tooltips","Show tooltips");
						break;

					case VIEW_UNDO:
						do_undo();
						break;
					
					case VIEW_REDO:
						do_redo();
						break;
						 
					case NEW_VIEW:
						new_view(((View *)report.xclient.data.l[1])->doc);
						break;

					case VIEW_SETTINGS:
						v = (View *)report.xclient.data.l[1]; 
						sprintf(a,"%.3f",((double)(v->grid_x))/v->doc->ppi); 
						stk_set_text_entry(view_gridx_entry,a);
						sprintf(a,"%.3f",((double)(v->grid_y))/v->doc->ppi); 
						stk_set_text_entry(view_gridy_entry,a);
						if (v->in_mm)
							{ 
							stk_choice_on(view_units,1);
							stk_choice_off(view_units,2);
							}
						else
							{
							stk_choice_on(view_units,2);
							stk_choice_off(view_units,1);
							}; 
						if (v->guide_lines)
							stk_choice_on(view_guides,0);
						else
							stk_choice_off(view_guides,0);
							 
						if (v->highlight_objects)
							stk_choice_on(view_highlight,0);
						else
							stk_choice_off(view_highlight,0);

						if (v->show_compounds)
							stk_choice_on(view_compounds,0);
						else
							stk_choice_off(view_compounds,0);
							
						stk_open_dialog(view_dialog,v);
						break;

					case EDIT_CUT:
						v = ((View *)report.xclient.data.l[1]);
						if (v->selected_object!=NULL)
							{
							Object *ob=v->selected_object->ob;
							cut_object(v,v->selected_object->ob);
							v->selected_object = NULL; 
							v->highlighted_object = NULL; 
							send_redraw_object(v,ob);
							stk_enable_menu_label(emw,2); 
							};
						break;

					case EDIT_COPY:
						v = ((View *)report.xclient.data.l[1]);
						if (v->selected_object!=NULL)
							{ 
							copy_object(v->selected_object->ob);
							stk_enable_menu_label(emw,2); 
							}; 
						break;

					case EDIT_PASTE:
						v = ((View *)report.xclient.data.l[1]);
						if (v->selected_object!=NULL)
							{
							Object *ob=v->selected_object->ob;
							v->selected_object = NULL; 
							v->highlighted_object = NULL; 
							send_redraw_object(v,ob);
							}; 
						paste_object(v,XP2D(mouse_x,v),YP2D(mouse_y,v));
						break;

					case EDIT_DELETE: 
						v = (View *)report.xclient.data.l[1];
						if (v->selected_object!=NULL)
							{
							Object *ob=v->selected_object->ob;
							register_undo(UNDO_CUT,ob,v->doc); 
							send_redraw_object(v,ob);
							v->doc->o = trash_object(v->doc->o, &v->doc->lo, v->selected_object->ob);
							kill_object(ob); 
							v->selected_object = NULL; 
							v->highlighted_object = NULL; 
							};
						break;

					case EDIT_RAISE:
						v = (View *)report.xclient.data.l[1]; 
						if (v->selected_object!=NULL)
							{
							register_undo(UNDO_OB_PROP, v->selected_object->ob, v->doc);
							v->selected_object->ob->depth = v->doc->ob_depth--;
							if (v->selected_object->ob->type==TEXT &&
								 v->selected_object->ob->ob.text.node)
								 v->selected_object->ob->ob.text.ellipse->depth = v->selected_object->ob->depth+1;
							send_redraw_object(v,v->selected_object->ob);
							};
						break;

					case EDIT_LOWER:
						v = (View *)report.xclient.data.l[1]; 
						if (v->selected_object!=NULL)
							{
							ulong new_depth;

							register_undo(UNDO_OB_PROP, v->selected_object->ob, v->doc);
							new_depth = v->selected_object->ob->depth; 
							  
							l  = intersecting_objects(v->doc->o, v->selected_object->ob->bbox, NULL);
							l2 = l; 

							while (l!=NULL)
								{
								if (OB(l)!=v->selected_object->ob) 
									new_depth = OB(l)->depth; 
								else 
									break; 
								l = l->next; 
								};

							v->selected_object->ob->depth = ++new_depth;
							if (v->selected_object->ob->type==TEXT &&
								 v->selected_object->ob->ob.text.node)
								 v->selected_object->ob->ob.text.ellipse->depth = v->selected_object->ob->depth+1;
							send_redraw_object(v, v->selected_object->ob);
							delete_list(l2); 
							};
						break;
						 
					case FLIP_X:
						v = (View *)report.xclient.data.l[1]; 
						flip_object_x(v,v->selected_object->ob);
						break;

					case FLIP_Y:
						v = (View *)report.xclient.data.l[1]; 
						flip_object_y(v,v->selected_object->ob);
						break;

					default:
						break;
					};
				break;
			
			/* update values returned from dialogs  */  
			case STK_CHOICE_PRESSED:
				if (report.xclient.window==file_figfiles)
					{
					state.show_fig_files_only = report.xclient.data.l[2];
					fill_in_file(lfile_text,rfile_text,state.show_fig_files_only);
					if (state.show_fig_files_only) 
						stk_choice_on(file_figfiles,0);
					else
						stk_choice_off(file_figfiles,0);
					} 
				else if (report.xclient.window==insertfile_figfiles)
					{
					state.show_fig_files_only = report.xclient.data.l[2];
					fill_in_file(insertlfile_text,insertrfile_text,state.show_fig_files_only);
					if (state.show_fig_files_only) 
						stk_choice_on(insertfile_figfiles,0);
					else
						stk_choice_off(insertfile_figfiles,0);
					} 
				else if (report.xclient.window==savefile_figfiles)
					{
					state.show_fig_files_only = report.xclient.data.l[2];
					fill_in_file(savelfile_text,saverfile_text,state.show_fig_files_only);
					if (state.show_fig_files_only) 
						stk_choice_on(savefile_figfiles,0);
					else
						stk_choice_off(savefile_figfiles,0);
					}; 
				break;
				 
			/* spline shape factor slider  */ 
			case STK_DIALOG_SLID:
				if (report.xclient.window==spline_slider)
					{
					sprintf(a,"%.2f",(double)((report.xclient.data.l[2])/50.0)-1.0);
					stk_set_text_entry(spline_entry, a);
					};
				break;
				 
			/* an item in a text list has been selected  */ 	
			case STK_DIALOG_TEXT_LIST_SELECTION:
				if (report.xclient.window==font_size_text)
					{
					int val;

					v = (View *)report.xclient.data.l[2];

					stk_get_textlist_selection(font_size_text, a); 

					sscanf(a,"%d",&val); 
  					v->fontsize = val;  
					sprintf(a,"%d",val);

							stk_set_text_entry(font_entry, a); 
					}
				else if (report.xclient.window==font_typeface_text)
					{
					v = (View *)report.xclient.data.l[2];
					
					v->fontnum = stk_get_textlist_selection_num(font_typeface_text);
					v->fontnum = max(0,v->fontnum); 
					} 
				else if (report.xclient.window==lfile_text)
					{
					if (is_directory((char *)report.xclient.data.l[1]))
						{
						if (streq("../",(char *)report.xclient.data.l[1]))
							strip_end_dir(state.cwd);
						else
							strcat(state.cwd, (char *)report.xclient.data.l[1]);

						stk_unselect_textlist(lfile_text); 
						stk_unselect_textlist(rfile_text); 

						chdir(state.cwd);
						fill_in_file(lfile_text,rfile_text,state.show_fig_files_only);
						stk_set_text_entry(file_entry, state.cwd);
						}; 
					} 
				else if (report.xclient.window==rfile_text)
					{
					strcpy(a,state.cwd);
					if (strlen(a)==0)	
						strcat(a,"/"); 
						 
					if (a[strlen(a)-1]!='/')
						strcat(a,"/");

					strcat(a,(char *)report.xclient.data.l[1]);
					stk_set_text_entry(file_entry, a);
					}
				else if (report.xclient.window==savelfile_text)
					{
					if (is_directory((char *)report.xclient.data.l[1]))
						{
						if (streq("../",(char *)report.xclient.data.l[1]))
							strip_end_dir(state.cwd);
						else
							{
							strcat(state.cwd, (char *)report.xclient.data.l[1]);
							};
						stk_unselect_textlist(savelfile_text); 
						stk_unselect_textlist(saverfile_text); 

						chdir(state.cwd);
						fill_in_file(savelfile_text,saverfile_text,state.show_fig_files_only);
						stk_set_text_entry(savefile_entry, state.cwd);
						}; 
					} 
				else if (report.xclient.window==saverfile_text)
					{
					strcpy(a,state.cwd);
					if (strlen(a)==0)	
						strcat(a,"/"); 
						 
					if (a[strlen(a)-1]!='/')
						strcat(a,"/");

					strcat(a,(char *)report.xclient.data.l[1]);
					stk_set_text_entry(savefile_entry, a);
					}	 
				else if (report.xclient.window==insertlfile_text)
					{
					if (is_directory((char *)report.xclient.data.l[1]))
						{
						if (streq("../",(char *)report.xclient.data.l[1]))
							strip_end_dir(state.cwd);
						else
							{
							strcat(state.cwd, (char *)report.xclient.data.l[1]);
							};
						stk_unselect_textlist(insertlfile_text); 
						stk_unselect_textlist(insertrfile_text); 

						chdir(state.cwd);
						fill_in_file(insertlfile_text,insertrfile_text,state.show_fig_files_only);
						stk_set_text_entry(insertfile_entry, state.cwd);
						}; 
					} 
				else if (report.xclient.window==insertrfile_text)
					{
					strcpy(a,state.cwd);
					if (strlen(a)==0)	
						strcat(a,"/"); 
						 
					if (a[strlen(a)-1]!='/')
						strcat(a,"/");

					strcat(a,(char *)report.xclient.data.l[1]);
					stk_set_text_entry(insertfile_entry, a);
					}	  
				else if (report.xclient.window==exportlfile_text)
					{
					if (is_directory((char *)report.xclient.data.l[1]))
						{
						if (streq("../",(char *)report.xclient.data.l[1]))
							strip_end_dir(state.cwd);
						else
							{
							strcat(state.cwd, (char *)report.xclient.data.l[1]);
							};
						stk_unselect_textlist(exportlfile_text); 
						stk_unselect_textlist(exportrfile_text); 

						chdir(state.cwd);
						fill_in_file(exportlfile_text,exportrfile_text,FALSE);
						stk_set_text_entry(exportfile_entry, state.cwd);
						}; 
					} 
				else if (report.xclient.window==exportrfile_text)
					{
					strcpy(a,state.cwd);
					if (strlen(a)==0)	
						strcat(a,"/"); 
						 
					if (a[strlen(a)-1]!='/')
						strcat(a,"/");

					strcat(a,(char *)report.xclient.data.l[1]);
					stk_set_text_entry(exportfile_entry, a);
					}
				else if (report.xclient.window==exportformat_text)
					add_export_extension(stk_get_textlist_selection_num(exportformat_text));
				break;

			/* request to close a dialog passed to handle_menu.c  */  
			case STK_DIALOG_BUTTON_CLICKED:
				handle_dialog(report, (ulong)report.xclient.data.l[0]); 
				break;
			
			/* a popup menu has been cancelled  */ 
			case STK_MENU_CANCELLED:
				state.menu_view=NULL;
				break;

			/* clicked an icon  */  
			case STK_ICON_CHOSEN:
			 	switch (report.xclient.data.l[0])
					{
					case POINTERICON:
					case POLYLINEICON:
					case ELLIPSEICON:
					case ARCELLIPSEICON:
					case BOXELLIPSEICON: 
					case COMPOUNDICON:
					case POLYGONICON:
					case SPLINEICON:
					case NODEICON:
					case ARCICON: 
					case RECTANGLEICON:
					case TEXTICON:
						change_function(report);
						break;
					
					default:
						/* normal icon chosen  */  
						icon_chosen(report);	
						break;
					};
				break;

			/* click on icon with right mouse button  */  
			case STK_ICON_DOUBLECLICKED:
				switch (report.xclient.data.l[0])
					{
					case FILLSTYLEICON:
						l2 = where_in_list(wins, (ulong)report.xclient.data.l[1]);
						l2 = where_in_list(wins, WS(l2)->parent);
						 
						VIEW(l2)->fillstyle = NONE;
						stk_set_pixmap(FILLSTYLEICON, VIEW(l2)->view_icon_window->win, nofill); 
						break;

					case LINESTYLEICON:
						l2 = where_in_list(wins, (ulong)report.xclient.data.l[1]);
						l2 = where_in_list(wins, WS(l2)->parent);
						 
						VIEW(l2)->linestyle = SOLID;
						stk_swap_pixmap(LINESTYLEICON, VIEW(l2)->view_icon_window->win,
											 SOLIDICON, linestyle_menu);
						break;
						 
					case COLOURICON:
						l2 = where_in_list(wins, (ulong)report.xclient.data.l[1]);
						l2 = where_in_list(wins, WS(l2)->parent);
						 
						VIEW(l2)->colour = STARTOFCOLOURS;
						stk_swap_pixmap(COLOURICON, VIEW(l2)->view_icon_window->win,
											 STARTOFCOLOURS, colour_menu);
						
						break; 
						 
					case FILLCOLOURICON:
						l2 = where_in_list(wins, (ulong)report.xclient.data.l[1]);
						l2 = where_in_list(wins, WS(l2)->parent);
						 
						VIEW(l2)->fillcolour = FILLCWHITE;
						stk_swap_pixmap(FILLCOLOURICON, VIEW(l2)->view_icon_window->win,
											 FILLCWHITE, fillcolour_menu);
						
						break; 
						 
					case EYEICON:
						l2 = where_in_list(wins, (ulong)report.xclient.data.l[1]);

						VIEW(l2)->x_inches_offset = 0;
						VIEW(l2)->y_inches_offset = 0;
						REDRAW_ALL_WINDOW(VIEW(l2)->ruler_x_window);
						REDRAW_ALL_WINDOW(VIEW(l2)->ruler_y_window);
						redraw_view_window(VIEW(l2)); 
						
						break;

					}; 
				break;
			};
		break;

	default:
		break; 
	};
}
 
void 
event_loop()
{
	XEvent report;
	
	while (TRUE)
		{
		XNextEvent(display, &report);
		
		/* close down tooltip if outside one of our windows  */  
		if (report.type==LeaveNotify && 
			 (report.xcrossing.window==toolWindow.win || is_in_list(wins,report.xcrossing.window)))
			stk_unmap_tooltip();
		
		/* check if it's an STK window */
		/* if it is, we can ignore it */ 
		if (!stk_notify(&report))
			{	
			/* not in an STK window, so hide tooltip if pointer event  */  
			if (report.type == MotionNotify || report.type == ButtonPress
			    || report.type == ButtonRelease || report.type == EnterNotify)
				stk_unmap_tooltip();

			handle_event(report);
			};
		}; 

}

void 
close_down()
{
	List l;

	l = state.views;

	while (l!=NULL)
		{
		/* still checking to be done */  
		if (close_view(VIEW(l)))
			{ 
			quitting = TRUE; 
			return; 
			}; 
		l = state.views;
		};
	
	if (buffer!=NULL)
		kill_object(buffer);

	/* delete allocated strings if any */  
	stk_clear_textlist(exportformat_text); 
	stk_clear_textlist(font_typeface_text); 
	stk_clear_textlist(font_size_text); 
	stk_clear_textlist(lfile_text); 
	stk_clear_textlist(rfile_text); 
	stk_clear_textlist(savelfile_text); 
	stk_clear_textlist(saverfile_text); 
	stk_clear_textlist(insertlfile_text); 
	stk_clear_textlist(insertrfile_text); 
	stk_clear_textlist(exportlfile_text); 
	stk_clear_textlist(exportrfile_text); 
	 
	/* for some reason, this needs to be called before freelist is emptied */  
	stk_finish(); 
	 
	l=afonts;

	while (l!=NULL)
		{
		free(l->data);
		l=l->next;
		};

	delete_list(afonts);

	l=freelist; 
	
	while (l!=NULL)
		{
		free(l->data);
		l = l->next;
		};
	
	delete_list(freelist);
	delete_list(wins); 

	l=undostack;
	while (l!=NULL)
		{
		kill_undo(UNDO(l),FALSE);
		free(l->data);
		l=l->next;
		};

	l=redostack;
	while (l!=NULL)
		{
		kill_undo(UNDO(l),TRUE); 
		free(l->data);
		l=l->next;
		};
	delete_list(undostack);
	delete_list(redostack);
	 
	if (font!=NULL) 
		XFreeFont(display,font); 
	if (toolWindow.size_hints!=NULL) 
		XFree(toolWindow.size_hints);
	if (toolWindow.class_hints!=NULL) 
		XFree(toolWindow.class_hints);
	if (toolWindow.wm_hints!=NULL) 
		XFree(toolWindow.wm_hints);
	XCloseDisplay(display);
	exit(0); 
} 
