/* globals */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: globals.c,v $
 * Revision 1.3  2000/12/17 00:57:42  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.23  2000/03/08 22:04:42  moz
 * Compile fixes.
 *
 * Revision 1.22  2000/02/27 21:27:58  moz
 * Removed unused variables.
 *
 * Revision 1.21  2000/01/21 11:48:02  moz
 * Removed un-needed gcs.
 *
 * Revision 1.20  2000/01/21 11:22:01  moz
 * last_mouse_movement isn't used.
 *
 * Revision 1.19  1999/11/15 02:10:17  moz
 * Name change.
 *
 * Revision 1.18  1999/07/27 01:47:22  moz
 * Removed useless -title and -bgcolor options.
 *
 * Revision 1.17  1999/06/30 15:32:38  moz
 * Updated the view icons sizes.
 *
 * Revision 1.16  1999/05/23 00:27:37  moz
 * Pedantic changes.
 *
 * Revision 1.15  1999/05/22 02:55:06  moz
 * Added -background, -nocompoundoutlines, and -guidelines options.
 *
 * Revision 1.14  1999/05/19 17:10:36  moz
 * 1.0 Checkin.
 *
 * Revision 1.13  1999/05/05 12:28:45  moz
 * Print dialog.
 *
 * Revision 1.12  1999/05/04 22:31:15  moz
 * Snap to grid given shortcut [i].
 *
 * Revision 1.11  1999/05/03 06:21:14  moz
 * FIG files only for insert and save.
 *
 * Revision 1.10  1999/04/29 22:01:34  moz
 * Redo.
 *
 * Revision 1.9  1999/04/29 00:25:57  moz
 * Removed nodebox_icon.
 *
 * Revision 1.8  1999/04/27 21:14:09  moz
 * Correction to cmdline coredump with -notooltips.
 *
 * Revision 1.7  1999/04/27 21:10:39  moz
 * Hide/show tooltips added.
 *
 * Revision 1.6  1999/04/27 16:55:29  moz
 * Flip object added.
 *
 * Revision 1.5  1999/04/23 01:05:33  moz
 * Show FIG files only window.
 *
 * Revision 1.4  1999/04/22 16:16:30  moz
 * Due to xfig, must be arc *circle*.
 *
 * Revision 1.3  1999/04/04 01:49:33  moz
 * Shortcuts for Export and Print added.
 *
 * Revision 1.2  1999/04/03 21:13:06  moz
 * Show shortcuts on tooltips, export dialog windows.
 *
 * Revision 1.1  1999/03/30 00:04:51  moz
 * Initial revision
 *
 */    

#include "include/figurine.h" 
#include "include/stk.h" 
#include "include/icons.h" 
 
/* state variables  */  
State state;
List undostack = NULL; 
List redostack = NULL; 
int undolevels=10;
Boolean compound_outlines=FALSE;
Boolean highlight_objects=TRUE; 
Boolean guide_lines=FALSE;
Boolean tooltips = TRUE; 
/* screen pixels per inch  */  
double screen_ppi;
 
Atom winproto; 
/* for WM_DELETE_WINDOW  */   
Atom windelete; 
 
/* things to free() at close down  */   
List freelist=NULL; 

/* main initialisation  */ 
WindowStruct toolWindow;
XrmDatabase XresourceDatabase;
XrmDatabase XcommandLineDatabase;
Display *display;
int screen;
XFontStruct *font; 
XFontStruct *rulerfont; 
Boolean quitting=FALSE; 
 
/* dialog windows  */  
Window file_dialog;
Window lfile_text;
Window rfile_text;
Window file_figfiles; 
Window file_entry; 
Window file_ok;
Window file_cancel;
Window savefile_dialog;
Window savelfile_text;
Window saverfile_text;
Window savefile_figfiles; 
Window savefile_entry; 
Window savefile_ok;
Window savefile_cancel;
Window insertfile_dialog;
Window insertlfile_text;
Window insertrfile_text;
Window insertfile_figfiles; 
Window insertfile_entry; 
Window insertfile_ok;
Window insertfile_cancel;
Window exportfile_dialog;
Window exportlfile_text;
Window exportrfile_text;
Window exportformat_text;
Window exportfile_entry;
Window exportfile_ok;
Window exportfile_cancel;
Window printfile_dialog;
Window printfile_entry;
Window printfile_choice;
Window printfile_print;
Window printfile_cancel;
Window view_dialog;
Window view_gridx_entry;
Window view_gridy_entry;
Window view_ok;
Window view_apply; 
Window view_cancel;
Window view_mm;
Window view_inch;
Window view_units; 
Window view_guides;
Window view_compounds;
Window view_highlight; 
Window lw_dialog;
Window lw_entry;
Window lw_ok;
Window lw_apply;
Window lw_cancel;
Window roundbox_dialog;
Window roundbox_choice;
Window roundbox_entry;
Window roundbox_ok;
Window roundbox_apply;
Window roundbox_cancel;
Window polygon_dialog;
Window polygon_choice;
Window polygon_entry;
Window polygon_ok;
Window polygon_apply;
Window polygon_cancel;
Window spline_dialog;
Window spline_choice;
Window spline_slider;
Window spline_entry; 
Window spline_ok;
Window spline_apply;
Window spline_cancel;
Window font_dialog; 
Window font_typeface_text;
Window font_size_text;
Window font_entry; 
Window font_close;
Window arrow_dialog;
Window larrow_choice;
Window larrow_fillchoice;
Window larrow_type;
Window larrow_width;
Window larrow_height;
Window larrow_thickness;
Window rarrow_choice;
Window rarrow_fillchoice;
Window rarrow_type;
Window rarrow_width;
Window rarrow_height;
Window rarrow_thickness;
Window arrow_ok; 
Window arrow_apply; 
Window arrow_cancel; 

/* list of all documents  */  
List docs=NULL;
/* list of all non-STK windows */  
List wins = NULL; 
 
/* stores mouse position  */  
int mouse_x;
int mouse_y;
int last_mouse_x;
int last_mouse_y;
 
/* this is a numbering for objects  */  
unsigned long ob_ticket=0; 
 
/* GCs we need */  

GC rulergc; 
GC dashgc; /* dashed line in black  */ 
GC backgc;
GC fillgc; /* used for fill styles  */ 
GC blackxorgc; /* mode XOR for rubber banding  */ 
GC handlegc;
GC whitegc; 
GC ugc; /* this is the one used for normal drawing */


/* accepted options */  
XrmOptionDescRec XcommandLineTable[] =
{
	/* note the first two cannot be placed in a resource file as they are used  */
	/* before XOpenDisplay  */
	{"--version",  ".askversion", XrmoptionIsArg,  (caddr_t) NULL },
	{"-display",   ".display",    XrmoptionSepArg, (caddr_t) NULL },
	/* this is the geometry of the tool window */
	{"-geometry",  "*geometry",   XrmoptionSepArg, (caddr_t) NULL },
	{"-tlcolor", "*tlcolor", XrmoptionSepArg, (caddr_t) NULL },
	{"-background", "*background", XrmoptionSepArg, (caddr_t) NULL }, 
	{"-brcolor", "*brcolor", XrmoptionSepArg, (caddr_t) NULL },
	/* colour of object handles (default red)  */  
	{"-handlecolor", "*handlecolor", XrmoptionSepArg, (caddr_t) NULL },
	{"-font",     "*font",   XrmoptionSepArg, (caddr_t) NULL }, 
	{"-rulerfont",     "*rulerfont",   XrmoptionSepArg, (caddr_t) NULL }, 
	{"-screenppi", "*screenppi", XrmoptionSepArg, (caddr_t) NULL },
	{"-undolevels", "*undolevels", XrmoptionSepArg, (caddr_t) NULL },
	{"-notooltips", "*notooltips", XrmoptionIsArg, (caddr_t) NULL }, 
	{"-compoundoutlines", "*compoundoutlines", XrmoptionIsArg, (caddr_t) NULL }, 
	{"-nohighlightobjects", "*nohighlightobjects", XrmoptionIsArg, (caddr_t) NULL }, 
	{"-guidelines", "*guidelines", XrmoptionIsArg, (caddr_t) NULL }, 
};         
int XcommandLineTableEntries = (sizeof(XcommandLineTable)/sizeof(XrmOptionDescRec));


/* menus  */  
stkMenuBar main_menu =
	{
		{ "File", "Help", NULL, NULL, NULL, },
	};
stkMenu file_menu = 
	{
		{ "New ^N", "Open ... ^O", "-", "Quit ^Q",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL, }, 
		{ FILE_NEW,   FILE_OPEN, 0, FILE_QUIT,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, },

	};
stkMenu options_menu = 
	{
		{ "Contents ^H","Show tooltips",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL, }, 
		{ HELP_CONTENTS, HELP_TOOLTIPS,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, },

	};
Window hpw; 
stkMenu view_menu =
	{
		{ "New ^N", "Open ... ^O", "Insert ... ^I","-", "Save ^S", "Save As ... ^A", "Export ... ^E", "Print ... ^P", "Close ^D", "-", "Undo ^Z", "Redo ^R", "-", "New view ^M", "View Settings ... ^B", "-", "Quit ^Q", NULL,NULL,NULL,},
		{ FILE_NEW, FILE_OPEN, FILE_INSERT, 0, FILE_SAVE, FILE_SAVE_AS, FILE_EXPORT, FILE_PRINT, FILE_CLOSE, 0, VIEW_UNDO, VIEW_REDO, 0,NEW_VIEW, VIEW_SETTINGS, 0, FILE_QUIT, 0,0,0, },
	};
Window vmw;
stkMenu edit_menu = 
	{
		{ "Cut ^X", "Copy ^C", "Paste ^V", "Delete [Del]", "-", "Raise ^{", "Lower ^}", "Flip H ^(","Flip V ^)",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,},
		{ EDIT_CUT, EDIT_COPY, EDIT_PASTE, EDIT_DELETE, 0, EDIT_RAISE, EDIT_LOWER, FLIP_X,FLIP_Y,0,0,0,0,0,0,0,0,0,0,0,},
	};
Window emw;

/* icons on tool window  */  
stkIcon icons[] = 
	{
		{ pointer_xpm, (Pixmap)-1, POINTERICON, 0,0, 32, 32, TRUE, FALSE, "Edit objects [Space]" }, 
		{ compound_xpm, (Pixmap)-1, COMPOUNDICON, 0,0, 32, 32, TRUE, FALSE, "Compound object handling [c]" }, 
		{ polyline_xpm, (Pixmap)-1, POLYLINEICON, 0,0,  32, 32, TRUE, FALSE, "Unfilled polyline [l]" },
		{ radiuscircle_xpm, (Pixmap)-1, ELLIPSEICON, 0, 0, 32, 32, TRUE, FALSE, "Ellipse [e]" },
		{ boxcircle_xpm, (Pixmap)-1, BOXELLIPSEICON, 0, 0, 32, 32, TRUE, FALSE, "Ellipse by box [b]" }, 
		{ ellipsearc_xpm, (Pixmap)-1, ARCELLIPSEICON, 0, 0, 32, 32, TRUE, FALSE, "Arc section of circle [f]" }, 
		{ box_xpm,(Pixmap)-1, RECTANGLEICON, 0, 0, 32, 32, TRUE, FALSE,  "Rectangle [r]"},
		{ radiuspolygon_xpm, (Pixmap)-1, POLYGONICON, 0, 0, 32, 32, TRUE, FALSE, "Filled polyline [g]"  },
		{ xspline_xpm, (Pixmap)-1, SPLINEICON, 0, 0, 32, 32, TRUE, FALSE, "Spline curve [s]"},
		{ text_xpm, (Pixmap)-1, TEXTICON, 0,0,32, 32, TRUE, FALSE, "Text [t]" },
		{ node_xpm, (Pixmap)-1, NODEICON, 0,0, 32, 32, TRUE, FALSE, "Labelled node [n]"},
		{ arc_xpm, (Pixmap)-1, ARCICON, 0,0, 32, 32, TRUE, FALSE, "Labelled arc [a]"}, 
	};
uint icon_number = (int)(sizeof(icons)/sizeof(stkIcon));

/* icons on pop-up window  */  
stkIcon floaticons[] =
	{
		{ pointer_xpm, (Pixmap)-1, POINTERICON, 0,0, 32, 32, TRUE, FALSE, "Edit objects [Space]" }, 
		{ compound_xpm, (Pixmap)-1, COMPOUNDICON, 0,0, 32, 32, TRUE, FALSE, "Compound object handling [c]" }, 
		{ polyline_xpm, (Pixmap)-1, POLYLINEICON, 0,0,  32, 32, TRUE, FALSE, "Unfilled polyline [l]" },
		{ radiuscircle_xpm, (Pixmap)-1, ELLIPSEICON, 0, 0, 32, 32, TRUE, FALSE, "Ellipse [e]" },
		{ boxcircle_xpm, (Pixmap)-1, BOXELLIPSEICON, 0, 0, 32, 32, TRUE, FALSE, "Ellipse by box [b]" }, 
		{ ellipsearc_xpm, (Pixmap)-1, ARCELLIPSEICON, 0, 0, 32, 32, TRUE, FALSE, "Arc section of circle [f]" }, 
		{ box_xpm, (Pixmap)-1, RECTANGLEICON, 0, 0, 32, 32, TRUE, FALSE,  "Rectangle [r]" },
		{ radiuspolygon_xpm, (Pixmap)-1, POLYGONICON, 0, 0, 32, 32, TRUE, FALSE, "Filled polyline [g]"  },
		{ xspline_xpm, (Pixmap)-1, SPLINEICON, 0, 0, 32, 32, TRUE, FALSE, "Spline curve [s]"},
		{ text_xpm, (Pixmap)-1, TEXTICON, 0,0,32, 32, TRUE, FALSE, "Text [t]" },
		{ node_xpm, (Pixmap)-1, NODEICON, 0,0, 32, 32, TRUE, FALSE, "Labelled node [n]"},
		{ arc_xpm, (Pixmap)-1, ARCICON, 0,0, 32, 32, TRUE, FALSE, "Labelled arc [a]"}, 
	};
uint floaticon_number = (int)(sizeof(floaticons)/sizeof(stkIcon));	
 
/* other icons  */  
stkIcon eye_icon = 
	{ eye_xpm, (Pixmap)-1, EYEICON, 0, 0, 22, 22, FALSE, FALSE, "View menu" };
stkIcon grid_icon =
	{ grid_xpm, (Pixmap)-1, GRIDICON, 0, 1, 25, 25, TRUE, TRUE, "Snap to grid [i]" };
stkIcon showgrid_icon =
	{ showgrid_xpm, (Pixmap)-1, SHOWGRIDICON, 25, 1, 25, 25, TRUE, TRUE, "Display grid [d]" };
stkIcon zoomin_icon =
	{ zoomin_xpm, (Pixmap)-1, ZOOMINICON, 50, 1, 25, 25, FALSE, FALSE, "Zoom in [+]" };
stkIcon zoomout_icon =
	{ zoomout_xpm, (Pixmap)-1, ZOOMOUTICON, 75, 1, 25, 25, FALSE, FALSE, "Zoom out [-]" };
stkIcon linestyle_icon =
	{ solid_xpm, (Pixmap)-1, LINESTYLEICON, 100, 1, 25, 25, FALSE, FALSE, "Set line style [y]" };
stkIcon colour_icon =
	{ NULL, (Pixmap)-1, COLOURICON, 125, 1, 25, 25, FALSE, FALSE, "Set pen colour [p]" };
stkIcon fillstyle_icon =
	{ NULL, (Pixmap)-1, FILLSTYLEICON, 150, 1, 25, 25, FALSE, FALSE, "Set fill style [z]" };
stkIcon fillcolour_icon =
	{ NULL, (Pixmap)-1, FILLCOLOURICON, 175, 1, 25, 25, FALSE, FALSE, "Set fill colour [q]" };
stkIcon arrow_icon =
	{ arrow_xpm, (Pixmap)-1, ARROWICON, 0, 1, 25, 25, FALSE, FALSE, "Arrow settings [m]" };
stkIcon setpolygon_icon =
	{ setpolygon_xpm, (Pixmap)-1, SETPOLYGONICON, 0, 1, 25, 25, FALSE, FALSE, "Polygon settings [h]" };
stkIcon endstyle_icon =
	{ roundend_xpm, (Pixmap)-1, ENDSTYLEICON, 0, 1, 25, 25, FALSE, FALSE, "Line end style [x]" };
stkIcon joinstyle_icon =
	{ roundjoin_xpm, (Pixmap)-1, JOINSTYLEICON, 0, 1, 25, 25, FALSE, FALSE, "Line join style [j]" };
stkIcon font_icon =
	{ font_xpm, (Pixmap)-1, FONTICON, 0, 1, 25, 25, FALSE, FALSE, "Text font settings [u]" };
stkIcon linewidth_icon =
	{ linewidth_xpm, (Pixmap)-1, LINEWIDTHICON, 0, 1, 25, 25, FALSE, FALSE, "Set line width [w]" };
stkIcon setspline_icon =
	{ setspline_xpm, (Pixmap)-1, SETSPLINEICON, 0, 1, 25, 25, FALSE, FALSE, "Spline settings [o]" };
stkIcon roundbox_icon =
	{ roundbox_xpm, (Pixmap)-1, ROUNDBOXICON, 0, 1, 25, 25, FALSE, FALSE, "Set rounded corners [v]" };
stkIcon justification_icon =
	{ leftjust_xpm, (Pixmap)-1, JUSTIFICATIONICON, 0, 1, 25, 25, FALSE, FALSE, "Set text justification [k]" };
stkIcon setarcellipse_icon =
	{ closedarcellipse_xpm, (Pixmap)-1, SETARCELLIPSEICON, 0, 1, 25, 25, FALSE, FALSE, "Set open/closed [o]" };
	 
/* icon containers  */ 
stkIconPanel icon_panel;
stkIconMenu icon_float; 
Window float_menu; 

/* mini icon menus  */  
stkIcon linestyleicons[] =
	{
		{ solid_xpm, (Pixmap)-1, SOLIDICON, 0, 0, 25, 25, TRUE, FALSE, "Solid" },
		{ dashed_xpm, (Pixmap)-1, DASHEDICON, 0, 0, 25, 25, TRUE, FALSE, "Dashes" },
		{ dotted_xpm, (Pixmap)-1, DOTTEDICON, 0, 0, 25, 25, TRUE, FALSE, "Dots" },
		{ dash_dotted_xpm, (Pixmap)-1, DASHDOTTEDICON, 0, 0, 25, 25, TRUE, FALSE, "Dash dots" },
		{ dash_double_dotted_xpm, (Pixmap)-1, DASHDOUBLEDOTTEDICON, 0, 0, 25, 25, TRUE, FALSE, "Dash double dots" },
		{ dash_triple_dotted_xpm, (Pixmap)-1, DASHTRIPLEDOTTEDICON, 0, 0, 25, 25, TRUE, FALSE, "Dash triple dots" },
	};
uint linestyleicon_number = (int)(sizeof(linestyleicons)/sizeof(stkIcon));	
 
stkIconMenu linestyle_float;
Window linestyle_menu;

stkIcon justificationicons[] =
	{
		{ leftjust_xpm, (Pixmap)-1, LEFTJUSTICON, 0, 0, 25, 25, TRUE, FALSE, "Flush left" },
		{ centrejust_xpm, (Pixmap)-1, CENTREJUSTICON, 0, 0, 25, 25, TRUE, FALSE, "Centred" },
		{ rightjust_xpm, (Pixmap)-1, RIGHTJUSTICON, 0, 0, 25, 25, TRUE, FALSE, "Flush right" },
	};
uint justificationicon_number = (int)(sizeof(justificationicons)/sizeof(stkIcon));	
 
stkIconMenu justification_float;
Window justification_menu;
 
stkIcon endstyleicons[] =
	{
		{ roundend_xpm, (Pixmap)-1, ROUNDENDICON, 0, 0, 25, 25, TRUE, FALSE, "Round line end" },
		{ flatend_xpm, (Pixmap)-1, FLATENDICON, 0, 0, 25, 25, TRUE, FALSE, "Flat line end" },
		{ projectingend_xpm, (Pixmap)-1, PROJECTINGENDICON, 0, 0, 25, 25, TRUE, FALSE, "Projecting line end" },
	};
uint endstyleicon_number = (int)(sizeof(endstyleicons)/sizeof(stkIcon));	
 
stkIconMenu endstyle_float;
Window endstyle_menu;
 
stkIcon joinstyleicons[] =
	{
		{ roundjoin_xpm, (Pixmap)-1, ROUNDJOINICON, 0, 0, 25, 25, TRUE, FALSE, "Round join" },
		{ sharpjoin_xpm, (Pixmap)-1, SHARPJOINICON, 0, 0, 25, 25, TRUE, FALSE, "Sharp join" },
		{ beveljoin_xpm, (Pixmap)-1, BEVELJOINICON, 0, 0, 25, 25, TRUE, FALSE, "Bevelled join" },
	};
uint joinstyleicon_number = (int)(sizeof(joinstyleicons)/sizeof(stkIcon));	
 
stkIconMenu joinstyle_float;
Window joinstyle_menu;
 
stkIcon setarcellipseicons[] =
	{
		{ openarcellipse_xpm, (Pixmap)-1, OPENARCELLIPSEICON, 0, 0, 25, 25, TRUE, FALSE, "Open (no fill)" },
		{ closedarcellipse_xpm, (Pixmap)-1, CLOSEDARCELLIPSEICON, 0, 0, 25, 25, TRUE, FALSE, "Closed (filled)" },
	};
uint setarcellipseicon_number = (int)(sizeof(setarcellipseicons)/sizeof(stkIcon));	
 
stkIconMenu setarcellipse_float;
Window setarcellipse_menu;

/* for fill style menu  */  
char *filltags[] =
	{
		"Solid", 
		"Shade 1", "Shade 2", "Shade 3", "Shade 4", "Shade 5", "Shade 6", "Shade 7", "Shade 8", 
		"Shade 9", "Shade 10", "Shade 11", "Shade 12", "Shade 13", "Shade 14", "Shade 15", "Shade 16", "Shade 17", 
		"Shade 18", "Shade 19", "Black", "Left 30' lines", "Right 30' lines", "30' crosshatch", "Left 45' lines",
		"Right 45' lines", "45' crosshatch", "Bricks", "Vertical bricks", "Horizontal lines", "Vertical lines",
		"Crosshatch", "Right bricks", "Left bricks", "Left vertical bricks", "Right vertical bricks", 
		"Scales", "Small scales", "Circles", "Hexagons", "Octagons", "Tire treads", "Vertical tire treads",
	};

/* for colour menu  */  
VColour cols[] =
	{
		{ "Blue 4",0, "#000090",CBLUE4 },
		{ "Blue 3",0, "#0000b0",CBLUE3 },
		{ "Blue 2",0, "#0000d0",CBLUE2 },
		{ "Blue",0, "blue",CBLUE },
		{ "Green 4",0, "#009000",CGREEN4 },
		{ "Green 3",0, "#00b000",CGREEN3 },
		{ "Green 2",0, "#00d000",CGREEN2 },
		{ "Green", 0, "green",CGREEN },
		{ "Cyan 4",0, "#009090",CCYAN4 },
		{ "Cyan 3",0, "#00b0b0",CCYAN3 },
		{ "Cyan 2",0, "#00d0d0",CCYAN2 },
		{ "Cyan",0, "cyan",CCYAN },
		{ "Red 4",0, "#900000",CRED4 },
		{ "Red 3",0, "#b00000",CRED3 },
		{ "Red 2",0, "#d00000",CRED2 },
		{ "Red", 0, "red",CRED },
		{ "Magenta 4",0, "#900090",CMAGENTA4 },
		{ "Magenta 3",0, "#b000b0",CMAGENTA3 },
		{ "Magenta 2",0, "#d000d0",CMAGENTA2 },
		{ "Magenta", 0, "magenta",CMAGENTA },
		{ "Brown 4",0, "#803000",CBROWN4 },
		{ "Brown 3",0, "#a04000",CBROWN3 },
		{ "Brown 2",0, "#c06000",CBROWN2 },
		{ "Gold",0, "gold",CGOLD }, 
		{ "Pink 4",0, "#ff8080",CPINK4 },
		{ "Pink 3",0, "#ffa0a0",CPINK3 },
		{ "Pink 2",0, "#ffc0c0",CPINK2 },
		{ "Pink",0, "#ffe0e0",CPINK },
		{ "Black",0, "black",CBLACK },
		{ "White", 0, "white",CWHITE }, 
		{ "Yellow", 0, "yellow",CYELLOW },
		{ "Light Blue",0, "#87ceff",CLIGHTBLUE },
	};
int numcols = sizeof(cols)/sizeof(VColour);

/* for fill colour icon menu  */  
VColour fillcols[] =
	{
		{ "Blue 4",0, "#000090",FILLCBLUE4 },
		{ "Blue 3",0, "#0000b0",FILLCBLUE3 },
		{ "Blue 2",0, "#0000d0",FILLCBLUE2 },
		{ "Blue",0, "blue",FILLCBLUE },
		{ "Green 4",0, "#009000",FILLCGREEN4 },
		{ "Green 3",0, "#00b000",FILLCGREEN3 },
		{ "Green 2",0, "#00d000",FILLCGREEN2 },
		{ "Green", 0, "green",FILLCGREEN },
		{ "Cyan 4",0, "#009090",FILLCCYAN4 },
		{ "Cyan 3",0, "#00b0b0",FILLCCYAN3 },
		{ "Cyan 2",0, "#00d0d0",FILLCCYAN2 },
		{ "Cyan",0, "cyan",FILLCCYAN },
		{ "Red 4",0, "#900000",FILLCRED4 },
		{ "Red 3",0, "#b00000",FILLCRED3 },
		{ "Red 2",0, "#d00000",FILLCRED2 },
		{ "Red", 0, "red",FILLCRED },
		{ "Magenta 4",0, "#900090",FILLCMAGENTA4 },
		{ "Magenta 3",0, "#b000b0",FILLCMAGENTA3 },
		{ "Magenta 2",0, "#d000d0",FILLCMAGENTA2 },
		{ "Magenta", 0, "magenta",FILLCMAGENTA },
		{ "Brown 4",0, "#803000",FILLCBROWN4 },
		{ "Brown 3",0, "#a04000",FILLCBROWN3 },
		{ "Brown 2",0, "#c06000",FILLCBROWN2 },
		{ "Gold",0, "gold",FILLCGOLD }, 
		{ "Pink 4",0, "#ff8080",FILLCPINK4 },
		{ "Pink 3",0, "#ffa0a0",FILLCPINK3 },
		{ "Pink 2",0, "#ffc0c0",FILLCPINK2 },
		{ "Pink",0, "#ffe0e0",FILLCPINK },
		{ "Black",0, "black",FILLCBLACK },
		{ "White", 0, "white",FILLCWHITE }, 
		{ "Yellow", 0, "yellow",FILLCYELLOW },
		{ "Light Blue",0, "#87ceff",FILLCLIGHTBLUE },
	};
int fillnumcols = sizeof(fillcols)/sizeof(VColour);

/* pixmaps for fill style menu  */  
Pixmap fills[NUM_FILLSTYLES];
Pixmap bfills[NUM_FILLSTYLES]; /* of depth one  */  
Pixmap nofill; 

/* filled in by init.c  */ 
stkIcon *fillstyleicons;
uint fillstyleicon_number = NUM_FILLSTYLES; 
stkIconMenu fillstyle_float;
Window fillstyle_menu;
Window colour_menu; 
Window fillcolour_menu; 
List afonts; /* VFont list of loaded fonts for text drawing */  

/* fonts aliases */  
/* if the fonts on the left hand side aren't on your
	system, replace them with suitable values */  
char *fontnames[40][2] = 
	{
		{"-adobe-times-medium-r-normal-", "Times Roman" },
		{"-adobe-times-medium-i-normal-", "Times Italic" },
		{"-adobe-times-bold-r-normal-", "Times Bold" },
		{"-adobe-times-bold-i-normal-", "Times Bold Italic" },
		{"-schumacher-clean-medium-r-normal-", "Avant Garde Book" },
		{"-schumacher-clean-medium-i-normal-", "Avant Garde Book Oblique" },
		{"-schumacher-clean-bold-r-normal-", "Avant Garde Demi" }, 
		/* bold italic seems not available anywhere, use medium-i  */ 
		{"-schumacher-clean-medium-i-normal-", "Avant Garde Demi Oblique" },
		{"-adobe-times-medium-r-normal-", "Bookman Light" },
		{"-adobe-times-medium-i-normal-", "Bookman Light Italic" },
		{"-adobe-times-bold-r-normal-", "Bookman Demi" },
		{"-adobe-times-bold-i-normal-", "Bookman Demi Italic" },
		{"-adobe-courier-medium-r-normal-", "Courier" },
		{"-adobe-courier-medium-o-normal-", "Courier Oblique" },
		{"-adobe-courier-bold-r-normal-", "Courier Bold" },
		{"-adobe-courier-bold-o-normal-", "Courier Bold Oblique" },
		{"-adobe-helvetica-medium-r-normal-", "Helvetica" },
		{"-adobe-helvetica-medium-o-normal-", "Helvetica Oblique" },
		{"-adobe-helvetica-bold-r-normal-", "Helvetica Bold" },
		{"-adobe-helvetica-bold-o-normal-", "Helvetica Bold Oblique" },
		{"-adobe-helvetica-medium-r-normal-", "Helvetica Narrow" },
		{"-adobe-helvetica-medium-o-normal-", "Helvetica Narrow Oblique" },
		{"-adobe-helvetica-bold-r-normal-", "Helvetica Narrow Bold" },
		{"-adobe-helvetica-bold-o-normal-", "Helvetica Narrow Bold Oblique" },
		{"-adobe-new century schoolbook-medium-r-normal-", "New Century Schoolbook Roman" },
		{"-adobe-new century schoolbook-medium-i-normal-", "New Century Schoolbook Italic" },
		{"-adobe-new century schoolbook-bold-r-normal-", "New Century Schoolbook Bold" },
		{"-adobe-new century schoolbook-bold-i-normal-", "New Century Schoolbook Bold Italic" },
		{"-*-lucidabright-medium-r-normal-", "Palatino Roman" },
		{"-*-lucidabright-medium-i-normal-", "Palatino Italic" },
		{"-*-lucidabright-demibold-r-normal-", "Palatino Bold" },
		{"-*-lucidabright-demibold-i-normal-", "Palation Bold Italic" },
		{"-*-symbol-medium-r-normal-", "Symbol (Greek)" },
		{"-*-itc zapf chancery-medium-i-normal-", "Zapf Chancery Medium Italic" },
		{"-*-itc zapf dingbats-*-*-*-", "Dingbats" },
		{"-adobe-times-medium-r-normal-", "Latex Roman" },
		{"-adobe-times-medium-i-normal-", "Latex Italic" },
		{"-adobe-times-bold-r-normal-", "Latex Bold" },
		{"-adobe-helvetica-medium-r-normal-", "Latex Sans Serif" },
		{"-adobe-courier-medium-r-normal-", "Latex Typewriter" },
	};
int numfontnames= 40;

/* paper sizes and fig2dev names  */  
Papersize sizes[14] =
	{
		{ "Letter", "Letter", 8.5, 11.0 },
		{ "Legal", "Legal", 8.5, 14.0 },
		{ "Tabloid", "Tabloid", 11.0, 17.0 },
		{ "ANSI A", "A", 8.5, 11.0 },
		{ "ANSI B", "B", 11.0, 17.0 },
		{ "ANSI C", "C", 17.0, 22.0 },
		{ "ANSI D", "D", 22.0, 34.0 },
		{ "ANSI E", "E", 34.0, 34.0 },
		{ "ISO A4", "A4", 8.2677, 11.6929 },
		{ "ISO A3", "A3", 11.6929, 16.5354 },
		{ "ISO A2", "A2", 16.5354, 23.3858 },
		{ "ISO A1", "A1", 23.3858, 33.1102 },
		{ "ISO A0", "A0", 33.1102, 46.8110 },
	 	{ "JIS B5", "B5", 7.1654, 10.1181 },
	};
