#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <fam.h>
#include <errno.h>
#include "config.h"
#include "fileschanged.h"
#include "opts.h"
#include "node.h"
#include "list.h"
#include "monitor.h"
#include "filelist.h"
#include "wl.h"
extern struct arguments_t arguments;
struct fileschanged_appstate_t app;


int fileschanged_main(FAMConnection *c, void *list)
{
	monitor_begin(c, list);
	//list_show(list);
	while (1)
	{
		monitor_handle_events(c, list, 0, -1);
		if ((arguments.fileschanged.filechangetimeout > 0) && (arguments.fileschanged.showchanged))
		{
			wl_show_changed_files();
		}
		if (app.exit_gracefully_flag)
			break;
	}
	
	return 0;
}
void fileschanged_cleanup()
{
	monitor_stop(&app.c, app.list_of_files_to_monitor);
	monitor_close(&app.c);
	list_free(app.list_of_files_to_monitor);
	wl_destroy();
	return;
}
void sigHandler( int sig)
{
	if (( sig == SIGINT ) || (sig == SIGPIPE))
		app.exit_gracefully_flag = 1;
	else
		signal(sig, SIG_IGN);
}
int main(int argc, char **argv)
{
	int retval;

	parse_opts(argc, argv, &arguments);
	retval = monitor_open(&app.c);
	if (retval != 0)
	{
		fprintf(stderr,"Error: %s\n",FamErrlist[FAMErrno]);
		exit(1);
	}

	list_init(&app.list_of_files_to_monitor);
	wl_init();

	//either from file, stdin, or from command line.
	filelist_populate(app.list_of_files_to_monitor);

	setlinebuf(stdout);

	fileschanged_main(&app.c, app.list_of_files_to_monitor);
	//gets here by SIGINT or SIGPIPE

	fileschanged_cleanup();

	exit(0);
}

