/*
 * FISG - Output Modules
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2003-2004 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#include "out_formats.h"
#include "out_xhtmlgen.h"

/*
 * Functions
 */
int	output_xhtml(FILE *, t_stats *, t_fisgconfig *);
int	output_xhtmln(FILE *, t_stats *, t_fisgconfig *);
int	output_xhtmls(FILE *, t_stats *, t_fisgconfig *);


/*
 * List of output formats
 */
const t_outformat	outputFormats[] = {
	{ "xhtml",	"Old XHTML/CSS output",
		output_xhtml_init,
		output_xhtml },

	{ "xhtmln",	"Pure (new) XHTML/CSS output",
		output_xhtml_init,
		output_xhtmln },

	{ "xhtmls",	"XHTML/CSS output with table borders",
		output_xhtml_init,
		output_xhtmls },
};

const int	nOutputFormats = (sizeof(outputFormats) / sizeof(t_outformat));
