/*
 * Very simple configuration file parsing functions
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2004 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _TH_CONFIG_H
#define _TH_CONFIG_H

#include "th_util.h"


/*
 * Type definations
 */
enum ITEM_TYPE {
	ITEM_BLOCK = 1,
	ITEM_STRING,
	ITEM_INT,
	ITEM_UINT,
	ITEM_BOOL
};


typedef struct tconfignode {
	char	*itemName;	/* Config item name */
	int	itemType;	/* Type of the item */
	void	*itemData;	/* Data / value */

	BOOL	(*itemValidate)(struct tconfignode *);

	struct tconfignode *pNext, *pPrev;
} t_config_item;


typedef struct {
	t_config_item	*pItems;
} t_config;


/*
 * Functions
 */
t_config * th_config_new(void);
int	th_config_read(char *, t_config *);
void	th_config_free(t_config *);

int th_config_add_int(t_config *cfg, char *itemName, BOOL (*itemValidate)(t_config_item *), int *itemData, int itemDef);
int th_config_add_uint(t_config *cfg, char *itemName, BOOL (*itemValidate)(t_config_item *), t_uint *itemData, t_uint itemDef);
int th_config_add_str(t_config *cfg, char *itemName, BOOL (*itemValidate)(t_config_item *), char **itemData, char *itemDef);
int th_config_add_bool(t_config *cfg, char *itemName, BOOL (*itemValidate)(t_config_item *), BOOL *itemData, BOOL itemDef);

#endif /* _TH_CONFIG_H */
