//
// "$Id: Fl_CRW_Image.H,v 1.3 2003/01/12 22:58:43 easysw Exp $"
//
// Raw camera image header file for flphoto.
//
// Copyright 2002 by Michael Sweet.
//
// Original code copyright 1997-2002 by Dave Coffin <dcoffin@shore.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

#ifndef Fl_CRW_Image_H
#define Fl_CRW_Image_H
#  include <stdio.h>
#  include <FL/Fl_Image.H>

typedef unsigned short ushort;

class FL_EXPORT Fl_CRW_Image : public Fl_RGB_Image
{
  struct decode
  {
    decode	*branch[2];
    int		leaf;
  };

  typedef ushort ushort4[4];

  enum camera
  {
    CAMERA_A50,
    CAMERA_A5,
    CAMERA_D30,
    CAMERA_EOS1D,
    CAMERA_G1,
    CAMERA_G2,
    CAMERA_NIKON_D1X,
    CAMERA_NIKON_E5700,
    CAMERA_OLYMPUS,
    CAMERA_PRO70,
    CAMERA_PRO90,
    CAMERA_PS600
  };

  unsigned long	bitbuf;
  int		vbits;

  short		order;
  camera	type;
  int		trim;
  int		colors;
  int		black;
  int		canon;
  int		rgb_max;
  int		raw_height;
  int		raw_width;	/* Including black borders */
  int		nef_data_offset;
  unsigned	filters;
  char		name[64];
  ushort4	*image;
  float		gamma_val;
  float		bright;
  float		red_scale;
  float		blue_scale;
  float		rgb_mul[3];
  float		coeff[3][4];
  decode	first_decode[32];
  decode	second_decode[512];


  void		a50_read_crw(FILE *ifp);
  void		a5_read_crw(FILE *ifp);
  void		d30_read_crw(FILE *ifp);
  void		decompress(FILE *ifp, ushort *outbuf, int count);
  void		dillon_interpolate();
  void		eos1d_read_crw(FILE *ifp);
  ushort	fget2(FILE *f);
  int		fget4(FILE *f);
  void		first_interpolate();
  void		g1_read_crw(FILE *ifp);
  void		g2_read_crw(FILE *ifp);
  unsigned long	getbits(FILE *ifp, int nbits);
  void		get_rgb(float rgb[4], ushort image[4]);
  void		init_tables(unsigned table);
  void		load_image(FILE *fp);
  void		make_coeff();
  void		make_decoder(struct decode *dest, const uchar *source, int level);
  void		nikon_d1x_read_crw(FILE *ifp);
  void		nikon_e5700_read_crw(FILE *ifp);
  void		olympus_read_crw(FILE *ifp);
  int		open_and_id(FILE *ifp);
  void		parse(FILE *ifp, int offset, int length);
  void		parse_tiff(FILE *ifp);
  void		pro70_read_crw(FILE *ifp);
  void		pro90_read_crw(FILE *ifp);
  void		ps600_read_crw(FILE *ifp);
  void		read_crw(FILE *ifp);
  void		second_interpolate();
  void		subtract_black();

  public:

  Fl_CRW_Image(const char* filename);
  Fl_CRW_Image(FILE *fp);

  static Fl_Image *check(const char *name, uchar *header, int headerlen);
};

#endif

//
// End of "$Id: Fl_CRW_Image.H,v 1.3 2003/01/12 22:58:43 easysw Exp $".
//
