//
// "$Id: Fl_Print_Dialog2.cxx,v 1.31 2003/09/07 11:10:52 easysw Exp $"
//
// Print dialog methods for flphoto.
//
// Copyright 2002-2003 by Michael Sweet.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Contents:
//
//   Fl_Print_Dialog::load_prefs()      - Load preferences for the current printer.
//   Fl_Print_Dialog::load_printers()   - Load the list of available printers.
//   Fl_Print_Dialog::print_cb()        - Do the print.
//   Fl_Print_Dialog::printer_cb()      - Update the dialog based on the current printer.
//   Fl_Print_Dialog::save_prefs()      - Save the current settings in the preferences.
//   Fl_Print_Dialog::format()          - Set the print format.
//   Fl_Print_Dialog::format()          - Get the print format.
//   Fl_Print_Dialog::imageable_area()  - Get the imageable area for the page.
//   Fl_Print_Dialog::mat_color_cb()    - Change the mat color...
//   Fl_Print_Dialog::mat_type_cb()     - Change the mat type...
//   Fl_Print_Dialog::matimage()        - Generate the mat image...
//   Fl_Print_Dialog::matting()         - Get matting values...
//   Fl_Print_Dialog::media()           - Set the output media.
//   Fl_Print_Dialog::media_cb()        - Enable/disable custom media sizes.
//   Fl_Print_Dialog::paper_dimension() - Get the dimensions of the page.
//   Fl_Print_Dialog::print_file()      - Print the named file.
//   Fl_Print_Dialog::printer()         - Set the output printer.
//   Fl_Print_Dialog::progress_show()   - Show the progress meter...
//   Fl_Print_Dialog::which()           - Set which images to print.
//   Fl_Print_Dialog::which()           - Get which images to print.
//

#include "flphoto.h"
#include <FL/fl_ask.H>
#include <FL/Fl_Color_Chooser.H>
#include <stdio.h>
#include <stdlib.h>
#include "flstring.h"
#include <unistd.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifdef HAVE_LIBCUPS
#  include <cups/cups.h>
#endif // HAVE_LIBCUPS


//
// Unit conversion factors to points...
//

static float	units[] =
		{
		  72.0 / 2.54,			// cm
		  72.0,				// in
		  72.0 / 25.4,			// mm
		  1.0				// pt
		};
static uchar	standard_pattern[64 * 64] =
		{
		  212,184,182,209,197,196,209,192,202,223,195,168,200,214,173,190,
		  208,183,204,219,193,192,215,216,205,205,180,180,206,195,172,200,
		  180,175,198,177,177,202,187,170,165,159,165,203,203,163,165,204,
		  188,168,195,186,170,192,206,200,200,199,185,183,204,209,180,187,
		  203,169,177,193,172,178,185,170,175,210,203,171,182,197,174,176,
		  194,180,194,198,176,181,198,204,206,206,186,178,195,196,182,184,
		  165,180,207,183,177,211,205,195,200,185,167,199,208,181,182,204,
		  183,176,198,191,177,185,187,174,185,183,171,167,187,196,175,192,
		  219,186,190,203,175,185,204,193,178,201,205,178,191,203,185,188,
		  200,181,195,196,173,179,192,184,179,184,186,186,188,189,195,200,
		  172,184,206,196,185,202,195,188,210,207,180,203,215,199,205,217,
		  188,186,215,203,191,202,209,194,207,215,208,194,202,197,173,203,
		  197,192,201,215,191,190,209,203,194,209,216,196,204,213,196,196,
		  198,190,208,206,183,185,201,204,196,194,196,199,197,196,206,209,
		  194,195,192,178,190,203,183,172,196,201,176,183,188,177,188,208,
		  183,170,198,195,172,181,195,188,192,198,202,202,207,191,174,191,
		  161,161,181,198,183,177,193,178,171,190,196,192,194,187,180,190,
		  176,166,194,191,169,174,185,194,197,191,182,184,185,181,196,195,
		  181,202,198,168,185,213,195,178,194,195,179,183,182,171,185,202,
		  187,169,189,195,171,172,180,176,176,169,164,187,202,177,168,174,
		  194,177,180,194,186,184,207,188,174,188,178,181,201,196,188,207,
		  200,181,200,202,183,190,193,185,187,197,193,190,186,182,201,206,
		  186,202,215,185,184,210,201,188,202,201,188,204,206,189,201,218,
		  206,193,206,209,193,197,201,198,205,197,174,194,216,197,196,205,
		  210,196,193,201,191,187,211,206,190,201,192,186,198,197,191,201,
		  205,197,200,197,183,192,201,196,188,195,200,203,193,180,187,184,
		  180,189,195,177,175,189,181,180,200,196,174,193,195,173,179,191,
		  183,183,202,197,183,196,196,188,206,211,182,177,204,206,198,208,
		  191,176,177,195,180,173,189,187,178,188,188,179,188,184,171,173,
		  179,180,183,181,170,177,182,184,190,180,181,196,188,174,180,166,
		  172,198,194,175,178,194,183,180,203,197,170,186,191,174,184,186,
		  167,172,195,183,172,193,191,167,182,198,185,172,189,187,170,183,
		  212,189,169,197,192,171,183,187,171,183,199,182,190,204,193,184,
		  191,196,203,203,192,195,196,186,199,200,188,201,200,192,209,191,
		  180,212,206,185,193,208,187,181,213,214,194,205,207,188,199,216,
		  195,187,212,198,179,198,206,182,188,207,194,189,211,209,191,204,
		  223,212,183,201,214,195,202,213,188,185,210,194,185,200,203,200,
		  197,195,201,204,196,190,197,193,186,193,184,197,205,188,212,197,
		  165,201,202,177,186,204,179,159,187,192,186,202,202,178,181,205,
		  194,184,209,195,171,185,203,194,197,206,183,179,207,207,196,204,
		  204,195,180,189,192,191,197,199,191,189,196,189,188,184,182,194,
		  188,174,184,190,187,182,184,193,185,183,173,188,194,170,203,207,
		  166,197,207,176,182,207,198,172,182,184,163,185,206,184,178,192,
		  177,171,198,198,176,181,190,181,187,201,176,173,192,176,163,177,
		  211,195,185,201,187,187,201,190,180,194,197,189,198,193,187,205,
		  200,178,187,197,191,198,197,197,206,198,183,199,202,180,204,223,
		  187,197,212,183,187,211,217,197,203,213,179,185,213,193,187,209,
		  192,183,200,205,188,192,201,187,195,208,188,185,206,189,164,178,
		  194,188,183,201,193,183,200,194,176,189,188,181,192,187,182,197,
		  202,181,188,199,178,180,190,188,201,194,181,200,199,180,181,191,
		  180,189,201,174,168,188,195,186,195,207,180,175,201,188,179,205,
		  195,187,196,189,176,181,189,182,188,195,177,175,211,204,173,176,
		  183,177,175,190,187,173,193,197,183,198,192,177,190,188,177,187,
		  201,186,193,206,187,181,189,188,197,189,175,192,190,180,185,181,
		  165,182,196,182,173,178,176,180,194,194,182,177,197,192,179,200,
		  189,173,191,185,175,183,185,174,179,190,178,176,203,197,173,186,
		  210,196,188,202,203,183,191,199,191,203,204,182,181,189,188,193,
		  202,182,188,208,193,192,204,198,201,197,180,200,206,198,212,219,
		  196,201,208,196,200,208,185,180,202,202,193,195,204,193,184,209,
		  213,196,206,200,186,200,210,199,199,209,196,189,208,209,195,212,
		  199,180,182,200,201,191,186,178,186,194,194,189,183,177,175,181,
		  192,180,179,196,178,171,192,186,190,190,171,185,197,179,176,191,
		  185,190,204,184,179,197,183,169,194,195,176,182,193,180,168,188,
		  200,196,206,198,178,193,205,187,193,197,179,182,197,196,177,192,
		  199,175,173,192,186,191,200,176,186,204,193,202,204,187,183,190,
		  189,185,192,201,182,176,189,177,179,197,183,183,197,188,184,193,
		  182,175,201,190,171,190,188,170,193,201,177,181,193,186,168,176,
		  180,176,195,193,167,184,199,174,190,198,170,178,195,183,161,177,
		  220,203,186,201,194,195,208,192,193,214,202,204,207,198,201,206,
		  200,190,204,213,193,195,213,200,192,209,206,200,209,200,201,215,
		  211,198,213,207,190,215,208,182,202,210,188,194,211,206,188,194,
		  202,196,208,207,176,189,211,182,194,217,183,180,215,203,182,194,
		  193,191,191,191,184,191,194,184,182,188,183,190,191,181,190,193,
		  195,190,189,190,182,187,201,199,191,189,189,196,198,183,183,181,
		  184,193,215,208,183,199,193,179,197,203,175,177,195,194,187,195,
		  200,191,204,206,178,179,198,180,184,207,180,177,218,199,176,190,
		  182,175,192,187,170,190,197,185,182,186,181,186,186,174,187,191,
		  187,188,195,182,177,188,181,179,187,177,174,191,190,182,200,183,
		  157,174,202,201,180,183,174,168,189,204,179,178,195,181,166,174,
		  181,173,195,200,178,186,190,172,184,200,177,177,210,188,166,190,
		  205,190,198,205,188,188,200,202,196,202,203,201,197,185,189,193,
		  193,194,210,196,181,200,199,193,204,198,192,196,187,187,214,212,
		  172,172,198,203,196,203,196,181,196,209,185,190,213,197,179,189,
		  198,186,202,207,182,202,217,191,198,210,181,184,217,194,173,203,
		  195,182,187,192,182,175,176,190,195,191,193,198,190,176,175,179,
		  178,181,200,195,171,182,190,183,186,184,192,200,178,174,200,211,
		  176,167,197,199,187,199,197,180,196,208,178,180,208,194,184,198,
		  192,178,191,195,174,182,195,184,190,200,170,174,211,188,165,189,
		  204,185,188,198,191,189,188,189,196,192,188,197,201,188,182,195,
		  187,178,199,206,182,183,194,190,185,180,186,201,190,171,193,209,
		  183,172,201,195,173,196,194,166,187,206,179,182,205,188,175,197,
		  188,174,195,193,175,183,185,168,186,206,179,181,210,193,168,185,
		  218,200,196,207,197,188,195,191,185,193,186,191,212,210,200,211,
		  210,190,199,206,193,196,199,201,199,191,183,197,210,194,203,215,
		  198,186,202,192,168,200,208,170,188,211,192,194,206,183,177,211,
		  205,184,209,213,190,202,212,188,192,213,192,189,216,207,174,184,
		  191,180,178,195,188,170,178,180,172,185,185,177,190,182,181,183,
		  181,174,186,185,175,184,174,175,184,181,176,184,188,177,182,196,
		  179,183,210,197,161,190,208,171,181,204,188,189,202,175,166,195,
		  196,178,190,194,179,185,203,189,181,194,176,173,198,199,168,170,
		  192,185,185,199,205,190,192,203,198,199,198,191,196,187,191,197,
		  188,176,195,193,180,203,201,193,205,191,177,192,188,176,174,196,
		  179,173,216,215,180,199,214,174,178,197,179,186,215,187,173,188,
		  181,174,188,188,174,174,185,182,186,199,180,180,199,199,176,180,
		  211,190,189,194,204,204,190,199,207,199,193,194,195,187,191,210,
		  206,192,207,195,179,198,204,200,213,193,171,195,204,203,195,214,
		  208,180,206,212,182,199,215,176,181,205,182,186,220,199,183,203,
		  196,191,208,213,199,196,201,194,199,213,186,187,214,211,196,205,
		  206,183,181,184,183,199,185,178,184,180,182,195,190,174,174,188,
		  179,179,207,199,175,176,180,175,188,188,171,182,190,183,179,190,
		  185,170,189,198,170,185,215,177,186,208,175,174,205,193,172,196,
		  192,182,195,191,187,196,200,184,179,198,175,166,194,188,176,187,
		  204,200,196,194,179,187,185,190,189,176,178,200,209,190,192,198,
		  182,183,206,212,201,195,199,191,193,205,196,192,200,183,179,198,
		  187,172,189,204,174,184,219,191,192,213,177,173,206,198,172,190,
		  187,171,192,186,175,188,199,182,178,204,190,167,184,183,170,170,
		  204,200,199,193,190,184,173,188,197,178,167,189,206,188,201,201,
		  177,169,187,196,190,201,211,203,195,202,197,196,215,202,188,214,
		  208,181,201,218,189,187,210,191,188,216,193,186,215,205,182,202,
		  208,191,208,201,180,193,219,200,190,218,215,196,207,206,189,187,
		  188,191,204,194,202,211,198,192,207,208,185,192,195,175,199,210,
		  185,165,189,190,169,180,187,177,170,170,162,176,199,185,165,191,
		  200,165,180,203,179,176,193,174,176,200,179,173,206,199,172,191,
		  190,179,202,194,163,176,209,192,170,194,198,193,209,207,180,175,
		  195,199,216,200,199,212,199,183,189,198,192,207,200,167,188,224,
		  203,177,206,205,185,200,205,199,200,204,183,187,210,199,167,186,
		  215,179,174,201,184,182,206,185,186,195,166,157,198,199,166,194,
		  189,165,196,200,165,172,206,191,165,170,161,173,195,188,177,168,
		  180,175,198,177,177,202,187,170,165,159,165,203,203,163,165,204,
		  188,168,195,186,170,192,206,200,200,199,185,183,204,209,180,187,
		  212,184,182,209,197,196,209,192,202,223,195,168,200,214,173,190,
		  208,183,204,219,193,192,215,216,205,205,180,180,206,195,172,200,
		  165,180,207,183,177,211,205,195,200,185,167,199,208,181,182,204,
		  183,176,198,191,177,185,187,174,185,183,171,167,187,196,175,192,
		  203,169,177,193,172,178,185,170,175,210,203,171,182,197,174,176,
		  194,180,194,198,176,181,198,204,206,206,186,178,195,196,182,184,
		  172,184,206,196,185,202,195,188,210,207,180,203,215,199,205,217,
		  188,186,215,203,191,202,209,194,207,215,208,194,202,197,173,203,
		  219,186,190,203,175,185,204,193,178,201,205,178,191,203,185,188,
		  200,181,195,196,173,179,192,184,179,184,186,186,188,189,195,200,
		  194,195,192,178,190,203,183,172,196,201,176,183,188,177,188,208,
		  183,170,198,195,172,181,195,188,192,198,202,202,207,191,174,191,
		  197,192,201,215,191,190,209,203,194,209,216,196,204,213,196,196,
		  198,190,208,206,183,185,201,204,196,194,196,199,197,196,206,209,
		  181,202,198,168,185,213,195,178,194,195,179,183,182,171,185,202,
		  187,169,189,195,171,172,180,176,176,169,164,187,202,177,168,174,
		  161,161,181,198,183,177,193,178,171,190,196,192,194,187,180,190,
		  176,166,194,191,169,174,185,194,197,191,182,184,185,181,196,195,
		  186,202,215,185,184,210,201,188,202,201,188,204,206,189,201,218,
		  206,193,206,209,193,197,201,198,205,197,174,194,216,197,196,205,
		  194,177,180,194,186,184,207,188,174,188,178,181,201,196,188,207,
		  200,181,200,202,183,190,193,185,187,197,193,190,186,182,201,206,
		  180,189,195,177,175,189,181,180,200,196,174,193,195,173,179,191,
		  183,183,202,197,183,196,196,188,206,211,182,177,204,206,198,208,
		  210,196,193,201,191,187,211,206,190,201,192,186,198,197,191,201,
		  205,197,200,197,183,192,201,196,188,195,200,203,193,180,187,184,
		  172,198,194,175,178,194,183,180,203,197,170,186,191,174,184,186,
		  167,172,195,183,172,193,191,167,182,198,185,172,189,187,170,183,
		  191,176,177,195,180,173,189,187,178,188,188,179,188,184,171,173,
		  179,180,183,181,170,177,182,184,190,180,181,196,188,174,180,166,
		  180,212,206,185,193,208,187,181,213,214,194,205,207,188,199,216,
		  195,187,212,198,179,198,206,182,188,207,194,189,211,209,191,204,
		  212,189,169,197,192,171,183,187,171,183,199,182,190,204,193,184,
		  191,196,203,203,192,195,196,186,199,200,188,201,200,192,209,191,
		  165,201,202,177,186,204,179,159,187,192,186,202,202,178,181,205,
		  194,184,209,195,171,185,203,194,197,206,183,179,207,207,196,204,
		  223,212,183,201,214,195,202,213,188,185,210,194,185,200,203,200,
		  197,195,201,204,196,190,197,193,186,193,184,197,205,188,212,197,
		  166,197,207,176,182,207,198,172,182,184,163,185,206,184,178,192,
		  177,171,198,198,176,181,190,181,187,201,176,173,192,176,163,177,
		  204,195,180,189,192,191,197,199,191,189,196,189,188,184,182,194,
		  188,174,184,190,187,182,184,193,185,183,173,188,194,170,203,207,
		  187,197,212,183,187,211,217,197,203,213,179,185,213,193,187,209,
		  192,183,200,205,188,192,201,187,195,208,188,185,206,189,164,178,
		  211,195,185,201,187,187,201,190,180,194,197,189,198,193,187,205,
		  200,178,187,197,191,198,197,197,206,198,183,199,202,180,204,223,
		  180,189,201,174,168,188,195,186,195,207,180,175,201,188,179,205,
		  195,187,196,189,176,181,189,182,188,195,177,175,211,204,173,176,
		  194,188,183,201,193,183,200,194,176,189,188,181,192,187,182,197,
		  202,181,188,199,178,180,190,188,201,194,181,200,199,180,181,191,
		  165,182,196,182,173,178,176,180,194,194,182,177,197,192,179,200,
		  189,173,191,185,175,183,185,174,179,190,178,176,203,197,173,186,
		  183,177,175,190,187,173,193,197,183,198,192,177,190,188,177,187,
		  201,186,193,206,187,181,189,188,197,189,175,192,190,180,185,181,
		  196,201,208,196,200,208,185,180,202,202,193,195,204,193,184,209,
		  213,196,206,200,186,200,210,199,199,209,196,189,208,209,195,212,
		  210,196,188,202,203,183,191,199,191,203,204,182,181,189,188,193,
		  202,182,188,208,193,192,204,198,201,197,180,200,206,198,212,219,
		  185,190,204,184,179,197,183,169,194,195,176,182,193,180,168,188,
		  200,196,206,198,178,193,205,187,193,197,179,182,197,196,177,192,
		  199,180,182,200,201,191,186,178,186,194,194,189,183,177,175,181,
		  192,180,179,196,178,171,192,186,190,190,171,185,197,179,176,191,
		  182,175,201,190,171,190,188,170,193,201,177,181,193,186,168,176,
		  180,176,195,193,167,184,199,174,190,198,170,178,195,183,161,177,
		  199,175,173,192,186,191,200,176,186,204,193,202,204,187,183,190,
		  189,185,192,201,182,176,189,177,179,197,183,183,197,188,184,193,
		  211,198,213,207,190,215,208,182,202,210,188,194,211,206,188,194,
		  202,196,208,207,176,189,211,182,194,217,183,180,215,203,182,194,
		  220,203,186,201,194,195,208,192,193,214,202,204,207,198,201,206,
		  200,190,204,213,193,195,213,200,192,209,206,200,209,200,201,215,
		  184,193,215,208,183,199,193,179,197,203,175,177,195,194,187,195,
		  200,191,204,206,178,179,198,180,184,207,180,177,218,199,176,190,
		  193,191,191,191,184,191,194,184,182,188,183,190,191,181,190,193,
		  195,190,189,190,182,187,201,199,191,189,189,196,198,183,183,181,
		  157,174,202,201,180,183,174,168,189,204,179,178,195,181,166,174,
		  181,173,195,200,178,186,190,172,184,200,177,177,210,188,166,190,
		  182,175,192,187,170,190,197,185,182,186,181,186,186,174,187,191,
		  187,188,195,182,177,188,181,179,187,177,174,191,190,182,200,183,
		  172,172,198,203,196,203,196,181,196,209,185,190,213,197,179,189,
		  198,186,202,207,182,202,217,191,198,210,181,184,217,194,173,203,
		  205,190,198,205,188,188,200,202,196,202,203,201,197,185,189,193,
		  193,194,210,196,181,200,199,193,204,198,192,196,187,187,214,212,
		  176,167,197,199,187,199,197,180,196,208,178,180,208,194,184,198,
		  192,178,191,195,174,182,195,184,190,200,170,174,211,188,165,189,
		  195,182,187,192,182,175,176,190,195,191,193,198,190,176,175,179,
		  178,181,200,195,171,182,190,183,186,184,192,200,178,174,200,211,
		  183,172,201,195,173,196,194,166,187,206,179,182,205,188,175,197,
		  188,174,195,193,175,183,185,168,186,206,179,181,210,193,168,185,
		  204,185,188,198,191,189,188,189,196,192,188,197,201,188,182,195,
		  187,178,199,206,182,183,194,190,185,180,186,201,190,171,193,209,
		  198,186,202,192,168,200,208,170,188,211,192,194,206,183,177,211,
		  205,184,209,213,190,202,212,188,192,213,192,189,216,207,174,184,
		  218,200,196,207,197,188,195,191,185,193,186,191,212,210,200,211,
		  210,190,199,206,193,196,199,201,199,191,183,197,210,194,203,215,
		  179,183,210,197,161,190,208,171,181,204,188,189,202,175,166,195,
		  196,178,190,194,179,185,203,189,181,194,176,173,198,199,168,170,
		  191,180,178,195,188,170,178,180,172,185,185,177,190,182,181,183,
		  181,174,186,185,175,184,174,175,184,181,176,184,188,177,182,196,
		  179,173,216,215,180,199,214,174,178,197,179,186,215,187,173,188,
		  181,174,188,188,174,174,185,182,186,199,180,180,199,199,176,180,
		  192,185,185,199,205,190,192,203,198,199,198,191,196,187,191,197,
		  188,176,195,193,180,203,201,193,205,191,177,192,188,176,174,196,
		  208,180,206,212,182,199,215,176,181,205,182,186,220,199,183,203,
		  196,191,208,213,199,196,201,194,199,213,186,187,214,211,196,205,
		  211,190,189,194,204,204,190,199,207,199,193,194,195,187,191,210,
		  206,192,207,195,179,198,204,200,213,193,171,195,204,203,195,214,
		  185,170,189,198,170,185,215,177,186,208,175,174,205,193,172,196,
		  192,182,195,191,187,196,200,184,179,198,175,166,194,188,176,187,
		  206,183,181,184,183,199,185,178,184,180,182,195,190,174,174,188,
		  179,179,207,199,175,176,180,175,188,188,171,182,190,183,179,190,
		  187,172,189,204,174,184,219,191,192,213,177,173,206,198,172,190,
		  187,171,192,186,175,188,199,182,178,204,190,167,184,183,170,170,
		  204,200,196,194,179,187,185,190,189,176,178,200,209,190,192,198,
		  182,183,206,212,201,195,199,191,193,205,196,192,200,183,179,198,
		  208,181,201,218,189,187,210,191,188,216,193,186,215,205,182,202,
		  208,191,208,201,180,193,219,200,190,218,215,196,207,206,189,187,
		  204,200,199,193,190,184,173,188,197,178,167,189,206,188,201,201,
		  177,169,187,196,190,201,211,203,195,202,197,196,215,202,188,214,
		  200,165,180,203,179,176,193,174,176,200,179,173,206,199,172,191,
		  190,179,202,194,163,176,209,192,170,194,198,193,209,207,180,175,
		  188,191,204,194,202,211,198,192,207,208,185,192,195,175,199,210,
		  185,165,189,190,169,180,187,177,170,170,162,176,199,185,165,191,
		  215,179,174,201,184,182,206,185,186,195,166,157,198,199,166,194,
		  189,165,196,200,165,172,206,191,165,170,161,173,195,188,177,168,
		  195,199,216,200,199,212,199,183,189,198,192,207,200,167,188,224,
		  203,177,206,205,185,200,205,199,200,204,183,187,210,199,167,186
		};
static uchar	velvet_pattern[64 * 64] =
		{
		  113,118,125,138,146,150,162,147,146,142,136,136,129,115,116,110,
		  110,110,120,120,118,110,118,110,120,115,130,110,111,110,114,110,
		  114,110,110,110,124,133,153,134,126,118,124,128,110,110,110,112,
		  110,113,110,110,136,114,126,134,134,130,138,148,135,128,131,137,
		  115,110,126,146,136,129,148,144,135,135,129,125,138,110,121,133,
		  110,120,125,140,132,118,110,126,110,122,113,129,126,110,110,110,
		  131,126,123,131,146,111,139,114,126,133,117,112,110,127,125,110,
		  115,110,110,143,110,120,120,133,130,141,144,136,142,144,140,127,
		  118,117,115,130,146,133,140,118,138,139,145,133,118,114,114,123,
		  148,150,135,132,141,126,136,126,113,132,113,110,131,128,146,128,
		  133,130,134,142,143,133,118,122,117,125,120,110,124,124,127,129,
		  117,139,135,110,120,132,145,141,131,153,129,151,119,127,110,128,
		  130,129,114,126,122,124,118,124,140,138,119,142,134,120,127,115,
		  129,133,122,150,110,123,120,122,128,138,118,116,126,128,143,141,
		  140,166,149,133,157,121,141,126,111,127,117,120,118,129,134,137,
		  149,136,140,141,111,137,142,152,136,141,148,124,126,121,134,145,
		  121,117,110,125,117,124,139,123,134,133,125,139,129,123,133,130,
		  127,146,126,126,133,124,135,119,127,124,133,141,150,141,143,151,
		  149,166,176,166,147,144,133,126,131,119,110,112,131,123,134,147,
		  142,164,134,122,140,131,118,155,159,146,136,133,146,129,137,110,
		  129,131,123,114,121,118,130,138,133,129,122,119,133,133,135,145,
		  127,136,135,144,121,146,151,139,138,138,161,137,155,154,142,155,
		  168,157,174,128,162,144,143,145,113,114,125,129,112,137,135,136,
		  148,117,143,145,136,116,150,130,122,149,144,136,133,133,121,135,
		  137,119,130,133,110,119,135,129,110,121,130,132,151,129,132,133,
		  123,130,128,134,151,129,148,138,145,129,147,150,157,135,156,139,
		  142,152,168,143,142,152,132,121,112,120,110,120,110,133,132,133,
		  113,113,121,133,116,122,128,142,148,140,149,153,130,132,124,146,
		  121,133,120,110,113,110,136,112,131,110,126,132,133,134,124,142,
		  123,127,126,133,152,139,152,128,163,142,127,159,165,148,151,160,
		  131,172,144,153,145,142,134,135,110,123,129,110,110,118,128,129,
		  143,126,112,121,117,128,125,126,133,135,143,138,144,118,111,131,
		  133,137,137,123,110,110,114,110,127,110,110,126,135,131,124,130,
		  110,125,142,131,147,147,159,153,135,145,145,162,160,167,154,170,
		  121,130,130,153,129,141,119,115,112,123,124,114,135,118,128,121,
		  114,110,116,120,110,114,124,121,126,128,114,114,129,127,133,148,
		  130,128,124,113,114,110,110,110,116,120,142,145,136,137,122,110,
		  110,127,112,144,138,162,141,161,168,199,159,167,169,162,157,159,
		  117,136,154,136,130,112,128,116,127,123,118,116,110,122,133,126,
		  122,110,120,114,125,120,143,110,121,131,119,115,137,111,126,143,
		  129,125,127,131,112,125,117,124,110,110,134,138,118,137,110,112,
		  121,113,130,156,156,177,172,157,196,143,157,173,175,177,152,130,
		  135,137,127,127,138,116,129,114,111,120,122,133,119,128,110,118,
		  114,128,112,123,135,110,117,136,129,119,126,110,120,122,123,136,
		  129,110,139,131,130,122,113,110,128,115,123,117,133,110,133,110,
		  139,151,139,146,138,172,179,174,182,163,180,182,151,147,151,147,
		  130,140,140,123,117,110,127,110,125,114,119,123,112,128,127,110,
		  136,121,110,116,117,120,117,120,118,124,135,126,110,110,120,123,
		  117,131,110,154,126,135,130,110,117,110,112,131,110,122,110,124,
		  120,135,146,143,149,175,163,182,144,174,201,189,151,160,141,135,
		  136,112,110,110,111,121,118,110,122,135,110,112,110,110,117,126,
		  130,110,125,115,120,119,130,125,127,124,123,142,136,123,110,123,
		  118,130,144,137,128,143,110,110,120,113,111,126,110,110,124,126,
		  119,127,144,167,153,146,165,153,149,181,160,141,157,149,128,142,
		  134,130,110,112,110,133,148,131,130,121,127,123,115,138,141,116,
		  115,110,118,110,121,110,110,135,132,134,121,122,128,115,128,127,
		  124,129,136,136,130,120,132,110,123,112,110,122,128,137,130,128,
		  124,124,126,141,153,134,138,153,148,173,153,164,167,160,124,136,
		  114,118,118,120,121,151,143,120,130,123,128,128,138,121,120,112,
		  115,121,120,119,116,138,124,127,126,117,139,139,139,113,120,110,
		  133,126,145,124,127,111,129,126,125,110,112,124,115,114,120,121,
		  110,121,123,126,129,142,147,156,153,155,162,168,150,140,124,126,
		  124,127,114,136,142,138,135,125,136,131,132,120,116,120,110,119,
		  130,131,118,120,133,123,118,121,113,124,164,126,131,135,125,121,
		  123,138,124,110,121,125,136,140,130,113,110,110,124,112,110,121,
		  110,124,129,135,150,145,139,144,159,156,162,146,162,140,120,113,
		  110,124,121,129,133,152,154,121,139,128,140,158,140,140,123,131,
		  110,110,126,121,144,139,153,122,120,138,126,129,127,130,121,136,
		  116,130,110,116,132,118,138,133,110,110,114,116,112,118,110,111,
		  128,115,124,151,155,155,157,196,165,152,157,161,142,126,126,124,
		  124,134,148,170,173,148,158,139,136,141,124,149,162,144,143,127,
		  110,110,110,124,123,156,142,144,142,118,139,128,136,124,126,129,
		  114,110,119,128,125,121,140,126,120,113,111,116,125,127,110,133,
		  127,138,139,141,144,177,148,168,156,159,138,132,149,121,131,110,
		  132,127,130,134,158,152,148,158,136,151,166,158,160,141,141,131,
		  130,142,136,132,141,157,142,135,145,145,135,151,124,120,136,110,
		  125,110,112,128,127,133,129,114,113,119,135,113,146,126,150,128,
		  121,138,137,162,156,165,166,153,160,153,167,140,145,133,110,123,
		  130,139,126,147,152,158,135,151,157,150,164,179,171,146,160,153,
		  134,153,154,121,148,157,133,141,140,140,148,139,157,128,136,110,
		  117,110,127,128,128,126,126,130,110,113,110,110,123,136,131,122,
		  125,127,133,152,145,173,164,146,157,176,136,138,110,125,114,114,
		  120,126,140,151,142,166,166,154,157,138,157,164,172,187,147,164,
		  155,167,156,128,138,139,149,152,157,143,146,144,141,146,115,126,
		  118,114,116,123,122,136,121,121,138,125,110,119,145,140,132,143,
		  138,135,137,161,146,174,172,152,149,140,136,123,116,115,128,125,
		  128,153,148,156,174,144,154,143,157,169,163,165,175,179,181,156,
		  175,170,162,145,160,132,132,153,140,143,165,130,148,122,119,131,
		  117,136,137,110,143,124,110,132,114,130,114,122,127,132,123,135,
		  114,110,130,125,132,126,138,148,137,124,132,125,130,120,138,137,
		  137,139,169,164,167,163,142,166,158,164,172,175,155,144,162,159,
		  162,145,149,184,183,171,145,155,153,162,171,166,136,121,116,112,
		  120,121,133,135,136,120,121,126,129,116,113,129,127,140,135,135,
		  119,112,110,122,121,137,124,116,120,130,126,112,112,125,136,144,
		  130,144,141,155,178,170,141,140,154,151,166,144,173,141,144,152,
		  147,142,163,163,172,160,132,147,172,143,122,151,157,149,129,110,
		  137,110,110,123,132,110,147,115,116,110,112,113,116,119,129,131,
		  110,116,110,110,111,110,124,110,120,112,110,110,130,130,140,146,
		  131,138,140,140,187,164,180,140,145,148,164,155,155,146,140,146,
		  154,146,152,165,148,182,159,158,131,151,135,162,156,135,119,118,
		  118,118,124,113,138,148,133,132,153,151,125,120,140,133,138,119,
		  110,124,115,110,110,130,125,125,114,118,143,128,130,126,135,150,
		  142,164,160,168,159,164,176,144,144,134,157,145,140,151,157,150,
		  145,153,141,166,164,162,159,165,162,142,156,139,129,114,115,127,
		  137,135,140,131,151,140,132,160,124,130,135,122,110,145,131,136,
		  110,136,118,116,120,122,125,110,110,128,126,133,143,120,121,146,
		  160,132,151,160,173,180,146,161,129,139,147,162,148,130,138,157,
		  144,150,165,164,172,179,164,155,154,157,133,128,110,139,121,130,
		  139,148,148,135,145,142,155,139,157,130,133,120,135,128,136,134,
		  124,124,121,132,130,118,110,130,110,118,124,121,114,148,136,124,
		  146,134,136,162,131,160,152,145,147,137,123,145,156,146,156,142,
		  142,133,152,166,155,153,170,159,163,165,149,123,134,123,129,132,
		  151,163,140,150,124,146,152,157,145,142,112,111,121,143,137,135,
		  123,110,124,128,135,112,121,114,110,121,124,123,117,124,135,123,
		  143,133,140,151,157,140,138,140,124,115,131,122,132,124,126,123,
		  127,158,148,137,161,155,160,169,173,167,149,142,136,132,124,155,
		  153,141,126,119,135,143,150,136,142,144,121,121,114,125,131,138,
		  133,124,110,122,121,116,117,121,110,124,126,121,130,129,110,124,
		  133,126,124,110,136,129,126,123,113,110,128,110,125,113,115,127,
		  122,126,143,135,160,155,140,174,142,145,144,145,125,131,131,132,
		  142,133,149,122,133,144,126,142,146,123,129,114,112,110,121,130,
		  125,142,123,121,126,116,124,113,112,110,111,142,123,112,126,110,
		  133,139,147,125,141,110,121,110,110,110,119,110,110,111,121,110,
		  128,121,147,140,155,143,152,181,156,134,169,146,125,140,122,116,
		  126,122,111,123,138,134,133,122,132,128,132,110,110,114,110,117,
		  123,110,128,116,110,110,124,135,110,110,110,113,121,130,127,133,
		  122,113,125,116,114,116,117,110,121,114,126,120,111,110,129,133,
		  124,135,150,138,146,155,148,129,164,147,149,160,133,138,133,124,
		  112,110,116,116,137,122,141,141,120,141,131,126,116,117,129,110,
		  120,110,110,122,112,118,110,116,115,123,123,137,132,129,121,110,
		  116,119,121,110,113,130,110,118,132,135,110,124,132,123,127,136,
		  116,144,118,147,157,151,156,136,160,154,159,121,128,136,137,110,
		  110,110,121,137,131,114,137,135,135,119,117,117,129,114,123,122,
		  140,120,110,124,118,110,115,133,118,116,137,143,144,142,128,122,
		  116,124,120,124,126,131,122,126,121,138,140,144,129,116,124,138,
		  120,110,129,131,146,162,159,168,161,130,158,120,134,132,121,121,
		  118,110,110,116,116,132,138,137,147,153,133,151,112,138,156,143,
		  119,122,145,129,148,136,128,141,148,135,126,149,135,138,126,130,
		  122,123,135,117,129,126,140,148,120,150,147,129,137,129,148,140,
		  121,122,123,121,137,147,157,143,149,153,127,146,140,142,134,119,
		  126,119,124,118,123,118,128,126,143,129,138,151,136,135,140,138,
		  146,153,160,142,146,146,151,145,161,167,146,146,153,158,157,142,
		  128,148,114,147,136,128,135,145,145,144,138,139,147,152,173,144,
		  140,140,110,127,111,148,135,167,153,159,150,116,126,143,135,113,
		  126,118,114,134,119,113,140,129,126,139,125,125,138,149,133,136,
		  136,146,136,138,144,148,138,162,144,179,151,161,151,155,146,140,
		  138,111,131,126,127,141,123,146,126,146,152,139,138,163,178,160,
		  140,156,123,135,122,114,141,128,132,141,132,142,136,124,127,110,
		  133,112,118,110,120,114,135,128,120,112,137,132,124,118,123,143,
		  151,141,124,165,150,143,163,168,161,159,193,177,168,165,158,141,
		  121,141,145,127,138,162,135,159,150,140,144,137,143,151,153,149,
		  142,148,122,118,120,129,148,130,112,135,151,144,155,133,136,132,
		  110,112,110,110,128,132,144,143,141,128,121,127,140,126,129,133,
		  136,123,141,130,131,151,153,161,148,159,155,161,159,162,142,151,
		  165,147,155,166,152,158,158,149,153,181,153,159,164,158,155,159,
		  146,171,136,127,120,123,112,136,132,146,163,141,138,138,142,120,
		  110,110,118,110,123,122,133,123,120,125,128,138,128,125,110,112,
		  117,120,117,117,143,130,142,144,134,143,180,165,157,154,159,140,
		  142,152,153,144,147,140,159,143,153,149,161,135,154,143,163,152,
		  151,120,149,133,126,135,114,124,110,116,136,146,146,134,115,119,
		  110,115,120,112,123,132,141,129,137,118,121,134,127,138,117,115,
		  110,110,110,120,120,112,129,121,145,144,158,161,165,164,162,166,
		  149,152,147,156,132,174,166,153,153,140,157,156,149,145,173,125,
		  144,153,150,145,163,134,132,141,110,133,123,127,142,134,138,123,
		  118,119,126,121,121,113,131,110,130,120,137,135,132,132,110,125,
		  111,121,110,110,110,120,122,141,128,169,141,148,157,184,178,178,
		  162,154,162,148,131,136,142,150,148,151,129,149,164,136,158,164,
		  130,162,150,151,150,135,125,112,125,125,120,130,141,113,126,126,
		  136,117,119,113,120,115,125,140,129,121,146,136,146,125,117,110,
		  126,127,111,110,118,135,135,125,137,136,167,139,151,146,147,157,
		  151,167,150,156,146,142,144,143,158,159,155,159,154,162,158,153,
		  151,147,161,144,146,133,138,118,110,110,110,132,121,118,113,120,
		  110,127,138,110,124,131,121,146,138,125,130,148,126,114,145,132,
		  118,123,120,119,120,127,127,143,130,134,125,137,161,161,166,170,
		  161,136,133,150,137,153,150,154,166,155,151,157,150,151,166,159,
		  135,138,142,152,128,143,135,134,116,110,126,116,124,110,126,142,
		  122,110,136,126,137,119,138,121,133,138,131,140,146,138,120,146,
		  135,130,132,122,117,110,136,147,141,136,144,155,166,147,153,152,
		  137,142,129,152,166,138,148,148,172,153,142,140,133,161,153,140,
		  135,140,129,141,110,110,110,111,130,131,116,110,124,125,115,116,
		  115,125,129,119,126,126,127,133,148,149,146,146,126,139,133,117,
		  114,131,130,121,134,124,136,137,128,126,148,166,157,151,172,154,
		  129,123,125,126,110,122,138,148,123,131,141,121,126,125,131,125,
		  143,118,114,126,121,139,124,110,132,123,126,136,120,116,127,124,
		  138,126,136,129,114,124,118,113,120,142,135,110,139,142,126,135,
		  140,126,110,118,113,124,112,136,127,132,144,157,145,165,157,139,
		  125,127,112,111,110,116,123,124,133,112,133,128,135,128,144,123,
		  130,115,129,110,125,124,134,129,110,125,110,114,129,125,126,121,
		  116,128,136,129,121,150,131,118,115,139,134,116,126,119,127,140,
		  131,113,121,114,110,121,119,113,124,135,138,168,170,144,129,121,
		  116,124,126,126,124,117,120,118,134,125,122,123,140,119,130,143,
		  111,110,110,130,127,132,130,110,138,121,135,110,112,125,127,110,
		  129,118,143,118,130,110,113,128,114,130,123,137,122,134,123,121,
		  116,110,116,118,130,128,129,153,121,146,153,160,149,147,130,110,
		  110,127,111,140,140,126,137,119,118,110,110,125,136,114,124,119,
		  116,132,137,136,130,148,148,138,116,135,141,142,125,133,126,110,
		  114,110,133,142,129,116,117,136,129,112,124,131,124,134,125,131,
		  110,128,113,118,120,134,142,132,126,136,130,146,155,136,132,111,
		  110,129,141,133,126,132,144,128,134,117,112,129,128,141,120,122,
		  110,123,136,140,144,164,144,149,129,119,144,150,163,148,145,131,
		  146,131,113,128,118,132,139,122,110,110,111,110,129,148,124,127,
		  113,120,130,131,132,116,135,136,122,129,136,135,122,130,123,117,
		  134,124,118,129,140,119,147,126,134,143,126,130,156,133,141,131,
		  133,128,121,135,136,170,165,141,129,144,151,155,158,135,155,121,
		  129,120,116,113,135,135,151,135,148,110,127,120,123,117,133,131,
		  123,116,130,126,127,117,124,133,146,110,138,120,119,132,125,138,
		  129,138,136,144,119,140,152,131,133,126,143,134,138,120,135,124,
		  115,113,120,140,142,143,153,147,144,122,145,152,143,140,145,146,
		  132,160,135,145,154,124,133,146,146,146,110,123,127,120,132,133,
		  113,128,110,114,110,127,130,131,137,130,118,110,134,117,141,130,
		  126,148,140,146,142,142,141,137,140,140,116,123,131,132,116,144,
		  120,110,138,141,155,164,166,146,147,142,125,134,153,133,159,136,
		  163,138,166,122,135,135,140,140,133,113,110,110,129,133,121,112,
		  110,123,143,127,119,119,124,122,121,138,117,150,128,121,128,155,
		  149,149,148,142,146,148,134,132,128,127,110,138,122,128,135,134,
		  134,110,133,134,145,143,149,143,153,153,145,145,118,153,141,141,
		  155,138,171,126,136,141,142,151,140,133,118,140,130,138,131,118,
		  110,126,135,125,120,110,120,119,123,129,132,124,148,146,140,135,
		  151,149,148,164,150,157,151,159,148,142,130,114,128,125,114,112,
		  141,116,130,114,114,135,142,146,139,147,147,140,136,141,137,164,
		  155,148,156,145,134,126,140,151,139,130,132,153,137,135,122,110,
		  112,127,124,143,122,115,111,124,125,120,123,145,133,146,144,161,
		  150,136,162,157,151,135,133,129,139,117,110,123,132,128,134,125,
		  112,112,110,118,124,121,117,129,129,139,135,140,134,136,145,133,
		  124,139,146,159,140,162,129,140,139,155,133,151,135,125,136,110,
		  110,116,110,117,130,137,130,124,110,121,142,148,148,167,167,160,
		  152,136,172,144,151,137,133,147,128,122,118,130,129,119,118,110,
		  114,135,124,135,110,127,121,132,110,113,147,126,133,145,154,144,
		  141,141,148,148,138,146,143,146,148,154,146,147,146,138,145,116,
		  115,110,129,129,138,128,124,146,119,128,131,154,147,149,157,137,
		  139,144,143,149,154,148,142,127,125,121,120,143,115,137,124,111,
		  125,116,118,124,112,110,123,126,114,125,114,133,130,144,140,138,
		  158,146,145,161,154,148,157,138,160,152,133,136,144,142,122,117,
		  120,125,133,142,128,132,124,133,132,121,127,151,144,160,176,146,
		  151,140,137,140,154,151,129,151,110,129,114,121,133,129,126,129,
		  110,112,127,122,119,131,146,142,120,132,127,115,115,119,133,148,
		  145,137,163,148,160,165,154,160,138,151,151,139,166,135,126,118,
		  112,144,132,117,127,139,136,129,138,116,129,143,143,144,132,145,
		  137,140,135,133,128,150,148,136,134,130,129,127,136,110,133,134,
		  110,119,110,126,137,128,133,136,144,136,132,113,127,129,129,148,
		  126,156,138,141,146,147,159,145,146,166,154,157,127,120,122,123,
		  110,121,118,135,129,127,135,124,130,142,140,140,145,148,144,126,
		  138,151,121,120,127,134,146,128,133,124,132,124,130,143,138,120,
		  125,123,119,129,138,127,140,152,150,157,139,117,121,110,110,132,
		  119,148,143,144,149,160,174,173,137,166,160,119,148,133,130,137,
		  132,131,137,131,118,123,138,126,139,149,126,141,136,131,133,135,
		  143,127,118,135,125,135,126,151,127,138,127,153,144,125,148,131,
		  117,135,119,158,143,137,145,159,144,141,164,140,136,110,112,123,
		  113,121,155,146,147,169,160,153,147,158,163,132,159,143,124,118,
		  119,121,132,110,110,110,123,135,131,122,121,114,129,132,128,133,
		  132,142,120,113,117,111,127,137,141,121,135,127,118,120,136,123,
		  123,116,110,141,143,132,155,157,152,144,152,140,147,110,132,110,
		  119,142,145,141,182,170,172,137,143,145,146,132,144,125,128,110,
		  129,110,110,112,112,113,145,111,132,127,113,132,118,120,110,111,
		  110,110,110,110,116,118,137,118,121,123,115,110,129,124,110,110,
		  119,120,132,126,131,133,145,142,142,156,158,137,137,130,126,114
		};


//
// 'Fl_Print_Dialog::load_prefs()' - Load preferences for the current printer.
//

void
Fl_Print_Dialog::load_prefs()
{
  char		name[1024],			// Name of attribute
		val[1024];			// Attribute string value
  int		v;				// Attribute integer value
  double	r;				// Attribute real value
  const char	*p;				// Queue name
  time_t	curtime;			// Current time
  struct tm	*curdate;			// Current date


  // First load all of the printing preferences for the selected
  // queue.
  p = printer();

  if (!p)
    p = "-print-to-file";

  snprintf(name, sizeof(name), "%s/units", p);
  flphoto::prefs.get(name, v, -1);
  if (v >= 0)
    media_units_->value(v);
  else
    media_units_->value(0);

  snprintf(name, sizeof(name), "%s/media", p);
  flphoto::prefs.get(name, val, "", sizeof(val));
  if (val[0])
    media(val);
#ifdef HAVE_LIBCUPS
  else if (ppd_)
  {
    ppd_size_t *s = ppdPageSize((ppd_file_t *)ppd_, 0);

    media(s->name);
  }
#endif // HAVE_LIBCUPS
  else
    media_chooser_->value(0);

  media_cb();

  snprintf(name, sizeof(name), "%s/quality", p);
  flphoto::prefs.get(name, v, -1);
  if (v >= 0)
    quality(v);
  else
    quality(1);

  snprintf(name, sizeof(name), "%s/mode", p);
  flphoto::prefs.get(name, v, -1);
  if (v >= 0)
    mode(v);
  else
    mode(1);

  // Then set the initial calendar month and year...
  curtime = time(NULL);
  curdate = localtime(&curtime);

  calendar_month_chooser_->value(curdate->tm_mon);
  calendar_year_value_->value(curdate->tm_year + 1900);

  flphoto::prefs.get("firstday", v, 1);
  calendar_day_chooser_->value(v);

  // Get the matting preferences...
  flphoto::prefs.get("mat_type", v, 0);
  mat_type_chooser_->value(v);

  flphoto::prefs.get("mat_color", val, "#00007F", sizeof(val));
  mat_color_field_->value(val);

  flphoto::prefs.get("mat_width_value", r, 2.0);
  mat_width_value_->value(r);

  flphoto::prefs.get("mat_width_units", v, 1);
  mat_width_units_->value(v);

  mat_color_cb(mat_color_field_);

  flphoto::prefs.get("image_width_value", r, 6.0);
  image_width_value_->value(r);

  flphoto::prefs.get("image_length_value", r, 4.0);
  image_length_value_->value(r);

  flphoto::prefs.get("image_units", v, 1);
  image_units_->value(v);

  flphoto::prefs.get("image_cols_value", v, 1);
  image_cols_value_->value(v);

  flphoto::prefs.get("image_rows_value", v, 1);
  image_rows_value_->value(v);
}


//
// 'Fl_Print_Dialog::load_printers()' - Load the list of available printers.
//

void
Fl_Print_Dialog::load_printers()
{
#ifdef HAVE_LIBCUPS
  int		i;				// Looping var
  int		num_dests;			// Number of destinations
  cups_dest_t	*dests,				// Destinations
		*dest;				// Current destination
  char		quoted[255],			// Quoted destination name
		*qptr,				// Pointer into string
		*nptr;				// Pointer into name


  // Get the list of available destinations...
  num_dests = cupsGetDests(&dests);

  // Build the list of destinations, including a "print to file" destination.
  printer_chooser_->clear();
  printer_chooser_->add("Print To File...");

  for (i = 0; i < num_dests; i ++)
    if (!dests[i].instance)
    {
      for (qptr = quoted, nptr = dests[i].name; *nptr;)
      {
        if (*nptr == '@')
	  *qptr++ = '@';

	*qptr++ = *nptr++;
      }
      *qptr = '\0';

      printer_chooser_->add(quoted);
    }

  // Set the default destination...
  if ((dest = cupsGetDest(NULL, NULL, num_dests, dests)) != NULL)
    printer(dest->name);
  else
  {
    printer_chooser_->value(0);
    printer_cb();

    load_prefs();
  }

  // Free the destination list...
  cupsFreeDests(num_dests, dests);
#else
  FILE		*fp;				// File/pipe
  char		line[1024],			// Line from file/pipe
		*ptr,				// Pointer into line
		defprinter[1024];		// Default printer


  // Clear the list and add the "print to file" choice...
  printer_chooser_->clear();
  printer_chooser_->add("Print To File...");

  flphoto::prefs.get("default_printer", defprinter, "", sizeof(defprinter));

  if ((fp = fopen("/etc/printcap", "r")) != NULL)
  {
    // Try reading the /etc/printcap file...
    while (fgets(line, sizeof(line), fp) != NULL)
    {
      if (!isalpha(line[0]))
        continue;

      if ((ptr = strchr(line, ':')) == NULL)
        continue;

      *ptr = '\0';

      printer_chooser_->add(line);

      if (!defprinter[0])
      {
	strncpy(defprinter, line, sizeof(defprinter) - 1);
        defprinter[sizeof(defprinter) - 1] = '\0';
      }
    }
  }
  else if ((fp = popen("lpstat -p -d", "r")) != NULL)
  {
    // Try reading the output of the "lpstat" command...
    while (fgets(line, sizeof(line), fp) != NULL)
    {
      // We want either "printer foo ..." or "system default destination: foo"
      if (strncmp(line, "printer ", 8) == 0)
      {
        if ((ptr = strchr(line + 8, ' ')) != NULL)
	  *ptr = '\0';
        if ((ptr = strchr(line + 8, '/')) != NULL)
	  continue; // Don't show CUPS instances...

        printer_chooser_->add(line + 8);
      }
      else if (strncmp(line, "system default destination: ", 28) == 0 &&
               !defprinter[0])
      {
        strcpy(defprinter, line + 28);
        if ((ptr = strchr(defprinter, '\n')) != NULL)
	  *ptr = '\0';
        if ((ptr = strchr(defprinter, '/')) != NULL)
	  *ptr = '\0';
      }
    }

    pclose(fp);
  }

  // If we couldn't get a list of printers, add a default destination...
  if (printer_chooser_->size() < 3)
    printer_chooser_->add("Default Printer");

  // If we have a default destination, use it...
  if (defprinter[0])
    printer(defprinter);
  else
  {
    printer_chooser_->value(0);
    printer_cb();

    load_prefs();
  }
#endif // HAVE_LIBCUPS
}


//
// 'Fl_Print_Dialog::print_cb()' - Do the print.
//

void
Fl_Print_Dialog::print_cb()
{
  const char	*f;				// Print file
  int		id;				// Job ID


  // Save print settings...
  save_prefs();

  // Disable the print controls while printing...
  control_group_->deactivate();
  Fl::check();

  // Do the callback function to create a print file...
  if (callback_)
    f = (*callback_)(this, calldata_);
  else
    f = 0;

  // Reactivate the print controls...
  control_group_->activate();

  if (f)
  {
    // Print the file...
    if (printer_chooser_->value() == 0)
    {
      fl_message("Job saved to %s.", f);
      id = -1;
    }
    else
    {
      if (getenv("FLPHOTO_DEBUG"))
      {
        id = 123;
	puts(f);
      }
      else
        id = print_file(f);

      if (id)
	fl_message("Job %s-%d submitted for printing.",
                   printer_chooser_->text(printer_chooser_->value()), id);
    }
  }
  else
    id = 0;

  if (!f || !id)
    fl_alert("Unable to submit job for printing!");
  else
    window_->hide();
}


//
// 'Fl_Print_Dialog::printer_cb()' - Update the dialog based on the current printer.
//

void
Fl_Print_Dialog::printer_cb()
{
#ifdef HAVE_LIBCUPS
  int		i, j, k, y;			// Looping vars
  const char	*f;				// PPD file
  Fl_Widget	*w;				// New widget
  Fl_Choice	*choice;			// New choice widget
  ppd_file_t	*ppd;				// PPD file
  ppd_group_t	*ppdgrp;			// Current group
  ppd_option_t	*ppdopt;			// Current option
  ppd_choice_t	*ppdc;				// Current choice
  char		quoted[255],			// Quoted choice text
		*qptr,				// Pointer into text
		*tptr;				// Pointer into choice


  // Close any existing PPD file and get rid of PPD options...
  if (ppd_)
  {
    ppdClose((ppd_file_t *)ppd_);
    ppd_ = 0;
  }

  for (i = ppd_scroll_->children() - 1; i >= 0; i --)
  {
    w = ppd_scroll_->child(i);

    if (w == &(ppd_scroll_->scrollbar) || w == &(ppd_scroll_->hscrollbar))
      continue;

    ppd_scroll_->remove(w);
    delete w;
  }

  ppd_scroll_->deactivate();

  // See if this printer has a PPD file...
  if ((f = cupsGetPPD(printer_chooser_->text(printer_chooser_->value()))) != NULL)
  {
    ppd = ppdOpenFile(f);
    unlink(f);

    ppd_ = (void *)ppd;
  }
  else
    ppd = 0;

  // Add the media and other options, as possible...
  media_chooser_->clear();

  if (ppd)
  {
    // OK, we have a PPD file, add all but the "installed" group options...
    ppdMarkDefaults(ppd);

    ppd_scroll_->activate();
    ppd_scroll_->user_data((void *)this);
    ppd_scroll_->begin();

    y = ppd_scroll_->y() + Fl::box_dy(ppd_scroll_->box());

    for (i = ppd->num_groups, ppdgrp = ppd->groups; i > 0; i --, ppdgrp ++)
    {
      if (strstr(ppdgrp->text, "inst") || strstr(ppdgrp->text, "Inst"))
        continue;

      for (j = ppdgrp->num_options, ppdopt = ppdgrp->options; j > 0; j --, ppdopt ++)
      {
        if (strcasecmp(ppdopt->keyword, "PageSize") == 0 ||
	    strcasecmp(ppdopt->keyword, "PageRegion") == 0)
          continue;

        choice = new Fl_Choice(235, y, 165, 25, ppdopt->text);
	choice->align(FL_ALIGN_LEFT);
	choice->labelfont(FL_HELVETICA_BOLD);
	choice->callback(ppd_cb, (void *)ppdopt);
	y += 30;

        for (k = 0, ppdc = ppdopt->choices; k < ppdopt->num_choices; k ++, ppdc ++)
	{
	  for (qptr = quoted, tptr = ppdc->text; *tptr;)
	  {
	    if (*tptr == '/' || *tptr == '\\')
	      *qptr++ = '\\';

	    *qptr++ = *tptr++;
	  }

	  *qptr = '\0';

	  choice->add(quoted);

	  if (ppdc->marked || k == 0)
	    choice->value(k);
	}
      }
    }

    window_->end();

    // Add page sizes...
    if ((ppdopt = ppdFindOption(ppd, "PageSize")) != NULL)
    {
      for (k = 0, ppdc = ppdopt->choices; k < ppdopt->num_choices; k ++, ppdc ++)
      {
	for (qptr = quoted, tptr = ppdc->text; *tptr;)
	{
	  if (*tptr == '/' || *tptr == '\\')
	    *qptr++ = '\\';

	  *qptr++ = *tptr++;
	}

	*qptr = '\0';

	media_chooser_->add(quoted);
      }
    }
    else
    {
      media_chooser_->add("a4");
      media_chooser_->add("letter");

      if (ppd->variable_sizes)
	media_chooser_->add("custom");
    }
  }
  else
  {
    media_chooser_->add("a4");
    media_chooser_->add("letter");
    media_chooser_->add("custom");
  }
#else
  media_chooser_->clear();
  media_chooser_->add("a4");
  media_chooser_->add("letter");
  media_chooser_->add("custom");
#endif // HAVE_LIBCUPS

  media_chooser_->value(0);

  load_prefs();
}


//
// 'Fl_Print_Dialog::save_prefs()' - Save the current settings in the preferences.
//

void
Fl_Print_Dialog::save_prefs()
{
  char		name[1024];			// Name of attribute
  const char	*p;				// Current printer
  const char	*val;				// Media value


  p = printer();

  if (!p)
    p = "-print-to-file";
  else
    flphoto::prefs.set("default_printer", p);

  snprintf(name, sizeof(name), "%s/media", p);
  if ((val = media()) != NULL)
    flphoto::prefs.set(name, val);

  snprintf(name, sizeof(name), "%s/units", p);
  flphoto::prefs.set(name, media_units_->value());

  snprintf(name, sizeof(name), "%s/quality", p);
  flphoto::prefs.set(name, quality());

  snprintf(name, sizeof(name), "%s/mode", p);
  flphoto::prefs.set(name, mode());

  // Set the calendar preferences...
  flphoto::prefs.set("firstday", calendar_day_chooser_->value());

  // Set the matting preferences...
  flphoto::prefs.set("mat_type", mat_type_chooser_->value());
  flphoto::prefs.set("mat_color", mat_color_field_->value());
  flphoto::prefs.set("mat_width_value", mat_width_value_->value());
  flphoto::prefs.set("mat_width_units", mat_width_units_->value());

  flphoto::prefs.set("image_width_value", image_width_value_->value());
  flphoto::prefs.set("image_length_value", image_length_value_->value());
  flphoto::prefs.set("image_units", image_units_->value());
  flphoto::prefs.set("image_cols_value", image_cols_value_->value());
  flphoto::prefs.set("image_rows_value", image_rows_value_->value());
}


//
// 'Fl_Print_Dialog::format()' - Set the print format.
//

void
Fl_Print_Dialog::format(int f)			// I - Print format
{
  switch (f)
  {
    case PRINT_INDEX :
        print_index_button_->setonly();
	calendar_group_->deactivate();
	mat_group_->deactivate();
	break;
    case PRINT_1UP :
        print_1up_button_->setonly();
	calendar_group_->deactivate();
	mat_group_->deactivate();
	break;
    case PRINT_2UP :
        print_2up_button_->setonly();
	calendar_group_->deactivate();
	mat_group_->deactivate();
	break;
    case PRINT_4UP :
        print_4up_button_->setonly();
	calendar_group_->deactivate();
	mat_group_->deactivate();
	break;
    case PRINT_PORTRAIT :
        print_portrait_button_->setonly();
	calendar_group_->deactivate();
	mat_group_->deactivate();
	break;
    case PRINT_CALENDAR :
        print_calendar_button_->setonly();
	calendar_group_->activate();
	mat_group_->deactivate();
	break;
    default :
        print_matted_button_->setonly();
	calendar_group_->deactivate();
	mat_group_->activate();
	break;
  }
}


//
// 'Fl_Print_Dialog::format()' - Get the print format.
//

int						// O - Print format
Fl_Print_Dialog::format()
{
  if (print_index_button_->value())
    return (PRINT_INDEX);
  else if (print_1up_button_->value())
    return (PRINT_1UP);
  else if (print_2up_button_->value())
    return (PRINT_2UP);
  else if (print_4up_button_->value())
    return (PRINT_4UP);
  else if (print_portrait_button_->value())
    return (PRINT_PORTRAIT);
  else if (print_calendar_button_->value())
    return (PRINT_CALENDAR);
  else
    return (PRINT_MATTED);
}


//
// 'Fl_Print_Dialog::imageable_area()' - Get the imageable area for the page.
//

void
Fl_Print_Dialog::imageable_area(int &left,	// O - Left position in points
                                int &bottom,	// O - Bottom position in points
				int &right,	// O - Right position in points
				int &top)	// O - Top position in points
{
#ifdef HAVE_LIBCUPS
  ppd_size_t	*size;


  if (ppd_)
  {
    size = ppdPageSize((ppd_file_t *)ppd_, media());

    if (size != NULL)
    {
      // Get the imageable area from the PPD file...
      left   = (int)(size->left + 0.5);
      bottom = (int)(size->bottom + 0.5);
      right  = (int)size->right;
      top    = (int)size->top;

      return;
    }
  }
#endif // HAVE_LIBCUPS

  paper_dimension(right, top);

  left   = 9;
  bottom = 36;
  right  -= 9;
  top    -= 18;
}


//
// 'Fl_Print_Dialog::mat_color_cb()' - Change the mat color...
//

void
Fl_Print_Dialog::mat_color_cb(Fl_Widget *w)	// I - Widget
{
  int		i;				// Looping var
  const char	*c;				// Color string
  unsigned	val;				// Raw color value
  uchar		rgb[3];				// RGB color value
  char		s[255];				// New color string


  // Get the matting color...
  c = mat_color_field_->value();
  for (i = 0; i < 16; i ++)
    if (w == mat_color_buttons_[i])
    {
      c = mat_colors_[i];
      break;
    }

  if (c && *c == '#')
    val = strtol(c + 1, NULL, 16);
  else
    val = 0x000000;

  rgb[0] = (val >> 16) & 255;
  rgb[1] = (val >> 8) & 255;
  rgb[2] = val & 255;

  if (w == mat_color_button_)
    fl_color_chooser("Matting Color", rgb[0], rgb[1], rgb[2]);

  if (w != mat_color_field_)
  {
    val = (((rgb[0] << 8) | rgb[1]) << 8) | rgb[2];

    sprintf(s, "#%06X", val);
    mat_color_field_->value(s);
  }

  mat_color_button_->color(fl_rgb_color(rgb[0], rgb[1], rgb[2]));
  mat_color_button_->redraw();

  mat_type_cb();
}


//
// 'Fl_Print_Dialog::mat_type_cb()' - Change the mat type...
//

void
Fl_Print_Dialog::mat_type_cb()
{
  int		x, y;				// Looping vars
  static uchar	data[64 * 64 * 4];		// Preview image data
  uchar		*ptr;				// Pointer into data


  // Generate the mat image...
  matimage(data, 1);

  // Add the edge of the matting...
  if (mat_type_chooser_->value())
  {
    for (ptr = data + 32 * 64 * 4, x = 32; x > 0; x --, ptr ++)
    {
      *ptr++ = 223;
      *ptr++ = 223;
      *ptr++ = 223;
    }

    for (ptr += 32 * 4, x = 31; x > 0; x --, ptr ++)
    {
      *ptr++ = 223;
      *ptr++ = 223;
      *ptr++ = 223;
    }

    *ptr++ = 255;
    *ptr++ = 255;
    *ptr++ = 255;

    for (ptr += 32 * 4 + 1, y = 30; y > 0; y --, ptr += 64 * 4)
    {
      memset(ptr, 0, 30 * 4);
      memset(ptr + 30 * 4, 255, 2 * 4);
    }
  }
  else
  {
    for (ptr = data + 32 * 64 * 4, y = 32; y > 0; y --, ptr += 64 * 4)
      memset(ptr, 0, 32 * 4);
  }

  // Update the preview...
  if (mat_preview_image_)
    delete mat_preview_image_;

  mat_preview_image_ = new Fl_RGB_Image(data, 64, 64, 4);
  mat_preview_box_->image(mat_preview_image_);

  window_->damage(FL_DAMAGE_EXPOSE,
                  mat_preview_box_->x(), mat_preview_box_->y(),
                  mat_preview_box_->w(), mat_preview_box_->h());
}


//
// 'Fl_Print_Dialog::matcolors()' - Find important colors in images...
//

void
Fl_Print_Dialog::matcolors(Fl_Image_Browser *b)	// I - Image browser
{
  int				i, j;		// Looping vars
  int				temp;		// Temporary swap var
  int				colors[256][2];	// Color history
  const uchar			*data;		// Pointer into image
  uchar				rr, gg, bb;	// RGB color value
  Fl_Image_Browser::ITEM	*item;		// Current image


  // Save the image browser...
  image_browser_ = b;

  if (!b)
    return;

  // Clear the color histogram...
  for (i = 0; i < 256; i ++)
  {
    colors[i][0] = i;
    colors[i][1] = 0;
  }

  // Loop through the images and count colors...
  for (i = 0; i < b->count(); i ++)
  {
    if (!print_all_button_->value() && !b->selected(i))
      continue;

    item = b->value(i);

    for (j = item->thumbnail->w() * item->thumbnail->h() * 3,
             data = (const uchar *)item->thumbnail->data()[0];
	 j > 0;
	 j --, data += 3)
    {
//      temp = (data[0] & 0xe0) | ((data[1] & 0xe0) >> 3) | (data[2] >> 6);
      temp = (data[0] & 0xc0) | ((data[1] & 0xc0) >> 3) | (data[2] >> 6);
      colors[temp][1] ++;
    }
  }

  // Sort the histogram...
  for (i = 0; i < 255; i ++)
    for (j = i + 1; j < 256; j ++)
      if (colors[i][1] < colors[j][1])
      {
        temp         = colors[i][0];
	colors[i][0] = colors[j][0];
	colors[j][0] = temp;

        temp         = colors[i][1];
	colors[i][1] = colors[j][1];
	colors[j][1] = temp;
      }

  // Set the first 16 colors...
  for (i = 0; i < 16; i ++)
  {
    rr = colors[i][0] & 0xe0;
    gg = (colors[i][0] << 3) & 0xe0;
    bb = (colors[i][0] << 6) & 0xc0;

    sprintf(mat_colors_[i], "#%02X%02X%02X", rr, gg, bb);
    mat_color_buttons_[i]->color(fl_rgb_color(rr, gg, bb));
  }
}


//
// 'Fl_Print_Dialog::matimage()' - Generate the mat image...
//

void
Fl_Print_Dialog::matimage(uchar *data,		// O - Image data
                          int   alpha)		// I - Include alpha channel?
{
  const char	*c;				// Color string
  unsigned	val;				// Raw color value
  uchar		rgb[3];				// RGB color value
  int		x, y;				// Looping vars
  uchar		*ptr,				// Pointer into data
		*pattern;			// Pointer into pattern
  int		patmax;				// Maximum pattern value


  // Get the matting color...
  c = mat_color_field_->value();

  if (c && *c == '#')
    val = strtol(c + 1, NULL, 16);
  else
    val = 0x000000;

  rgb[0] = (val >> 16) & 255;
  rgb[1] = (val >> 8) & 255;
  rgb[2] = val & 255;

//  printf("rgb = [ %d %d %d ]\n", rgb[0], rgb[1], rgb[2]);
//  printf("type = %d\n", mat_type_chooser_->value());

  // Generate the mat image...
  switch (mat_type_chooser_->value())
  {
    case MAT_BLANK :
        if (alpha)
	  memset(data, 255, 64 * 64 * 4);
	else
	  memset(data, 255, 64 * 64 * 3);
        break;
    case MAT_PLAIN :
        for (ptr = data, y = 64; y > 0; y --)
	  for (x = 64; x > 0; x --)
	  {
	    *ptr++ = rgb[0];
	    *ptr++ = rgb[1];
	    *ptr++ = rgb[2];
	    if (alpha)
	      *ptr++ = 255;
	  }
        break;
    case MAT_STANDARD :
        for (pattern = standard_pattern, patmax = 0, x = 64 * 64;
	     x > 0;
	     x --, pattern ++)
	  if (*pattern > patmax)
	    patmax = *pattern;

        for (ptr = data, pattern = standard_pattern, y = 64; y > 0; y --)
	  for (x = 64; x > 0; x --, pattern ++)
	  {
	    *ptr++ = rgb[0] * (int)*pattern / patmax;
	    *ptr++ = rgb[1] * (int)*pattern / patmax;
	    *ptr++ = rgb[2] * (int)*pattern / patmax;
	    if (alpha)
	      *ptr++ = 255;
	  }
        break;
    case MAT_VELVET :
        for (pattern = velvet_pattern, patmax = 0, x = 64 * 64;
	     x > 0;
	     x --, pattern ++)
	  if (*pattern > patmax)
	    patmax = *pattern;

        for (ptr = data, pattern = velvet_pattern, y = 64; y > 0; y --)
	  for (x = 64; x > 0; x --, pattern ++)
	  {
	    *ptr++ = rgb[0] * (int)*pattern / patmax;
	    *ptr++ = rgb[1] * (int)*pattern / patmax;
	    *ptr++ = rgb[2] * (int)*pattern / patmax;
	    if (alpha)
	      *ptr++ = 255;
	  }
        break;
  }
}


//
// 'Fl_Print_Dialog::matting()' - Get matting values...
//

void
Fl_Print_Dialog::matting(int   &type,		// O - Matting type
                         float &width,		// O - Matting width
			 uchar *rgb,		// O - Matting color
			 float &image_width,	// O - Width in points
			 float &image_height,	// O - Height in points
			 int   &image_cols,	// O - Number of columns
			 int   &image_rows)	// O - Number or rows
{
  const char	*c;				// Color string
  unsigned	val;				// Raw color value


  // Get the matting type and width...
  type  = mat_type_chooser_->value();
  width = mat_width_value_->value() * units[mat_width_units_->value()];

  // Get the matting color...
  c = mat_color_field_->value();

  if (c && *c == '#')
    val = strtol(c + 1, NULL, 16);
  else
    val = 0x000000;

  rgb[0] = (val >> 16) & 255;
  rgb[1] = (val >> 8) & 255;
  rgb[2] = val & 255;

  // Get the image size and counts...
  image_width  = image_width_value_->value() * units[image_units_->value()];
  image_height = image_length_value_->value() * units[image_units_->value()];
  image_cols   = (int)image_cols_value_->value();
  image_rows   = (int)image_rows_value_->value();
}


//
// 'Fl_Print_Dialog::media_cb()' - Enable/disable custom media sizes.
//

void
Fl_Print_Dialog::media_cb()
{
#ifdef HAVE_LIBCUPS
  if (ppd_)
  {
    // Enable/disable the custom size controls...
    ppd_size_t *s = ((ppd_file_t *)ppd_)->sizes + media_chooser_->value();

    if (!strcasecmp(s->name, "custom"))
      media_group_->activate();
    else
      media_group_->deactivate();

    return;
  }
#endif // HAVE_LIBCUPS

  // Enable/disable the custom size controls...
  if (!strcasecmp(media_chooser_->text(media_chooser_->value()), "custom"))
    media_group_->activate();
  else
    media_group_->deactivate();
}


//
// 'Fl_Print_Dialog::media()' - Set the output media.
//

void
Fl_Print_Dialog::media(const char *m)		// I - New media size
{
  int	i;					// Looping var


#ifdef HAVE_LIBCUPS
  if (ppd_)
  {
    if (strncasecmp(m, "custom.", 7) == 0)
    {
      // Set a custom size...
      int width, length;

      media_group_->activate();
      sscanf(m + 7, "%dx%d", &width, &length);

      media_width_value_->value(width / units[media_units_->value()]);
      media_length_value_->value(length / units[media_units_->value()]);

      m = "custom";
    }
    else
      media_group_->deactivate();

    for (i = 0; i < (media_chooser_->size() - 1); i ++)
      if (strcasecmp(m, ((ppd_file_t *)ppd_)->sizes[i].name) == 0)
      {
	media_chooser_->value(i);
	break;
      }
  }
  else
#endif // HAVE_LIBCUPS

  if (strncasecmp(m, "custom.", 7) == 0)
  {
    // Set a custom size...
    int width, length;

    for (i = 0; i < (media_chooser_->size() - 1); i ++)
      if (strcasecmp("custom", media_chooser_->text(i)) == 0)
      {
	media_chooser_->value(i);
	break;
      }

    media_group_->activate();
    sscanf(m + 7, "%dx%d", &width, &length);

    media_width_value_->value(width / units[media_units_->value()]);
    media_length_value_->value(length / units[media_units_->value()]);
  }
  else
  {
    media_group_->deactivate();

    for (i = 0; i < (media_chooser_->size() - 1); i ++)
      if (strcasecmp(m, media_chooser_->text(i)) == 0)
      {
	media_chooser_->value(i);
	break;
      }
  }
}


//
// 'Fl_Print_Dialog::media()' - Get the output media.
//

const char *					// O - Media size
Fl_Print_Dialog::media()
{
  int		width,				// Custom width
		length;				// Custom length
  const char	*name;				// Media size name
  static char	custom[255];			// Custom size name


  // Return immediately if there are no media sizes...
  if (media_chooser_->size() < 2)
    return (0);

  name = media_chooser_->text(media_chooser_->value());

#ifdef HAVE_LIBCUPS
  if (ppd_)
  {
    if (strcasecmp(((ppd_file_t *)ppd_)->sizes[media_chooser_->value()].name,
                   "Custom"))
      return (((ppd_file_t *)ppd_)->sizes[media_chooser_->value()].name);
  }
  else
#endif // HAVE_LIBCUPS
  if (strcasecmp(name, "custom"))
  {
      return (name);
  }

  width  = (int)(media_width_value_->value() * units[media_units_->value()]);
  length = (int)(media_length_value_->value() * units[media_units_->value()]);

  sprintf(custom, "Custom.%dx%d", width, length);

  return (custom);
}


//
// 'Fl_Print_Dialog::paper_dimension()' - Get the dimensions of the page.
//

void
Fl_Print_Dialog::paper_dimension(int &width,	// O - Width in points
                                 int &length)	// O - Length in points
{
#ifdef HAVE_LIBCUPS
  ppd_size_t	*size;				// Page size record


  if (ppd_)
  {
    if ((size = ppdPageSize((ppd_file_t *)ppd_, media())) != NULL)
    {
      width  = (int)size->width;
      length = (int)size->length;

      return;
    }
  }
#endif // HAVE_LIBCUPS

  const char	*name;


  name = media_chooser_->text(media_chooser_->value());

  if (strcasecmp(name, "custom") == 0)
  {
    width  = (int)(media_width_value_->value() * units[media_units_->value()]);
    length = (int)(media_length_value_->value() * units[media_units_->value()]);
  }
  else if (strcasecmp(name, "letter") == 0)
  {
    width  = 612;
    length = 792;
  }
  else if (strcasecmp(name, "a4") == 0)
  {
    width  = 595;
    length = 842;
  }
  else
  {
    width  = 0;
    length = 0;
  }
}


//
// 'Fl_Print_Dialog::ppd_cb()' - Handle PPD UI conflicts...
//

void
Fl_Print_Dialog::ppd_cb(Fl_Widget *w,		// I - Widget
                        void      *d)		// I - Option
{
#ifdef HAVE_LIBCUPS
  int			i;			// Looping var
  Fl_Choice		*choice = (Fl_Choice *)w;
						// Current choice
  Fl_Print_Dialog	*pd = (Fl_Print_Dialog *)(w->parent()->user_data());
						// Print dialog
  ppd_file_t		*ppd = (ppd_file_t *)(pd->ppd_);
						// PPD file
  ppd_option_t		*ppdopt = (ppd_option_t *)d;
						// Option
  Fl_Color		c;			// Color to use


  // Mark this option as selected...
  ppdMarkOption(ppd, ppdopt->keyword, ppdopt->choices[choice->value()].choice);

  // See if there are any conflicts...
  for (i = 0; i < pd->ppd_scroll_->children(); i ++)
  {
    w = pd->ppd_scroll_->child(i);

    if (w == &(pd->ppd_scroll_->scrollbar) ||
        w == &(pd->ppd_scroll_->hscrollbar))
      continue;

    choice = (Fl_Choice *)w;
    ppdopt = (ppd_option_t *)w->user_data();

    if (ppdopt->conflicted)
      c = FL_RED;
    else
      c = FL_BLACK;

    if (w->labelcolor() != c)
    {
      w->labelcolor(c);
      pd->ppd_scroll_->redraw();
    }
  }
#endif // HAVE_LIBCUPS
}


//
// 'Fl_Print_Dialog::print_file()' - Print the named file.
//

int
Fl_Print_Dialog::print_file(const char *f)	// I - File to print
{
#ifdef HAVE_LIBCUPS
  int		i;				// Looping var
  int		num_dests;			// Number of destinations
  cups_dest_t	*dests,				// Destinations
		*dest;				// Current destination
  int		num_options;			// Number of options
  cups_option_t	*options;			// Options
  int		id;				// Job ID
  char		s[255];				// Print quality
  Fl_Widget	*w;				// Current widget
  Fl_Choice	*choice;			// Current choice widget
  ppd_option_t	*ppdopt;			// Current option


  // Get the destination list...
  num_dests = cupsGetDests(&dests);
  dest      = cupsGetDest(printer(), NULL, num_dests, dests);

  if (dest)
  {
    // Copy options from this destination...
    for (i = 0, num_options = 0; i < dest->num_options; i ++)
      num_options = cupsAddOption(dest->options[i].name,
                                  dest->options[i].value,
				  num_options, &options);

    // Set standard options...
    num_options = cupsAddOption("PageSize", media(), num_options, &options);

    sprintf(s, "%d", quality_chooser_->value() + 3);
    num_options = cupsAddOption("print-quality", s, num_options, &options);

    // Set options from the PPD file...
    for (i = 0; i < ppd_scroll_->children(); i ++)
    {
      w = ppd_scroll_->child(i);

      if (w == &(ppd_scroll_->scrollbar) ||
          w == &(ppd_scroll_->hscrollbar))
	continue;

      choice = (Fl_Choice *)w;
      ppdopt = (ppd_option_t *)w->user_data();

      if (strcmp(ppdopt->defchoice,
                 ppdopt->choices[choice->value()].choice) != 0)
        num_options = cupsAddOption(ppdopt->keyword,
	                            ppdopt->choices[choice->value()].choice,
				    num_options, &options);
    }

    // Print the file...
    id = cupsPrintFile(printer(), f, "flphoto images", num_options, options);

    cupsFreeOptions(num_options, options);
  }
  else
    id = 0;

  // Free the destination list...
  cupsFreeDests(num_dests, dests);

  // Remove the temporary print file...
  unlink(f);

  // Return the job ID...
  return (id);
#else
  FILE	*fp;					// Pipe to lp
  char	command[1024],				// Print command
	status[1024],				// Print status
	*ptr;					// Pointer into status


  // Create the print command...
  if (access("/etc/printcap", 0))
    snprintf(command, sizeof(command),
             "lp -d%s -c -omedia=%s -oprint-quality=%d %s",
             printer(), media(), quality_chooser_->value() + 3, f);
  else
    snprintf(command, sizeof(command), "lpr -P %s %s", printer(), f);

  // Try printing...
  if ((fp = popen(command, "r")) == NULL)
  {
    unlink(f);
    return (0);
  }

  // Get the print status...
  status[0] = '\0';
  fgets(status, sizeof(status), fp);

  pclose(fp);

  // Remove the temporary print file...
  unlink(f);

  // Return the job ID...
  if ((ptr = strrchr(status, '-')) != NULL)
    return (atoi(ptr + 1));
  else if (status[0])
    return (0);
  else
    return (1);
#endif // HAVE_LIBCUPS
}


//
// 'Fl_Print_Dialog::printer()' - Set the output printer.
//

void
Fl_Print_Dialog::printer(const char *p)		// I - Printer name
{
  int		i;				// Looping var


  for (i = 0; i < (printer_chooser_->size() - 1); i ++)
    if (strcmp(p, printer_chooser_->text(i)) == 0)
      break;

  if (i >= (printer_chooser_->size() - 1))
    return;

  printer_chooser_->value(i);

  printer_cb();
}


//
// 'Fl_Print_Dialog::progress_show()' - Show the progress meter...
//

void
Fl_Print_Dialog::progress_show(int        percent,
						// Percent complete
                               const char *format,
						// Format string
			       ...)		// Additional args as needed
{
  va_list	ap;				// Argument list


  // Set the progress value...
  progress_->value(percent);
  progress_->show();

  // Format the label string...
  va_start(ap, format);
  vsnprintf(progress_label_, sizeof(progress_label_), format, ap);
  va_end(ap);

  // Update the label and redraw...
  progress_->label(progress_label_);
  Fl::check();
}


//
// 'Fl_Print_Dialog::which()' - Set which images to print.
//

void
Fl_Print_Dialog::which(int w)			// I - Which value
{
  switch (w)
  {
    case PRINT_ALL :
        print_all_button_->setonly();
	break;

    case PRINT_SELECTED :
        print_selected_button_->setonly();
	break;

    default :
        print_current_button_->setonly();
	break;
  }
}


//
// 'Fl_Print_Dialog::which()' - Get which images to print.
//

int						// O - Which value
Fl_Print_Dialog::which()
{
  if (print_all_button_->value())
    return (PRINT_ALL);
  else if (print_selected_button_->value())
    return (PRINT_SELECTED);
  else
    return (PRINT_CURRENT);
}


//
// End of "$Id: Fl_Print_Dialog2.cxx,v 1.31 2003/09/07 11:10:52 easysw Exp $".
//
