//
// "$Id: main.cxx,v 1.19 2003/09/08 14:52:09 easysw Exp $"
//
// FLTK photo program main entry.
//
// Copyright 2002-2003 by Michael Sweet.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Contents:
//
//   main() - Main entry for flphoto.
//

#include "flphoto.h"
#include "i18n.h"
#include "Fl_CRW_Image.H"
#include "Fl_PCD_Image.H"
#include <FL/filename.H>
#include "i18n.h"


#ifdef __sgi
#  include <FL/fl_draw.H>

#define BORDER_WIDTH	3
#define D1		BORDER_WIDTH
#define D2		(BORDER_WIDTH+BORDER_WIDTH)


void sgi_up_frame(int x, int y, int w, int h, Fl_Color) {
  fl_frame("AAAAWWJJUTNN",x,y,w,h);
}


void sgi_up_box(int x, int y, int w, int h, Fl_Color c) {
  sgi_up_frame(x,y,w,h,c);
  fl_color(c); fl_rectf(x+D1, y+D1, w-D2, h-D2);
}

void sgi_down_frame(int x, int y, int w, int h, Fl_Color) {
  fl_frame("NNTUJJWWAAAA",x,y,w,h);
}

void sgi_down_box(int x, int y, int w, int h, Fl_Color c) {
  sgi_down_frame(x,y,w,h,c);
  fl_color(c); fl_rectf(x+D1, y+D1, w-D2, h-D2);
}
#endif // __sgi


//
// 'main()' - Main entry for flphoto.
//

int					// O - Exit status
main(int  argc,				// I - Number of command-line arguments
     char *argv[])			// I - Command-line arguments
{
  int		i;			// Looping var
  flphoto	*app = 0,		// Current application window
		*album = 0;		// Current album window
  float		val;			// Gamma value


  // Localize things...
  fl_yes    = _("Yes");
  fl_no     = _("No");
  fl_ok     = _("OK");
  fl_cancel = _("Cancel");
  fl_close  = _("Close");

  Fl_File_Chooser::add_favorites_label    = _("Add to Favorites");
  Fl_File_Chooser::all_files_label        = _("All Files (*)");
  Fl_File_Chooser::custom_filter_label    = _("Custom Filter");
  Fl_File_Chooser::existing_file_label    = _("Please choose an existing file!");
  Fl_File_Chooser::favorites_label        = _("Favorites");
  Fl_File_Chooser::filename_label         = _("Filename:");
  Fl_File_Chooser::filesystems_label      = _("File Systems");
  Fl_File_Chooser::manage_favorites_label = _("Manage Favorites");
  Fl_File_Chooser::new_directory_label    = _("New Directory?");
  Fl_File_Chooser::preview_label          = _("Preview");
  Fl_File_Chooser::show_label             = _("Show:");

#ifndef __sgi
  // Set the UI scheme, defaulting to "plastic" because it looks better.
  Fl::get_system_colors();

  if (getenv("FLTK_SCHEME"))
    Fl::scheme(NULL);
  else
    Fl::scheme("plastic");
#endif // !__sgi

  // Register all image formats...
  fl_register_images();
  Fl_Shared_Image::add_handler(Fl_PCD_Image::check);
  Fl_Shared_Image::add_handler(Fl_CRW_Image::check);

  flphoto::prefs.get("gamma", val, 2.2);
  Fl_Image_Display::set_gamma(val);

  // Loop through the command-line looking for albums, files, and
  // directories.
  for (i = 1; i < argc; i ++)
  {
    if (fl_filename_match(argv[i], "*.album"))
    {
      album = new flphoto(argv[i]);
      album->show_last_image();
      album->show();
    }
    else if (!app)
    {
      app = new flphoto(argv[i]);
      app->show();
    }
    else
      app->open_album(argv[i]);
  }

  // Create an empty album if no files are provided on the command-line.
  if (!app && !album)
  {
    app = new flphoto();
    app->show();
  }

  if (app)
    app->show_last_image();

  // Optionally show the license agreement...
  flphoto::prefs.get("license_version", i, 0);

  if (i < FLPHOTO_VERNUMBER)
  {
    flphoto::prefs.set("license_version", FLPHOTO_VERNUMBER);
    flphoto::help_cb("license.html");
  }

#ifdef __sgi
  Fl::scheme("sgi");

  Fl::set_boxtype(FL_UP_FRAME,        sgi_up_frame, D1, D1, D2, D2);
  Fl::set_boxtype(FL_DOWN_FRAME,      sgi_down_frame, D1, D1, D2, D2);
  Fl::set_boxtype(FL_THIN_UP_FRAME,   sgi_up_frame, D1, D1, D2, D2);
  Fl::set_boxtype(FL_THIN_DOWN_FRAME, sgi_down_frame, D1, D1, D2, D2);

  Fl::set_boxtype(FL_UP_BOX,          sgi_up_box, D1, D1, D2, D2);
  Fl::set_boxtype(FL_DOWN_BOX,        sgi_down_box, D1, D1, D2, D2);
  Fl::set_boxtype(FL_THIN_UP_BOX,     sgi_up_box, D1, D1, D2, D2);
  Fl::set_boxtype(FL_THIN_DOWN_BOX,   sgi_down_box, D1, D1, D2, D2);

  Fl::set_boxtype(FL_FREE_BOXTYPE, FL_ROUND_UP_BOX);
  Fl::set_boxtype(FL_ROUND_UP_BOX, FL_ROUND_DOWN_BOX);
  Fl::set_boxtype(FL_ROUND_DOWN_BOX, FL_FREE_BOXTYPE);

  Fl::foreground(0x00, 0x00, 0x00);
  Fl::background(0xd0, 0xd0, 0xd0);
  Fl::background2(0xc0, 0xc0, 0xc0);
  Fl::set_color(FL_SELECTION_COLOR, 0xff, 0xff, 0xff);
#endif // __sgi

  // Run the app until the user quits...
  return (Fl::run());
}


//
// End of "$Id: main.cxx,v 1.19 2003/09/08 14:52:09 easysw Exp $".
//
