//
// "$Id: gamma.cxx,v 1.2 2003/01/26 19:58:33 easysw Exp $"
//
// Gamma calibration methods.
//
// Copyright 2002-2003 by Michael Sweet.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Contents:
//
//   flphoto::gamma_cb()        - Show the gamma window.
//   flphoto::gamma_ok_cb()     - Accept gamma changes.
//   flphoto::gamma_slider_cb() - Update the gamma image.
//

#include "flphoto.h"
#include <stdio.h>
#include <stdlib.h>
#include "flstring.h"
#include <ctype.h>
#include <errno.h>
#include <math.h>


//
// 'flphoto::gamma_cb()' - Show the gamma window.
//

void
flphoto::gamma_cb()
{
  float	val;					// Gamma value


  gamma_window_->hotspot(gamma_window_);
  gamma_window_->show();

  prefs.get("gamma", val, 2.2);
  gamma_slider_->value(val);

  gamma_slider_cb();
}


//
// 'flphoto::gamma_ok_cb()' - Accept gamma changes.
//

void
flphoto::gamma_ok_cb()
{
  float		val;				// Gamma value
  flphoto	*album;				// Looping var


  // Hide the calibration window...
  gamma_window_->hide();

  // Save the new gamma setting...
  val = gamma_slider_->value();

  prefs.set("gamma", val);
  Fl_Image_Display::set_gamma(val);

  // Tell all of the album windows to redraw...
  for (album = album_first_; album; album = album->album_next_)
    album->display_->redraw();
}


//
// 'flphoto::gamma_slider_cb()' - Update the gamma image.
//

void
flphoto::gamma_slider_cb()
{
  int	x, y;					// Coordinates in image
  float	val;					// Gamma value
  uchar	g,					// Gamma-adjusted value
	*ptr;					// Pointer into image


  if (!gamma_image_)
  {
    gamma_image_ = new Fl_RGB_Image(gamma_data_, 150, 150, 1);
    gamma_box_->image(gamma_image_);
  }

  val = 1.0 / gamma_slider_->value();

  memset(gamma_data_, 255, sizeof(gamma_data_));

  for (y = 0, ptr = gamma_data_; y < 150; y ++, ptr += 150)
  {
    for (x = 0; x < 150; x += 2)
      ptr[x] = 0;

    if (y >= 40 && y < 110)
    {
      g = (int)(255.0 * pow(0.5, val) + 0.5);

      for (x = 40; x < 110; x ++)
	ptr[x] = g;
    }
  }

  gamma_image_->uncache();
  gamma_box_->redraw();
}


//
// End of "$Id: gamma.cxx,v 1.2 2003/01/26 19:58:33 easysw Exp $".
//
