#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>
#include <math.h>
#include "fnccheck.h"

/* we perform the calls ourself */
void __cyg_profile_func_enter(void *this_fn, void *call_site);
void __cyg_profile_func_exit(void *this_fn, void *call_site);
/* macros for enter/exit */
#define _ENTER_(s,c)  if (activate_lib) {nb_of_func++;__cyg_profile_func_enter((void*)s,(void*)c);}
#define _LEAVE_(s,c)  if (activate_lib) {nb_of_func++;__cyg_profile_func_exit((void*)s,(void*)c);}


/* the enter point in the test functions */
void enter_test(void);

/* this program perform calls to enter/exit treatments
   of the fnccheck lib in order to compute the
   average overcost of the lib treatments.             */

/* true if the lib is activated */
int activate_lib=0;
/* number of functions */
int nb_of_func=0;

/* usage ! */
void usage(char *name)
{
  printf("FunctionCheck-Average by Hexasoft (January 2001)\n");
  printf("Compute average overcost generated by the\n");
  printf("  FunctionCheck library.\n\n");
  printf("Usage: %s [nb|--help|--version]\n", name);
  printf("Options:  --help     : this message\n");
  printf("          --version  : prog version\n");
  printf("          nb         : set the # of calls performed\n");
  printf("\n");
}


int main(int argc, char *argv[])
{
  struct timeval tv1, tv2, tv3, tv4;
  int nb=256;   /* number of calls */
  int i;
  double run1, run2;
  unsigned long temp;

  /* get the number of calls */
  if (argc >= 2)
    {
    if (strcmp(argv[1], "--help") == 0)
      {
      usage(argv[0]);
      return(0);
      }
    if (strcmp(argv[1], "--version") == 0)
      {
      printf("V1.0\n");
      return(0);
      }
    sscanf(argv[1], "%d", &nb);
    if (nb < 16)
      nb = 16;
    }

  printf("fncaverage by Hexasoft (January 2001)\n\n");

  /* call tests w/o the lib */
  activate_lib = 0;
  gettimeofday(&tv1, NULL);
  for(i=0; i<nb; i++)
    enter_test();
  gettimeofday(&tv2, NULL);

  /* call tests w the lib */
  nb_of_func = 1;    /* first is the faked main */
  activate_lib = 1;
  _ENTER_(1,0);  /* fake 'main()' */
  /* the ENTER is outside the 'gettimeofday' because
     it would count the 'init' time for the
     'time per function', and it is not pertinent... */
  gettimeofday(&tv3, NULL);
  for(i=0; i<nb; i++)
    enter_test();
  gettimeofday(&tv4, NULL);
  _LEAVE_(1,0);  /* fake 'main()' */

  /* compute running time */
  if (tv1.tv_sec == tv2.tv_sec)
    {
    run1 = (tv2.tv_usec - tv1.tv_usec)/1000000.;
    }
  else
    {
    run1 = (double)tv2.tv_sec - tv1.tv_sec;
    temp = tv2.tv_usec + 1000000-tv1.tv_usec;
    if (temp >= 1000000)
      {
      run1 += 1.;
      temp -= 1000000;
      }
    run1 += temp/1000000.;
    }
  if (tv3.tv_sec == tv4.tv_sec)
    {
    run2 = (tv4.tv_usec - tv3.tv_usec)/1000000.;
    }
  else
    {
    run2 = (double)tv4.tv_sec - tv3.tv_sec;
    temp = tv4.tv_usec + 1000000-tv3.tv_usec;
    if (temp >= 1000000)
      {
      run2 += 1.;
      temp -= 1000000;
      }
    run2 += temp/1000000.;
    }

  /* display % */
  printf("Execution time without 'fnccheck'   : %f\n", run1);
  printf("Time per function without 'fnccheck': %f\n", run1/nb_of_func);
  printf("Execution time with 'fnccheck'      : %f\n", run2);
  printf("Time per function with 'fnccheck'   : %f\n", run2/nb_of_func);
  printf("Percentage: %f\n", 100.*run2/run1);
  printf("Average overcost per function       : %f (%f us)\n",
                  run2/nb_of_func-run1/nb_of_func, 1000000.*(run2/nb_of_func-run1/nb_of_func));
  printf("(computed with %d calls)\n\n", nb_of_func);

  /* done */
  return(0);
}



/* this part is a set of test functions for the lib */

void f_long()
{
  double l1=0., l2=1., lr=0;
  int i;

  _ENTER_(3,0);
  for(i=0; i<10; i++)
    {
    l1 += cos(cos(i*3.14159));
    l2 += sin(sin(i*3.14159+1.1));
    lr = sin(cos(l1 + l2));
    }
  _LEAVE_(3,0);
}

void f_loong()
{
  double l1=0., l2=1., lr=0;
  int i;
  
  _ENTER_(4,0);
  for(i=0; i<100; i++)
    {
    l1 += sin(cos(i*3.14159));
    l2 += cos(sin(i*3.14159+1.1));
    lr = cos(cos(l1 + l2));
    }
  _LEAVE_(4,0);
}

void f_looong()
{
  double l1=0., l2=1., lr=0;
  int i;
  
  _ENTER_(5,0);
  for(i=0; i<1000; i++)
    {
    l1 += sin(sin(cos(i*3.14159)));
    l2 += cos(cos(sin(i*3.14159+1.1)));
    lr = cos(cos(l1 + l2))*sin(sin(l1 + l2));
    }
  _LEAVE_(5,0);
}

void f_small()
{
  double x;

  _ENTER_(6,0);
  x = 3.14;
  x *= x;
  _LEAVE_(6,0);
}

void f_f0()
{
  float x;

  _ENTER_(10,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(10,0);
}
void f_f1()
{
  float x;

  _ENTER_(11,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(11,0);
}
void f_f2()
{
  float x;

  _ENTER_(12,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(12,0);
}
void f_f3()
{
  float x;

  _ENTER_(13,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(13,0);
}
void f_f4()
{
  float x;

  _ENTER_(14,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(14,0);
}
void f_f5()
{
  float x;

  _ENTER_(15,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(15,0);
}
void f_f6()
{
  float x;

  _ENTER_(16,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(16,0);
}
void f_f7()
{
  float x;

  _ENTER_(17,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(17,0);
}
void f_f8()
{
  float x;

  _ENTER_(18,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(18,0);
}
void f_f9()
{
  float x;

  _ENTER_(19,0);
  x = 3.14159;
  x += 1.;
  _LEAVE_(19,0);
}

void f_recurs(int n)
{
  _ENTER_(99,0);
  if (n <= 0)
    return;
  f_small();
  f_recurs(n-1);
  _LEAVE_(99,0);
}

void f_t0()
{
  _ENTER_(20,0);
  _LEAVE_(20,0);
}

void f_t1()
{
  double x;

  _ENTER_(21,0);
  x = 1.;
  f_t0();
  _LEAVE_(21,0);
}
void f_t2()
{
  double x;

  _ENTER_(22,0);
  x = 1.;
  f_t1();
  _LEAVE_(22,0);
}
void f_t3()
{
  double x;

  _ENTER_(23,0);
  x = 1.;
  f_t2();
  _LEAVE_(23,0);
}
void f_t4()
{
  double x;

  _ENTER_(24,0);
  x = 1.;
  f_t3();
  _LEAVE_(24,0);
}
void f_t5()
{
  double x;

  _ENTER_(25,0);
  x = 1.;
  f_t4();
  _LEAVE_(25,0);
}
void f_t6()
{
  double x;

  _ENTER_(26,0);
  x = 1.;
  f_t5();
  _LEAVE_(26,0);
}

void f_numb(int n)
{
  double x;

  _ENTER_((128+n),0);
  x = 2.;
  _LEAVE_((128+n),0);
}

void enter_test()
{
  int i;

  _ENTER_(2,0);

  /* generates many functions */
  for(i=0; i<128; i++)
    f_numb(i);
  /* a recursive call */
  f_recurs(512);
  /* a simple sequence */
  for(i=0; i<128; i++)
    f_t6();
  /* some long functions */
  for(i=0; i<128; i++)
    f_long();
  for(i=0; i<64; i++)
    f_loong();
  for(i=0; i<32; i++)
    f_looong();
  /* some small one */
  for(i=0; i<32; i++)
    f_small();

  /* that's all */
  _LEAVE_(2,0);
}
 
