/* fooseti
 * Copyright (c) 2001 Adam Gorski
 *
 * This file is part of fooseti.
 *
 * fooseti is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * fooseti is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with fooseti; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include <../config.h>

static GtkWidget* about = NULL;

static void destroy_about(gchar* version)
{
  if (about)
    gtk_widget_destroy(about);
  about = NULL;
} // destroy_about()

void show_about(GtkWidget* w, gpointer data)
{ 
  if(!about) {
    GtkWidget* content;
    GtkWidget* author;
    GtkWidget* version;
    GtkWidget* website;
    GtkWidget* close;
    GtkWidget* contentBox;
    GtkWidget* mainBox;
    GtkWidget* buttonBox;
    GtkWidget* separator;

   /* create all the widgets */

    about = gtk_window_new(GTK_WINDOW_DIALOG);
    version = gtk_label_new("fooseti " VERSION);
    content = gtk_label_new("fooseti is a simple Seti@Home monitoring program. "
        "It has been written mainly as a practice of GTK, but has turned out "
        "rather well and seems useful. Enjoy");
    author = gtk_label_new("Adam D. Gorski <agorski@engin.umich.edu>");
    website = gtk_label_new("http://www-personal.engin.umich.edu/~agorski/fooseti");
    close = gtk_button_new_with_label("Close");
    separator = gtk_hseparator_new();

    gtk_label_set_line_wrap(GTK_LABEL(content), TRUE);
    gtk_label_set_justify(GTK_LABEL(content), GTK_JUSTIFY_FILL);
  
    contentBox = gtk_vbox_new(FALSE, 0);
    mainBox = gtk_vbox_new(FALSE, 0);
    buttonBox = gtk_hbox_new(FALSE, 0);
  
    /* pack the first contentBox */

    gtk_box_pack_start(GTK_BOX(contentBox), version, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(contentBox), content, FALSE, FALSE, 10);
    gtk_box_pack_start(GTK_BOX(contentBox), website, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(contentBox), author, FALSE, FALSE, 0);

    /* pack the buttonBox */

    gtk_box_pack_start(GTK_BOX(buttonBox), close, TRUE, TRUE, 0);
  
    /* pack the first contentBox and the buttonBox into the mainBox */

    gtk_box_pack_start(GTK_BOX(mainBox), contentBox, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(mainBox), separator, FALSE, FALSE, 10);
    gtk_box_pack_start(GTK_BOX(mainBox), buttonBox, FALSE, FALSE, 0);
    
    gtk_window_set_title(GTK_WINDOW(about), "About " PACKAGE);

    gtk_container_set_border_width(GTK_CONTAINER(about), 10);

    gtk_container_add(GTK_CONTAINER(about), mainBox);

    gtk_signal_connect(GTK_OBJECT(about),
                       "delete_event",
                       GTK_SIGNAL_FUNC(destroy_about),
                       NULL);

    gtk_signal_connect(GTK_OBJECT(close),
                       "clicked",
                       GTK_SIGNAL_FUNC(destroy_about),
                       NULL);

    gtk_widget_show_all(about);
  } // if about isn't already shown
} // show_about()
