/* fooseti
 * Copyright (c) 2001 Adam Gorski
 *
 * This file is part of fooseti.
 *
 * fooseti is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * fooseti is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with fooseti; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include "fooseti.h"
#include "error.h"

static GtkWidget* errorWindow = NULL;

static void destroy_error()
{
  if (errorWindow)
    gtk_widget_destroy(errorWindow);
  errorWindow = NULL;
} // destroy_error()

void show_error(Errors error)
{
  if (!errorWindow) {
    GtkWidget* errorLabel;
    GtkWidget* ok;
    GtkWidget* errorBox;
    GtkWidget* separator;

    errorWindow = gtk_window_new(GTK_WINDOW_DIALOG);
    errorLabel = gtk_label_new(NULL);
    ok = gtk_button_new_with_label("Ok");
    errorBox = gtk_vbox_new(FALSE, 0);
    separator = gtk_hseparator_new();

    switch (error) {
      case NULLPATH: gtk_label_set_text(GTK_LABEL(errorLabel), "Unable to run the client! Please specify a "
                                                               "correct path by clicking on 'Preferences'");
        break;

      case NOCONFIG: gtk_label_set_text(GTK_LABEL(errorLabel), "No configuration file was found! Please create "
                                                               "one by clicking on 'Preferences'");
        break;

      case NOUSER: gtk_label_set_text(GTK_LABEL(errorLabel), "Cannot open User Info file!\n"
                                                             "Make sure the correct path is specified under "
                                                             "'Preferences', and if this error persists, run the "
                                                             "Seti client from the command line to see what "
                                                             "the problem is");
        break;

      case NOSTATE: gtk_label_set_text(GTK_LABEL(errorLabel), "Cannot open State file!\n"
                                                              "Make sure the correct path is specified under "
                                                              "'Preferences', and if this error persists, run the "
                                                              "Seti client from the command line to see what "
                                                              "the problem is. Usually a missing State file "
                                                              "means that Seti cannot connect to the central "
                                                              "server to obtain a new packet. Check your "
                                                              "internet connection, check the Seti@home webpage "
                                                              "for their server status, or just wait and try again "
                                                              "later.");
        break;

      case NOCLIENT: gtk_label_set_text(GTK_LABEL(errorLabel), "No Seti client found in the specified path! "
                                                               "Make sure the path and the binary name are "
                                                               "specified correctly under 'Preferences'");
        break;

      case CONFRERR: gtk_label_set_text(GTK_LABEL(errorLabel), "Error reading configuration file!\n"
                                                               "Try checking under 'Preferences'");

      case FILERERR: gtk_label_set_text(GTK_LABEL(errorLabel), "Error reading Seti files!\n"
                                                               "Try again in a minute or two."
                                                               "If the problem persists, run the client"
                                                               "from the command line to see what is wrong");
    } // errors switch

    gtk_label_set_line_wrap(GTK_LABEL(errorLabel), TRUE);

    gtk_signal_connect(GTK_OBJECT(ok),
                       "clicked",
                       GTK_SIGNAL_FUNC(destroy_error),
                       NULL);

    gtk_box_pack_start(GTK_BOX(errorBox), errorLabel, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(errorBox), separator, FALSE, FALSE, 10);
    gtk_box_pack_start(GTK_BOX(errorBox), ok, FALSE, FALSE, 0);

    gtk_container_add(GTK_CONTAINER(errorWindow), errorBox);

    gtk_window_set_modal(GTK_WINDOW(errorWindow), TRUE);

    gtk_container_set_border_width(GTK_CONTAINER(errorWindow), 10);

    gtk_widget_show_all(errorWindow);
  } // if the errorWindow doesn't exist
} // show_error()
