/* fooseti
 * Copyright (c) 2001 Adam Gorski
 *
 * This file is part of fooseti.
 *
 * fooseti is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * fooseti is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with fooseti; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>
#include "fooseti.h"
#include "fileIO.h"
#include "error.h"
#include "../config.h"

extern void show_about();
extern void show_prefs();
static void runstop_cb();
static gint quit_cb();
static gint update_display();
void update_window();
void update_timeout();

static GtkWidget* window;
static GtkWidget* name;
static GtkWidget* packet;
static GtkWidget* gtime;
static GtkWidget* atime;
static GtkWidget* user_label;
static GtkWidget* packcomp_label;
static GtkWidget* curpack_label;
static GtkWidget* total_time_label;
static GtkWidget* average_time_label;
static GtkWidget* quit_button;
static GtkWidget* prefs_button;
static GtkWidget* runstop_button;
static GtkWidget* runstop_label;
static GtkWidget* about_button;
static GtkWidget* progressBar;
static GtkWidget* separator;
static GtkWidget* nameBox;
static GtkWidget* packetBox;
static GtkWidget* aTimeBox;
static GtkWidget* tTimeBox;
static GtkWidget* barBox;
static GtkWidget* buttonBox;
static GtkWidget* mainBox;

int
main(int argc, char* argv[])
{
  if (argc > 1) {
    if (!g_strcasecmp(argv[1],"-v")) {
      g_print("%s %s\n",PACKAGE, VERSION);
      exit(1);
    } // if version is requested

    else {
      g_print("invalid argument!\n"
              "\toptions:\n"
              "\t\t-v  version\n\n");
      exit(1);
    } // else, if argument is invalid
  } // if command line arguments are present
  
  gtk_init(&argc, &argv);
  
  /* Create the config file path */
  
  seti.configpath = g_strdup_printf("%s/.fooseti", getenv("HOME"));

  /* Initialize the data structure, read config file */

  init(); // simple, but works

  if (seti.update == 0)
    seti.update = 10;

  /* Initialize all dem purty widgets */
  
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  name = gtk_label_new(data.user);
  packet = gtk_label_new(data.packet);
  gtime = gtk_label_new(data.time);
  atime = gtk_label_new(data.atime);
  user_label = gtk_label_new("User: ");
  packcomp_label = gtk_label_new("Packets Completed: ");
  curpack_label = gtk_label_new("Current Packet: ");
  average_time_label = gtk_label_new("Average Time: ");
  total_time_label = gtk_label_new("Total Time: ");
  quit_button = gtk_button_new_with_label("Quit");
  prefs_button = gtk_button_new_with_label("Preferences");
  runstop_button = gtk_button_new();
  about_button = gtk_button_new_with_label("About");
  progressBar = gtk_progress_bar_new();  
  separator = gtk_hseparator_new();
    
  if(checkStatus()) {
    /* create the progress bar */
    gtk_progress_set_percentage(GTK_PROGRESS(progressBar), data.packetStatus);
    gtk_progress_set_format_string(GTK_PROGRESS(progressBar), "%p%% complete");
    /* create the button label */
    runstop_label = gtk_label_new("Stop");
  } // if the client is running

  else {
    gtk_progress_set_percentage(GTK_PROGRESS(progressBar), 0);
    gtk_progress_set_format_string(GTK_PROGRESS(progressBar), "Client Stopped");
    runstop_label = gtk_label_new("Run");
  } // else if it's stopped
  
  gtk_progress_set_show_text(GTK_PROGRESS(progressBar), TRUE);
  gtk_container_add(GTK_CONTAINER(runstop_button), runstop_label);
  
  /* create the boxes */

  mainBox = gtk_vbox_new(FALSE, 0);  
  nameBox = gtk_hbox_new(FALSE, 0);
  packetBox = gtk_hbox_new(FALSE, 0);
  aTimeBox = gtk_hbox_new(FALSE, 0);
  tTimeBox = gtk_hbox_new(FALSE, 0);
  barBox = gtk_hbox_new(FALSE, 0);
  buttonBox = gtk_hbox_new(FALSE, 0);
  
  /* pack the first hbox */

  gtk_box_pack_start(GTK_BOX(nameBox), user_label, FALSE, FALSE, 1);
  gtk_box_pack_start(GTK_BOX(nameBox), name, FALSE, FALSE, 1);

  if (options.name)
    gtk_widget_show_all(nameBox);

  /* pack the second hbox */

  gtk_box_pack_start(GTK_BOX(packetBox), packcomp_label, FALSE, FALSE, 1);
  gtk_box_pack_start(GTK_BOX(packetBox), packet, FALSE, FALSE, 1);

  if (options.packet)
    gtk_widget_show_all(packetBox);

  /* pack the third hbox */

  gtk_box_pack_start(GTK_BOX(aTimeBox), average_time_label, FALSE, FALSE, 1);
  gtk_box_pack_start(GTK_BOX(aTimeBox), atime, FALSE, FALSE, 1);

  if (options.atime)
    gtk_widget_show_all(aTimeBox);

  /* pack the fourth hbox */

  gtk_box_pack_start(GTK_BOX(tTimeBox), total_time_label, FALSE, FALSE, 1);
  gtk_box_pack_start(GTK_BOX(tTimeBox), gtime, FALSE, FALSE, 1);

  if (options.time)
    gtk_widget_show_all(tTimeBox);

  /* pack the fifth hbox */

  gtk_box_pack_start(GTK_BOX(barBox), curpack_label, FALSE, FALSE, 1);
  gtk_box_pack_start(GTK_BOX(barBox), progressBar, TRUE, TRUE, 1);

  gtk_widget_show_all(barBox);

  /* pack the sixth hbox */

  gtk_box_pack_start(GTK_BOX(buttonBox), runstop_button, TRUE, TRUE, 1);
  gtk_box_pack_start(GTK_BOX(buttonBox), prefs_button, TRUE, TRUE, 1);
  gtk_box_pack_start(GTK_BOX(buttonBox), about_button, TRUE, TRUE, 1);
  gtk_box_pack_start(GTK_BOX(buttonBox), quit_button, TRUE, TRUE, 1);
  
  gtk_widget_show_all(buttonBox);

  /* pack the mainBox */

  gtk_box_pack_start(GTK_BOX(mainBox), nameBox, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(mainBox), packetBox, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(mainBox), aTimeBox, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(mainBox), tTimeBox, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(mainBox), barBox, FALSE, FALSE, 5);
  gtk_box_pack_start(GTK_BOX(mainBox), separator, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(mainBox), buttonBox, FALSE, FALSE, 0);

  gtk_widget_show(separator);
  gtk_widget_show(mainBox);

  /* set attribs for main window */

  gtk_container_add(GTK_CONTAINER(window), mainBox);
  
  gtk_window_set_title(GTK_WINDOW(window), "fooseti");
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, TRUE);
  gtk_container_set_border_width(GTK_CONTAINER(window), 5);

  /* connect signals */

  gtk_signal_connect(GTK_OBJECT(window),
                     "delete_event",
                     GTK_SIGNAL_FUNC(quit_cb),
                     NULL);

  gtk_signal_connect(GTK_OBJECT (runstop_button),
                    "clicked",
                     GTK_SIGNAL_FUNC (runstop_cb),
                     NULL);

  gtk_signal_connect(GTK_OBJECT (quit_button),
                     "clicked",
                     GTK_SIGNAL_FUNC (quit_cb),
                     NULL);

  gtk_signal_connect(GTK_OBJECT(about_button),
                     "clicked",
                     GTK_SIGNAL_FUNC(show_about),
                     NULL);

  gtk_signal_connect(GTK_OBJECT(prefs_button),
                     "clicked",
                     GTK_SIGNAL_FUNC(show_prefs),
                     NULL);
  
  /* this timeout calls the update_display() function ever UPDATE_TIME msec */

  seti.toid = gtk_timeout_add((seti.update * 60000), (GtkFunction) update_display, NULL);

  /* Yeah :) */
  
  gtk_widget_show(window);
  gtk_main();
  
  /* Make the program play nice */

  g_free(data.user);
  g_free(data.packet);
  g_free(data.args);
  g_free(data.time);
  g_free(data.atime);
  g_free(seti.client);
  g_free(seti.userpath);
  g_free(seti.statepath);
  g_free(seti.pidpath);
  g_free(seti.configpath);
  g_free(seti.path);

  return 0;
} // main()

/* quit_cb() is called when 'quit' is pressed or wm sends destroy signal */

static gint
quit_cb() 
{
  if (checkStatus()) {
    if (options.exit)
      stopClient(); // stop it if we stop on exit
  } // if client is running upon exit

  gtk_main_quit();

  return FALSE;
} // quit_cb()

/* update_display() is called every N minutes by the timeout that we set
   before. It's also called whenever the update_window() function is called,
   just cause it seems like the right thing to do.. right? */

static gint
update_display()
{
  if(checkStatus()) {
    update();
    gtk_label_set_text(GTK_LABEL(name), data.user);
    gtk_label_set_text(GTK_LABEL(packet), data.packet);
    gtk_label_set_text(GTK_LABEL(atime), data.atime);
    gtk_label_set_text(GTK_LABEL(gtime), data.time);
    gtk_progress_set_percentage(GTK_PROGRESS(progressBar), data.packetStatus);
  } // if the client is running

  else {
    gtk_label_set_text(GTK_LABEL(runstop_label), "Run");
    gtk_progress_set_percentage(GTK_PROGRESS(progressBar), 0);
    gtk_progress_set_format_string(GTK_PROGRESS(progressBar), "Client Stopped");
  } // else if it is stopped

  return TRUE;
} // update_display()

/* runstop_cb() is called when the start/stop button is pressed. We check
   to see if the client is running, if it is stop it, if it isn't, start it.
   We update the display accordingly.. even if client is started, it might
   just exit (ex. if --version is an argument), so we check to see if it stays
   running before we update the display to say so. 
   ** NOTE **
   If the RWSPEED is not long enough, we will check to see if the client is
   running, and might see that it's not even though it's getting started..
   this is all based on the time it takes the program to check for the 
   status versus the time it takes the PC to start the client and update
   the pid file. I can't think of a way to fix this right now
*/

static void
runstop_cb()
{  
  if(checkStatus()) {
    stopClient();
    gtk_label_set_text(GTK_LABEL(runstop_label), "Run");
    gtk_progress_set_percentage(GTK_PROGRESS(progressBar), 0);
    gtk_progress_set_format_string(GTK_PROGRESS(progressBar), "Client Stopped");
  } // if the client is running

  else {
    runClient();

    if(checkStatus()) {
      gtk_label_set_text(GTK_LABEL(name), data.user);
      gtk_label_set_text(GTK_LABEL(packet), data.packet);
      gtk_label_set_text(GTK_LABEL(atime), data.atime);
      gtk_label_set_text(GTK_LABEL(gtime), data.time);
      gtk_label_set_text(GTK_LABEL(runstop_label), "Stop");
      gtk_progress_set_percentage(GTK_PROGRESS(progressBar), data.packetStatus);
      gtk_progress_set_format_string(GTK_PROGRESS(progressBar), "%p%% complete");
    } // needed if, for instance, -version is passed as arg
  } // else if the client is not running
} // runstop_cb()

/* update_window() gets called when 'ok' is clicked in the preferences
   dialog. This just checks to see which display option is set and compares
   that with which feature is visible and shows/hides them based on that. */

void
update_window()
{
  update_display();

  if (options.name && !GTK_WIDGET_VISIBLE(nameBox))
    gtk_widget_show_all(nameBox);
  else
    if (!options.name && GTK_WIDGET_VISIBLE(nameBox))
      gtk_widget_hide_all(nameBox);

  if (options.packet && !GTK_WIDGET_VISIBLE(packetBox))
    gtk_widget_show_all(packetBox);
  else
    if (!options.packet && GTK_WIDGET_VISIBLE(packetBox))
      gtk_widget_hide_all(packetBox);

  if (options.atime && !GTK_WIDGET_VISIBLE(aTimeBox))
    gtk_widget_show_all(aTimeBox);
  else
    if (!options.atime && GTK_WIDGET_VISIBLE(aTimeBox))
      gtk_widget_hide_all(aTimeBox);

  if (options.time && !GTK_WIDGET_VISIBLE(tTimeBox))
    gtk_widget_show_all(tTimeBox);
  else
    if (!options.time && GTK_WIDGET_VISIBLE(tTimeBox))
      gtk_widget_hide_all(tTimeBox);

} // update window

/* update_timeout() is called if we change the time between the automatic
   updates. There is no gtk_timeout_update() function, so we have to remove
   the old timeout and add a new one. */

void
update_timeout()
{
  gtk_timeout_remove(seti.toid);
  seti.toid = gtk_timeout_add((seti.update * 60000), (GtkFunction) update_display, NULL);
} // update_timeout()
