/* fooseti
 * Copyright (c) 2001 Adam Gorski
 *
 * This file is part of fooseti.
 *
 * fooseti is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * fooseti is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with fooseti; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef FOOSETI_H
#define FOOSETI_H
#include <gtk/gtk.h>

/* set the RWSPEED value to something larger if fooseti isn't working properly.
   Specifically, if the client starts but the display isn't updated to say
   so, or if you stop it and it stops but doesn't appear so */

#define RWSPEED 300000 // 300 milliseconds

struct userData
{
  gchar* user;
  gchar* packet;
  gdouble packetStatus;
  gchar* args;
  gchar* atime;
  gchar* time;
};

struct setiClient
{
  gchar* client;
  gchar* path;
  gchar* userpath;
  gchar* statepath;
  gchar* configpath;
  gchar* pidpath;
  gint pid;
  gint update;
  guint toid;
};

struct optionsStruct
{
  int name;
  int packet;
  int time;
  int atime;
  int exit;
};

struct userData data;
struct setiClient seti;
struct optionsStruct options;

#endif /* FOOSETI_H */
