/* fooseti
 * Copyright (c) 2001 Adam Gorski
 *
 * This file is part of fooseti.
 *
 * fooseti is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * fooseti is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with fooseti; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include "fooseti.h"
#include "fileIO.h"
#include "error.h"

extern void update_display();
extern void update_timeout();

static GtkWidget* prefs = NULL;
static GtkWidget* path;
static GtkWidget* args;
static GtkWidget* client;
static GtkWidget* name_check;
static GtkWidget* packet_check;
static GtkWidget* atime_check;
static GtkWidget* time_check;
static GtkWidget* exit_check;
static GtkWidget* updateSpin;

static void
destroy_prefs()
{
  if (prefs)
    gtk_widget_destroy(prefs);
  prefs = NULL;
} // destroy_prefs()

static void
save_prefs()
{
  FILE* configfile;
  gint running = checkStatus();
  gint restart = 0;
  gint changed = 0;
  
  if (seti.path != NULL) {
    if ((g_strcasecmp(seti.path, gtk_entry_get_text(GTK_ENTRY(path)))) ||
        (g_strcasecmp(data.args, gtk_entry_get_text(GTK_ENTRY(args)))) ||
        (g_strcasecmp(seti.client, gtk_entry_get_text(GTK_ENTRY(client)))))
    {
      changed = 1;

      if (running) {
        stopClient();
        restart = 1;
      } // if we have to restart the client
    } // if the path or args changed at all
  } // if the path isn't null

  else {
    if (g_strcasecmp("", gtk_entry_get_text(GTK_ENTRY(path))))
      changed = 1;
  } // else, if path is NULL but user input a new path

  /* update display and client behavior based on toggle buttons */
  
  options.name = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(name_check));
  options.packet = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(packet_check));
  options.atime = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(atime_check));
  options.time = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(time_check));
  options.exit = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(exit_check));

  if (seti.update != gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(updateSpin))); {
    seti.update = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(updateSpin));
    update_timeout();
  } // if the update time has changed
  
  if(!(configfile = fopen(seti.configpath, "w"))) {
    show_error(NOCONFIG);
  } // if we can't open the file

  else {
    fprintf(configfile, "path=%s\n", gtk_entry_get_text(GTK_ENTRY(path)));
    fprintf(configfile, "args=%s\n", gtk_entry_get_text(GTK_ENTRY(args)));
    fprintf(configfile, "client=%s\n", gtk_entry_get_text(GTK_ENTRY(client)));
    fprintf(configfile, "name=%d\n", options.name);
    fprintf(configfile, "packet=%d\n", options.packet);
    fprintf(configfile, "atime=%d\n", options.atime);
    fprintf(configfile, "time=%d\n", options.time);
    fprintf(configfile, "exit=%d\n", options.exit);
    fprintf(configfile, "update=%d\n", seti.update);
  } // else if the config gets opened

  fclose(configfile);

  if (changed)
    init();

  update_window();

  if(restart)
    runClient();
} // save_prefs()

void
show_prefs()
{
  if (!prefs) {
    GtkWidget* path_label;
    GtkWidget* args_label;
    GtkWidget* update_label;
    GtkWidget* client_label;
    GtkWidget* ok;
    GtkWidget* cancel;
    GtkWidget* pathBox;
    GtkWidget* argsBox;
    GtkWidget* displayBox;
    GtkWidget* buttonBox;
    GtkWidget* optionsBox;
    GtkWidget* clientBox;
    GtkWidget* updateBox;
    GtkWidget* clientOptionsBox;
    GtkWidget* toggleBoxL;
    GtkWidget* toggleBoxR;
    GtkWidget* mainBox;
    GtkWidget* clientFrame;
    GtkWidget* displayFrame;
    GtkObject* updateAdjustment;

    prefs = gtk_window_new(GTK_WINDOW_DIALOG);
    path = gtk_entry_new();
    path_label = gtk_label_new("Path to Seti directory: ");
    args = gtk_entry_new();
    args_label = gtk_label_new("Arguments passed to Seti: ");
    client = gtk_entry_new();
    client_label = gtk_label_new("Name of Seti binary: ");
    update_label = gtk_label_new("minutes between status updates");
    ok = gtk_button_new_with_label("Ok");
    cancel = gtk_button_new_with_label("Cancel");
    name_check = gtk_check_button_new_with_label("Show user name");
    packet_check = gtk_check_button_new_with_label("Show packets completed");
    atime_check = gtk_check_button_new_with_label("Show average packet time");
    time_check = gtk_check_button_new_with_label("Show total CPU time");
    exit_check = gtk_check_button_new_with_label("Stop client on exit");

    /* create the spin button */
    
    updateAdjustment = gtk_adjustment_new(seti.update, 1, 60, 1, 1, 1);
    updateSpin = gtk_spin_button_new(GTK_ADJUSTMENT(updateAdjustment), 1, 0);  
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(updateSpin), TRUE);
    
    optionsBox = gtk_vbox_new(FALSE, 0);
    toggleBoxL = gtk_vbox_new(FALSE, 0);
    toggleBoxR = gtk_vbox_new(FALSE, 0);
    mainBox = gtk_vbox_new(FALSE, 0);
    pathBox = gtk_hbox_new(FALSE, 0);
    argsBox = gtk_hbox_new(FALSE, 0);
    clientBox = gtk_hbox_new(FALSE, 0);
    updateBox = gtk_hbox_new(FALSE, 0);
    clientOptionsBox = gtk_hbox_new(FALSE, 0);
    displayBox = gtk_hbox_new(FALSE, 0);
    buttonBox = gtk_hbox_new(TRUE, 5);
    clientFrame = gtk_frame_new("Client Options");
    displayFrame = gtk_frame_new("Display Options");

    if (seti.path != NULL)
      gtk_entry_set_text(GTK_ENTRY(path), seti.path);
    if (data.args != NULL)
      gtk_entry_set_text(GTK_ENTRY(args), data.args);

    if (seti.client != NULL)
      gtk_entry_set_text(GTK_ENTRY(client), seti.client);
    else
      gtk_entry_set_text(GTK_ENTRY(client), "setiathome");

    if (options.name)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(name_check), TRUE);
    if (options.packet)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(packet_check), TRUE);
    if (options.time)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(time_check), TRUE);
    if (options.atime)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(atime_check), TRUE);
    if (options.exit)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(exit_check), TRUE);

    gtk_box_pack_start(GTK_BOX(pathBox), path_label, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(pathBox), path, TRUE, TRUE, 5);

    gtk_box_pack_start(GTK_BOX(argsBox), args_label, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(argsBox), args, TRUE, TRUE, 5);

    gtk_box_pack_start(GTK_BOX(clientBox), client_label, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(clientBox), client, TRUE, TRUE, 5);

    gtk_box_pack_start(GTK_BOX(clientOptionsBox), exit_check, FALSE, FALSE, 5);

    gtk_box_pack_start(GTK_BOX(updateBox), updateSpin, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(updateBox), update_label, FALSE, FALSE, 0);

    gtk_box_pack_start(GTK_BOX(optionsBox), pathBox, FALSE, FALSE, 2);
    gtk_box_pack_start(GTK_BOX(optionsBox), argsBox, FALSE, FALSE, 2);
    gtk_box_pack_start(GTK_BOX(optionsBox), clientBox, FALSE, FALSE, 2);
    gtk_box_pack_start(GTK_BOX(optionsBox), clientOptionsBox, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(optionsBox), updateBox, FALSE, FALSE, 5);
    
    gtk_box_pack_start(GTK_BOX(toggleBoxL), name_check, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(toggleBoxL), packet_check, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(toggleBoxR), atime_check, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(toggleBoxR), time_check, FALSE, FALSE, 0);

    gtk_box_pack_start(GTK_BOX(displayBox), toggleBoxL, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(displayBox), toggleBoxR, FALSE, FALSE, 5);
    
    gtk_container_add(GTK_CONTAINER(clientFrame), optionsBox);
    gtk_container_add(GTK_CONTAINER(displayFrame), displayBox);

    gtk_box_pack_start(GTK_BOX(buttonBox), ok, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(buttonBox), cancel, TRUE, TRUE, 1);
    
    gtk_box_pack_start(GTK_BOX(mainBox), clientFrame, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(mainBox), displayFrame, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(mainBox), buttonBox, FALSE, FALSE, 5);
  
    gtk_container_add(GTK_CONTAINER(prefs), mainBox);

    gtk_container_set_border_width(GTK_CONTAINER(prefs), 5);

    gtk_window_set_title(GTK_WINDOW(prefs), "Preferences");
    
    /* Connect the signals */

    gtk_signal_connect(GTK_OBJECT(prefs),
                       "delete_event",
                       GTK_SIGNAL_FUNC(destroy_prefs),
                       NULL);

    gtk_signal_connect(GTK_OBJECT(cancel),
                       "clicked",
                       GTK_SIGNAL_FUNC(destroy_prefs),
                       NULL);

    gtk_signal_connect(GTK_OBJECT(ok),
                       "clicked",
                       GTK_SIGNAL_FUNC(save_prefs),
                       NULL);

    gtk_signal_connect_after(GTK_OBJECT(ok),
                             "clicked",
                             GTK_SIGNAL_FUNC(destroy_prefs),
                             NULL);

    gtk_widget_show_all(prefs);
  } // if prefs window doesn't exits
}
