#!/bin/sh
# Run this to generate all the initial makefiles, etc.

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

PKG_NAME="the package."

(test -f $srcdir/configure.in) || {
    echo -n "**Error**: Directory "\`$srcdir\'" does not look like the"
    echo " top-level directory"
    exit 1
}

#workaround in case gnome-common's gnome-autogen.sh wrongly uses gettextize
gettextize () { autopoint --force; }

gnome_autogen="`gnome-config --bindir`/gnome-autogen.sh"

if [ -f $gnome_autogen ]; then
	. $gnome_autogen $*
else
	# Redhat hack.
	gnome_autogen="`gnome-config --datadir`/glade/gnome/autogen.sh"
	echo "gnome_autogen = $gnome_autogen"
	if [ -f $gnome_autogen ]; then
		export ACLOCAL_FLAGS="-I /usr/share/glade/gnome"
		. $gnome_autogen $*
	else
		echo "Could not find gnome-autogen.sh"
	fi
fi

