// C/C++ Headers

#include <string.h>
#include <iostream.h>
#include <iomanip.h>

// Local Headers

#include "ComplexNodePrintArg.h"
#include "ComplexNode.h"

ComplexNodePrintArg::ComplexNodePrintArg(const ComplexNode *node) :
   mNode(node)
{
}

ComplexNodePrintArg::~ComplexNodePrintArg()
{
   delete (ComplexNode *)mNode;
}

void ComplexNodePrintArg::execute(ostream &out)  const
{
   dcomplex value = mNode->evaluate();

   out << setprecision(10) <<
      "[" << __REAL(value) << ", " << __IMAG(value) << "]";
}

ostream & ComplexNodePrintArg::print(ostream &out) const
{
   return(mNode->print(out));
}
