// C/C++ Headers

#include <string.h>
#include <iostream.h>
#include <iomanip.h>

// Local Headers

#include "DoubleNodePrintArg.h"
#include "DoubleNode.h"

DoubleNodePrintArg::DoubleNodePrintArg(const DoubleNode *node) :
   mNode(node)
{
}

DoubleNodePrintArg::~DoubleNodePrintArg()
{
   delete (DoubleNode *)mNode;
}

void DoubleNodePrintArg::execute(ostream &out)  const
{
   double value = mNode->evaluate();
   out << setprecision(10) << value;
}

ostream & DoubleNodePrintArg::print(ostream &out) const
{
   return(mNode->print(out));
}
