// C/C++ Headers

#include <iostream.h>

// Local Headers

#include "NotRegionNode.h"

NotRegionNode::NotRegionNode(const RegionNode *node)
   :
   mNode(node)
{
}

NotRegionNode::~NotRegionNode()
{
   delete (RegionNode *)mNode;
}

int NotRegionNode::contains(const ComplexNode *point) const
{
   return(!mNode->contains(point));
}

ostream &NotRegionNode::print(ostream &out) const
{
   out << "r_not(";

   mNode->print(out);

   return(out << ")");
}
