// C/C++ Headers

#include <iostream.h>

// Local Headers

#include "NumericComplexNode.h"
#include "ConstantDoubleNode.h"

NumericComplexNode::NumericComplexNode(
   const DoubleNode *realPart,
   const DoubleNode *imaginaryPart
)  :
   mReal(realPart),
   mImaginary(imaginaryPart)
{
   if(!mImaginary)
      mImaginary = new ConstantDoubleNode(0.0);
}

NumericComplexNode::~NumericComplexNode()
{
   delete (DoubleNode *)mReal;
   delete (DoubleNode *)mImaginary;
}

dcomplex NumericComplexNode::evaluate() const
{
   dcomplex value(
      mReal->evaluate(), mImaginary->evaluate()
   );

   return(value);
}

ostream &NumericComplexNode::print(ostream &out) const
{
   out << "[";
   mReal->print(out);
   out << ", ";
   mImaginary->print(out);
   out << "]";

   return(out);
}
