// C/C++ Headers

#include <iostream.h>

// Local Headers

#include "OrRegionNode.h"

OrRegionNode::OrRegionNode(
   const RegionNode *first, const RegionNode *second
)  :
   mFirst(first),
   mSecond(second)
{
}

OrRegionNode::~OrRegionNode()
{
   delete (RegionNode *)mFirst;
   delete (RegionNode *)mSecond;
}

int OrRegionNode::contains(
   const ComplexNode *point
)  const
{
   return(
      mFirst->contains(point) || mSecond->contains(point)
   );
}

ostream &OrRegionNode::print(ostream &out) const
{
   out << "r_or(";
   mFirst->print(out);
   out << ", ";
   mSecond->print(out);
   return(out << ")");
}
